/*
 * Decompiled with CFR 0.152.
 */
package eu.toop.edm.request;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import eu.toop.edm.model.ConceptPojo;
import eu.toop.edm.request.IEDMRequestPayloadConcepts;
import eu.toop.edm.slot.SlotConceptRequestList;
import eu.toop.regrep.slot.ISlotProvider;
import java.util.List;
import javax.annotation.Nonnull;

public class EDMRequestPayloadConcepts
implements IEDMRequestPayloadConcepts {
    private final ICommonsList<ConceptPojo> m_aConcepts = new CommonsArrayList<ConceptPojo>();

    public EDMRequestPayloadConcepts(@Nonnull @Nonempty ICommonsList<ConceptPojo> iCommonsList) {
        ValueEnforcer.notEmpty(iCommonsList, "Concepts");
        this.m_aConcepts.addAll(iCommonsList);
    }

    @Override
    @Nonnull
    @ReturnsMutableObject
    public final List<ConceptPojo> concepts() {
        return this.m_aConcepts;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public final List<ConceptPojo> getAllConcepts() {
        return (List)this.m_aConcepts.getClone();
    }

    @Override
    @Nonnull
    public ISlotProvider getAsSlotProvider() {
        return new SlotConceptRequestList(this.m_aConcepts);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        EDMRequestPayloadConcepts eDMRequestPayloadConcepts = (EDMRequestPayloadConcepts)object;
        return EqualsHelper.equals(this.m_aConcepts, eDMRequestPayloadConcepts.m_aConcepts);
    }

    public int hashCode() {
        return ((HashCodeGenerator)new HashCodeGenerator(this).append(this.m_aConcepts)).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("Concepts", this.m_aConcepts).getToString();
    }
}

