/*
 * Decompiled with CFR 0.152.
 */
package eu.toop.regrep.helper;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.MustImplementEqualsAndHashcode;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
@MustImplementEqualsAndHashcode
public final class VocabularyTerm
implements Serializable {
    private final String m_sVocabulary;
    private final String m_sTerm;

    public VocabularyTerm(@Nonnull @Nonempty String string, @Nonnull @Nonempty String string2) {
        ValueEnforcer.notEmpty(string, "Vocabulary");
        ValueEnforcer.notEmpty(string2, "Term");
        this.m_sVocabulary = string;
        this.m_sTerm = string2;
    }

    @Nonnull
    @Nonempty
    public String getVocabulary() {
        return this.m_sVocabulary;
    }

    public boolean hasVocabulary(@Nullable String string) {
        return this.m_sVocabulary.equals(string);
    }

    @Nonnull
    @Nonempty
    public String getTerm() {
        return this.m_sTerm;
    }

    public boolean hasTerm(@Nullable String string) {
        return this.m_sTerm.equals(string);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        VocabularyTerm vocabularyTerm = (VocabularyTerm)object;
        return this.m_sVocabulary.equals(vocabularyTerm.m_sVocabulary) && this.m_sTerm.equals(vocabularyTerm.m_sTerm);
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_sVocabulary).append(this.m_sTerm).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(null).append("Vocabulary", this.m_sVocabulary).append("Term", this.m_sTerm).getToString();
    }
}

