/*
 * Decompiled with CFR 0.152.
 */
package eu.toop.regrep.query;

import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import eu.toop.regrep.query.ResponseOptionType;
import eu.toop.regrep.rim.QueryType;
import eu.toop.regrep.rs.RegistryRequestType;
import java.math.BigInteger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="", propOrder={"responseOption", "query"})
@XmlRootElement(name="QueryRequest")
@CodingStyleguideUnaware
public class QueryRequest
extends RegistryRequestType {
    @XmlElement(name="ResponseOption", required=true)
    private ResponseOptionType responseOption;
    @XmlElement(name="Query", required=true)
    private QueryType query;
    @XmlAttribute(name="federated")
    private Boolean federated;
    @XmlAttribute(name="federation")
    @XmlSchemaType(name="anyURI")
    private String federation;
    @XmlAttribute(name="format")
    private String format;
    @XmlAttribute(name="lang", namespace="http://www.w3.org/XML/1998/namespace")
    private String lang;
    @XmlAttribute(name="startIndex")
    private BigInteger startIndex;
    @XmlAttribute(name="maxResults")
    private BigInteger maxResults;
    @XmlAttribute(name="depth")
    private BigInteger depth;
    @XmlAttribute(name="matchOlderVersions")
    private Boolean matchOlderVersions;

    @Nullable
    public ResponseOptionType getResponseOption() {
        return this.responseOption;
    }

    public void setResponseOption(@Nullable ResponseOptionType responseOptionType) {
        this.responseOption = responseOptionType;
    }

    @Nullable
    public QueryType getQuery() {
        return this.query;
    }

    public void setQuery(@Nullable QueryType queryType) {
        this.query = queryType;
    }

    public boolean isFederated() {
        if (this.federated == null) {
            return false;
        }
        return this.federated;
    }

    public void setFederated(@Nullable Boolean bl) {
        this.federated = bl;
    }

    @Nullable
    public String getFederation() {
        return this.federation;
    }

    public void setFederation(@Nullable String string) {
        this.federation = string;
    }

    @Nullable
    public String getFormat() {
        if (this.format == null) {
            return "application/ebrim+xml";
        }
        return this.format;
    }

    public void setFormat(@Nullable String string) {
        this.format = string;
    }

    @Nullable
    public String getLang() {
        return this.lang;
    }

    public void setLang(@Nullable String string) {
        this.lang = string;
    }

    @Nullable
    public BigInteger getStartIndex() {
        if (this.startIndex == null) {
            return new BigInteger("0");
        }
        return this.startIndex;
    }

    public void setStartIndex(@Nullable BigInteger bigInteger) {
        this.startIndex = bigInteger;
    }

    @Nullable
    public BigInteger getMaxResults() {
        if (this.maxResults == null) {
            return new BigInteger("-1");
        }
        return this.maxResults;
    }

    public void setMaxResults(@Nullable BigInteger bigInteger) {
        this.maxResults = bigInteger;
    }

    @Nullable
    public BigInteger getDepth() {
        if (this.depth == null) {
            return new BigInteger("0");
        }
        return this.depth;
    }

    public void setDepth(@Nullable BigInteger bigInteger) {
        this.depth = bigInteger;
    }

    public boolean isMatchOlderVersions() {
        if (this.matchOlderVersions == null) {
            return false;
        }
        return this.matchOlderVersions;
    }

    public void setMatchOlderVersions(@Nullable Boolean bl) {
        this.matchOlderVersions = bl;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        QueryRequest queryRequest = (QueryRequest)object;
        if (!EqualsHelper.equals(this.depth, queryRequest.depth)) {
            return false;
        }
        if (!EqualsHelper.equals(this.federated, queryRequest.federated)) {
            return false;
        }
        if (!EqualsHelper.equals(this.federation, queryRequest.federation)) {
            return false;
        }
        if (!EqualsHelper.equals(this.format, queryRequest.format)) {
            return false;
        }
        if (!EqualsHelper.equals(this.lang, queryRequest.lang)) {
            return false;
        }
        if (!EqualsHelper.equals(this.matchOlderVersions, queryRequest.matchOlderVersions)) {
            return false;
        }
        if (!EqualsHelper.equals(this.maxResults, queryRequest.maxResults)) {
            return false;
        }
        if (!EqualsHelper.equals(this.query, queryRequest.query)) {
            return false;
        }
        if (!EqualsHelper.equals(this.responseOption, queryRequest.responseOption)) {
            return false;
        }
        return EqualsHelper.equals(this.startIndex, queryRequest.startIndex);
    }

    @Override
    public int hashCode() {
        return HashCodeGenerator.getDerived(super.hashCode()).append(this.depth).append(this.federated).append(this.federation).append(this.format).append(this.lang).append(this.matchOlderVersions).append(this.maxResults).append(this.query).append(this.responseOption).append(this.startIndex).getHashCode();
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("depth", this.depth).append("federated", this.federated).append("federation", this.federation).append("format", this.format).append("lang", this.lang).append("matchOlderVersions", this.matchOlderVersions).append("maxResults", this.maxResults).append("query", this.query).append("responseOption", this.responseOption).append("startIndex", this.startIndex).getToString();
    }

    public void cloneTo(@Nonnull QueryRequest queryRequest) {
        super.cloneTo(queryRequest);
        queryRequest.depth = this.depth;
        queryRequest.federated = this.federated;
        queryRequest.federation = this.federation;
        queryRequest.format = this.format;
        queryRequest.lang = this.lang;
        queryRequest.matchOlderVersions = this.matchOlderVersions;
        queryRequest.maxResults = this.maxResults;
        queryRequest.query = this.query == null ? null : this.query.clone();
        queryRequest.responseOption = this.responseOption == null ? null : this.responseOption.clone();
        queryRequest.startIndex = this.startIndex;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public QueryRequest clone() {
        QueryRequest queryRequest = new QueryRequest();
        this.cloneTo(queryRequest);
        return queryRequest;
    }
}

