/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS.tools;

import java.util.Iterator;
import org.xbill.DNS.Lookup;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;
import org.xbill.DNS.TSIG;
import org.xbill.DNS.ZoneTransferIn;

public class xfrin {
    private static void usage(String s) {
        System.out.println("Error: " + s);
        System.out.println("usage: xfrin [-i serial] [-k keyname/secret] [-s server] [-p port] [-f] zone");
        System.exit(1);
    }

    public static void main(String[] args) throws Exception {
        int arg;
        TSIG key = null;
        int ixfr_serial = -1;
        String server = null;
        int port = 53;
        boolean fallback = false;
        for (arg = 0; arg < args.length; ++arg) {
            if (args[arg].equals("-i")) {
                if ((ixfr_serial = Integer.parseInt(args[++arg])) >= 0) continue;
                xfrin.usage("invalid serial number");
                continue;
            }
            if (args[arg].equals("-k")) {
                String s;
                int index;
                if ((index = (s = args[++arg]).indexOf(47)) < 0) {
                    xfrin.usage("invalid key");
                }
                key = new TSIG(s.substring(0, index), s.substring(index + 1));
                continue;
            }
            if (args[arg].equals("-s")) {
                server = args[++arg];
                continue;
            }
            if (args[arg].equals("-p")) {
                if ((port = Integer.parseInt(args[++arg])) >= 0 && port <= 65535) continue;
                xfrin.usage("invalid port");
                continue;
            }
            if (args[arg].equals("-f")) {
                fallback = true;
                continue;
            }
            if (!args[arg].startsWith("-")) break;
            xfrin.usage("invalid option");
        }
        if (arg >= args.length) {
            xfrin.usage("no zone name specified");
        }
        Name zname = Name.fromString(args[arg]);
        if (server == null) {
            Lookup l = new Lookup(zname, 2);
            Record[] ns = l.run();
            if (ns == null) {
                System.out.println("failed to look up NS record: " + l.getErrorString());
                System.exit(1);
            }
            server = ns[0].rdataToString();
            System.out.println("sending to server '" + server + "'");
        }
        ZoneTransferIn xfrin2 = ixfr_serial >= 0 ? ZoneTransferIn.newIXFR(zname, ixfr_serial, fallback, server, port, key) : ZoneTransferIn.newAXFR(zname, server, port, key);
        xfrin2.run();
        if (xfrin2.isAXFR()) {
            if (ixfr_serial >= 0) {
                System.out.println("AXFR-like IXFR response");
            } else {
                System.out.println("AXFR response");
            }
            for (Record record : xfrin2.getAXFR()) {
                System.out.println(record);
            }
        } else if (xfrin2.isIXFR()) {
            System.out.println("IXFR response");
            for (ZoneTransferIn.Delta delta : xfrin2.getIXFR()) {
                System.out.println("delta from " + delta.start + " to " + delta.end);
                System.out.println("deletes");
                Iterator<Record> it2 = delta.deletes.iterator();
                while (it2.hasNext()) {
                    System.out.println(it2.next());
                }
                System.out.println("adds");
                it2 = delta.adds.iterator();
                while (it2.hasNext()) {
                    System.out.println(it2.next());
                }
            }
        } else if (xfrin2.isCurrent()) {
            System.out.println("up to date");
        }
    }
}

