/*
 * Decompiled with CFR 0.152.
 */
package eu.toop.connector.app;

import com.helger.commons.debug.GlobalDebug;
import com.helger.commons.error.level.EErrorLevel;
import com.helger.commons.error.level.IErrorLevel;
import com.helger.commons.exception.InitializationException;
import com.helger.commons.id.factory.GlobalIDFactory;
import com.helger.commons.id.factory.IStringIDFactory;
import com.helger.commons.id.factory.StringIDFromGlobalPersistentLongIDFactory;
import com.helger.commons.string.StringHelper;
import com.helger.commons.url.URLHelper;
import com.helger.commons.url.URLProtocolRegistry;
import com.helger.xservlet.requesttrack.RequestTracker;
import eu.toop.connector.api.TCConfig;
import eu.toop.connector.api.me.MessageExchangeManager;
import eu.toop.connector.api.me.incoming.IMEIncomingHandler;
import eu.toop.connector.app.CTC;
import eu.toop.connector.app.TCIncomingHandlerViaHttp;
import eu.toop.kafkaclient.ToopKafkaClient;
import eu.toop.kafkaclient.ToopKafkaSettings;
import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.servlet.ServletContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public final class TCInit {
    private static final Logger LOGGER = LoggerFactory.getLogger(TCInit.class);
    private static final AtomicBoolean INITED = new AtomicBoolean(false);
    private static String s_sLogPrefix;

    private TCInit() {
    }

    @Deprecated
    public static void initGlobally(@Nonnull ServletContext servletContext) {
        TCInit.initGlobally(servletContext, null);
    }

    public static void initGlobally(@Nonnull ServletContext servletContext, @Nullable IMEIncomingHandler iMEIncomingHandler) {
        Object object;
        Object object2;
        String string;
        if (!INITED.compareAndSet(false, true)) {
            throw new IllegalStateException("TOOP Connector NG is already initialized");
        }
        GlobalIDFactory.setPersistentStringIDFactory((IStringIDFactory)new StringIDFromGlobalPersistentLongIDFactory("toop-tc-"));
        GlobalDebug.setDebugModeDirect((boolean)TCConfig.Global.isGlobalDebug());
        GlobalDebug.setProductionModeDirect((boolean)TCConfig.Global.isGlobalProduction());
        String string2 = TCConfig.Global.getToopInstanceName();
        if (StringHelper.hasNoText((String)string2)) {
            try {
                string2 = "[" + InetAddress.getLocalHost().getHostAddress() + "] ";
            }
            catch (UnknownHostException unknownHostException) {
                string2 = "";
            }
        } else {
            if (!string2.startsWith("[")) {
                string2 = "[" + string2 + "]";
            }
            string2 = string2 + " ";
        }
        s_sLogPrefix = string2;
        RequestTracker.getInstance().getRequestTrackingMgr().setLongRunningCheckEnabled(false);
        RequestTracker.getInstance().getRequestTrackingMgr().setParallelRunningRequestCheckEnabled(false);
        ToopKafkaSettings.setKafkaEnabled((boolean)TCConfig.Tracker.isToopTrackerEnabled());
        if (TCConfig.Tracker.isToopTrackerEnabled()) {
            string = TCConfig.Tracker.getToopTrackerUrl();
            if (StringHelper.hasNoText((String)string)) {
                throw new InitializationException("If the tracker is enabled, the tracker URL MUST be provided in the configuration file!");
            }
            object2 = URLProtocolRegistry.getInstance().getProtocol(string);
            if (object2 != null) {
                throw new InitializationException("The tracker URL MUST NOT start with a protocol like '" + object2.getProtocol() + "'!");
            }
            ToopKafkaSettings.defaultProperties().put((Object)"bootstrap.servers", (Object)string);
            object = TCConfig.Tracker.getToopTrackerTopic();
            ToopKafkaSettings.setKafkaTopic((String)object);
        }
        if (StringHelper.hasNoText((String)(string = TCConfig.DSD.getDSDBaseUrl()))) {
            throw new InitializationException("The URL of the DSD Service is missing in the configuration file!");
        }
        if (!TCConfig.R2D2.isR2D2UseDNS()) {
            object2 = TCConfig.R2D2.getR2D2StaticEndpointURL();
            object = TCConfig.R2D2.getR2D2StaticCertificate();
            if (URLHelper.getAsURL((String)object2) != null && object != null) {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("Using static R2D2 target endpoint '" + (String)object2 + "'");
                }
            } else {
                URI uRI = TCConfig.R2D2.getR2D2SMPUrl();
                if (uRI != null) {
                    if (LOGGER.isInfoEnabled()) {
                        LOGGER.info("Using static R2D2 SMP address '" + uRI.toString() + "'");
                    }
                } else {
                    throw new InitializationException("Since the usage of SML/DNS is disabled, the fixed URL of the SMP or the static parameters to be used must be provided in the configuration file!");
                }
            }
        }
        string = iMEIncomingHandler != null ? iMEIncomingHandler : new TCIncomingHandlerViaHttp(s_sLogPrefix);
        MessageExchangeManager.getConfiguredImplementation().registerIncomingHandler(servletContext, (IMEIncomingHandler)string);
        ToopKafkaClient.send((IErrorLevel)EErrorLevel.INFO, () -> s_sLogPrefix + "TOOP Connector NG WebApp " + CTC.getVersionNumber() + " started");
    }

    public static boolean isInitialized() {
        return INITED.get();
    }

    public static void shutdownGlobally(@Nonnull ServletContext servletContext) {
        if (!TCInit.isInitialized()) {
            throw new IllegalStateException("TOOP Connector NG is not initialized");
        }
        ToopKafkaClient.send((IErrorLevel)EErrorLevel.INFO, () -> s_sLogPrefix + "TOOP Connector NG shutting down");
        MessageExchangeManager.getConfiguredImplementation().shutdown(servletContext);
        ToopKafkaClient.close();
        s_sLogPrefix = null;
        if (!INITED.compareAndSet(true, false)) {
            throw new IllegalStateException("TOOP Connector NG was already shutdown");
        }
    }
}

