/*
 * Decompiled with CFR 0.152.
 */
package eu.toop.connector.app.api;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.collection.impl.ICommonsSet;
import com.helger.commons.collection.impl.ICommonsSortedMap;
import com.helger.peppolid.IDocumentTypeIdentifier;
import com.helger.peppolid.IParticipantIdentifier;
import com.helger.peppolid.IProcessIdentifier;
import com.helger.phive.api.executorset.VESID;
import com.helger.phive.api.result.ValidationResultList;
import com.helger.xsds.bdxr.smp1.EndpointType;
import com.helger.xsds.bdxr.smp1.ServiceMetadataType;
import eu.toop.connector.api.dsd.DSDDatasetResponse;
import eu.toop.connector.api.error.ITCErrorHandler;
import eu.toop.connector.api.error.LoggingTCErrorHandler;
import eu.toop.connector.api.me.IMessageExchangeSPI;
import eu.toop.connector.api.me.MessageExchangeManager;
import eu.toop.connector.api.me.model.MEMessage;
import eu.toop.connector.api.me.outgoing.IMERoutingInformation;
import eu.toop.connector.api.me.outgoing.MEOutgoingException;
import eu.toop.connector.app.api.TCAPIConfig;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class TCAPIHelper {
    public static final Locale DEFAULT_LOCALE = Locale.US;

    private TCAPIHelper() {
    }

    @Deprecated
    @Nonnull
    public static ICommonsSet<DSDDatasetResponse> getDSDDatasets(@Nonnull @Nonempty String string, @Nonnull @Nonempty String string2, @Nonnull ITCErrorHandler iTCErrorHandler) {
        return TCAPIHelper.getDSDDatasetsByCountry(string, string2, iTCErrorHandler);
    }

    @Nonnull
    public static ICommonsSet<DSDDatasetResponse> getDSDDatasetsByCountry(@Nonnull @Nonempty String string, @Nonnull @Nonempty String string2, @Nonnull ITCErrorHandler iTCErrorHandler) {
        return TCAPIConfig.getDSDDatasetResponseProvider().getAllDatasetResponsesByCountry("[dsd-by-country]", string, string2, iTCErrorHandler);
    }

    @Nonnull
    public static ICommonsSet<DSDDatasetResponse> getDSDDatasetsByDPType(@Nonnull @Nonempty String string, @Nonnull @Nonempty String string2, @Nonnull ITCErrorHandler iTCErrorHandler) {
        return TCAPIConfig.getDSDDatasetResponseProvider().getAllDatasetResponsesByDPType("[dsd-by-dptype]", string, string2, iTCErrorHandler);
    }

    @Nonnull
    public static ICommonsSortedMap<String, String> querySMPServiceGroups(@Nonnull IParticipantIdentifier iParticipantIdentifier) {
        return TCAPIConfig.getDDServiceGroupHrefProvider().getAllServiceGroupHrefs(iParticipantIdentifier, (ITCErrorHandler)LoggingTCErrorHandler.INSTANCE);
    }

    @Nullable
    public static ServiceMetadataType querySMPServiceMetadata(@Nonnull IParticipantIdentifier iParticipantIdentifier, @Nonnull IDocumentTypeIdentifier iDocumentTypeIdentifier, @Nonnull IProcessIdentifier iProcessIdentifier, @Nonnull String string) {
        return TCAPIConfig.getDDServiceMetadataProvider().getServiceMetadata(iParticipantIdentifier, iDocumentTypeIdentifier, iProcessIdentifier, string);
    }

    @Nullable
    public static EndpointType querySMPEndpoint(@Nonnull IParticipantIdentifier iParticipantIdentifier, @Nonnull IDocumentTypeIdentifier iDocumentTypeIdentifier, @Nonnull IProcessIdentifier iProcessIdentifier, @Nonnull String string) {
        return TCAPIConfig.getDDServiceMetadataProvider().getEndpoint(iParticipantIdentifier, iDocumentTypeIdentifier, iProcessIdentifier, string);
    }

    @Nonnull
    public static ValidationResultList validateBusinessDocument(@Nonnull VESID vESID, @Nonnull byte[] byArray) {
        return TCAPIConfig.getVSValidator().validate(vESID, byArray, DEFAULT_LOCALE);
    }

    public static void sendAS4Message(@Nonnull IMERoutingInformation iMERoutingInformation, @Nonnull MEMessage mEMessage) throws MEOutgoingException {
        IMessageExchangeSPI iMessageExchangeSPI = MessageExchangeManager.getConfiguredImplementation();
        iMessageExchangeSPI.sendOutgoing(iMERoutingInformation, mEMessage);
    }
}

