/*
 * Decompiled with CFR 0.152.
 */
package eu.toop.connector.app.dsd;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.collection.impl.CommonsHashSet;
import com.helger.commons.collection.impl.ICommonsSet;
import com.helger.commons.debug.GlobalDebug;
import com.helger.commons.error.level.EErrorLevel;
import com.helger.commons.error.level.IErrorLevel;
import com.helger.commons.string.ToStringGenerator;
import com.helger.httpclient.HttpClientSettings;
import eu.toop.connector.api.TCConfig;
import eu.toop.connector.api.dsd.DSDDatasetHelper;
import eu.toop.connector.api.dsd.DSDDatasetResponse;
import eu.toop.connector.api.dsd.IDSDDatasetResponseProvider;
import eu.toop.connector.api.error.ITCErrorHandler;
import eu.toop.connector.api.http.TCHttpClientSettings;
import eu.toop.dsd.client.DSDClient;
import eu.toop.edm.error.EToopErrorCode;
import eu.toop.edm.error.IToopErrorCode;
import eu.toop.kafkaclient.ToopKafkaClient;
import java.util.List;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DSDDatasetResponseProviderRemote
implements IDSDDatasetResponseProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(DSDDatasetResponseProviderRemote.class);
    private final String m_sBaseURL;

    public DSDDatasetResponseProviderRemote() {
        this(TCConfig.DSD.getDSDBaseUrl());
    }

    public DSDDatasetResponseProviderRemote(@Nonnull String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"BaseURL");
        this.m_sBaseURL = string;
    }

    @Nonnull
    @Nonempty
    public final String getBaseURL() {
        return this.m_sBaseURL;
    }

    @Nonnull
    public ICommonsSet<DSDDatasetResponse> getAllDatasetResponsesByCountry(@Nonnull String string, @Nonnull @Nonempty String string2, @Nonnull @Nonempty String string3, @Nonnull ITCErrorHandler iTCErrorHandler) {
        ICommonsSet iCommonsSet;
        DSDClient dSDClient = new DSDClient(this.m_sBaseURL);
        dSDClient.setHttpClientSettings((HttpClientSettings)new TCHttpClientSettings());
        try {
            List list = dSDClient.queryDatasetByLocation(string2, string3);
            iCommonsSet = DSDDatasetHelper.buildDSDResponseSet((List)list);
        }
        catch (RuntimeException runtimeException) {
            LOGGER.error(runtimeException.getMessage(), (Throwable)(GlobalDebug.isDebugMode() ? runtimeException : null));
            iTCErrorHandler.onError("Failed to query the DSD", (Throwable)runtimeException, (IToopErrorCode)EToopErrorCode.DD_001);
            iCommonsSet = new CommonsHashSet();
        }
        int n = iCommonsSet.size();
        ToopKafkaClient.send((IErrorLevel)EErrorLevel.INFO, () -> string + "DSD querying '" + string2 + "' and country code '" + string3 + "' lead to " + n + " result entries");
        return iCommonsSet;
    }

    @Nonnull
    public ICommonsSet<DSDDatasetResponse> getAllDatasetResponsesByDPType(@Nonnull String string, @Nonnull @Nonempty String string2, @Nonnull @Nonempty String string3, @Nonnull ITCErrorHandler iTCErrorHandler) {
        ICommonsSet iCommonsSet;
        DSDClient dSDClient = new DSDClient(this.m_sBaseURL);
        dSDClient.setHttpClientSettings((HttpClientSettings)new TCHttpClientSettings());
        try {
            List list = dSDClient.queryDatasetByDPType(string2, string3);
            iCommonsSet = DSDDatasetHelper.buildDSDResponseSet((List)list);
        }
        catch (RuntimeException runtimeException) {
            LOGGER.error(runtimeException.getMessage(), (Throwable)(GlobalDebug.isDebugMode() ? runtimeException : null));
            iTCErrorHandler.onError("Failed to query the DSD", (Throwable)runtimeException, (IToopErrorCode)EToopErrorCode.DD_001);
            iCommonsSet = new CommonsHashSet();
        }
        int n = iCommonsSet.size();
        ToopKafkaClient.send((IErrorLevel)EErrorLevel.INFO, () -> string + "DSD querying '" + string2 + "' and DPType '" + string3 + "' lead to " + n + " result entries");
        return iCommonsSet;
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("BaseURL", (Object)this.m_sBaseURL).getToString();
    }
}

