/*
 * Decompiled with CFR 0.152.
 */
package eu.toop.connector.app.incoming;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.collection.ArrayHelper;
import com.helger.commons.error.level.EErrorLevel;
import com.helger.commons.error.level.IErrorLevel;
import com.helger.commons.mime.IMimeType;
import com.helger.commons.state.ESuccess;
import com.helger.commons.string.StringHelper;
import com.helger.commons.url.IURLProtocol;
import com.helger.commons.url.URLProtocolRegistry;
import com.helger.httpclient.HttpClientManager;
import com.helger.httpclient.HttpClientSettings;
import com.helger.httpclient.response.ResponseHandlerByteArray;
import com.helger.peppolid.IIdentifier;
import eu.toop.connector.api.TCConfig;
import eu.toop.connector.api.http.TCHttpClientSettings;
import eu.toop.connector.api.me.incoming.IMEIncomingTransportMetadata;
import eu.toop.connector.api.me.incoming.IncomingEDMErrorResponse;
import eu.toop.connector.api.me.incoming.IncomingEDMRequest;
import eu.toop.connector.api.me.incoming.IncomingEDMResponse;
import eu.toop.connector.api.me.model.MEPayload;
import eu.toop.connector.api.rest.TCIncomingMessage;
import eu.toop.connector.api.rest.TCIncomingMetadata;
import eu.toop.connector.api.rest.TCPayload;
import eu.toop.connector.api.rest.TCPayloadType;
import eu.toop.connector.api.rest.TCRestJAXB;
import eu.toop.kafkaclient.ToopKafkaClient;
import eu.toop.regrep.CRegRep4;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.apache.http.HttpEntity;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;

@Immutable
public final class DC_DP_TriggerViaHttp {
    private DC_DP_TriggerViaHttp() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nonnull
    private static ESuccess _forwardMessage(@Nonnull TCIncomingMessage tCIncomingMessage, @Nonnull @Nonempty String string) {
        ValueEnforcer.notNull((Object)tCIncomingMessage, (String)"Msg");
        ValueEnforcer.notEmpty((CharSequence)string, (String)"Destination URL");
        if (StringHelper.hasNoText((String)string)) {
            throw new IllegalStateException("No URL for handling inbound messages is defined.");
        }
        IURLProtocol iURLProtocol = URLProtocolRegistry.getInstance().getProtocol(string);
        if (iURLProtocol == null) {
            throw new IllegalStateException("The URL for handling inbound messages '" + string + "' is invalid.");
        }
        byte[] byArray = TCRestJAXB.incomingMessage().getAsBytes((Object)tCIncomingMessage);
        if (byArray == null) {
            throw new IllegalStateException();
        }
        ToopKafkaClient.send((IErrorLevel)EErrorLevel.INFO, () -> "Sending inbound message to '" + string + "' with " + byArray.length + " bytes");
        try (HttpClientManager httpClientManager = HttpClientManager.create((HttpClientSettings)new TCHttpClientSettings());){
            HttpPost httpPost = new HttpPost(string);
            httpPost.setEntity((HttpEntity)new ByteArrayEntity(byArray));
            byte[] byArray2 = (byte[])httpClientManager.execute((HttpUriRequest)httpPost, (ResponseHandler)new ResponseHandlerByteArray());
            ToopKafkaClient.send((IErrorLevel)EErrorLevel.INFO, () -> "Sending inbound message was successful. Got " + ArrayHelper.getSize((byte[])byArray2) + " bytes back");
            ESuccess eSuccess = ESuccess.SUCCESS;
            return eSuccess;
        }
        catch (Exception exception) {
            ToopKafkaClient.send((IErrorLevel)EErrorLevel.ERROR, () -> "Sending inbound message to '" + string + "' failed", (Throwable)exception);
            return ESuccess.FAILURE;
        }
    }

    @Nonnull
    private static TCIncomingMetadata _createMetadata(@Nonnull IMEIncomingTransportMetadata iMEIncomingTransportMetadata, @Nonnull TCPayloadType tCPayloadType) {
        TCIncomingMetadata tCIncomingMetadata = new TCIncomingMetadata();
        tCIncomingMetadata.setSenderID(TCRestJAXB.createTCID((IIdentifier)iMEIncomingTransportMetadata.getSenderID()));
        tCIncomingMetadata.setReceiverID(TCRestJAXB.createTCID((IIdentifier)iMEIncomingTransportMetadata.getReceiverID()));
        tCIncomingMetadata.setDocTypeID(TCRestJAXB.createTCID((IIdentifier)iMEIncomingTransportMetadata.getDocumentTypeID()));
        tCIncomingMetadata.setProcessID(TCRestJAXB.createTCID((IIdentifier)iMEIncomingTransportMetadata.getProcessID()));
        tCIncomingMetadata.setPayloadType(tCPayloadType);
        return tCIncomingMetadata;
    }

    @Nonnull
    private static TCPayload _createPayload(@Nonnull byte[] byArray, @Nullable String string, @Nonnull IMimeType iMimeType) {
        TCPayload tCPayload = new TCPayload();
        tCPayload.setValue(byArray);
        tCPayload.setContentID(string);
        tCPayload.setMimeType(iMimeType.getAsString());
        return tCPayload;
    }

    @Nonnull
    @Nonempty
    private static String _getConfiguredDestURL() {
        String string = TCConfig.MEM.getMEMIncomingURL();
        if (StringHelper.hasNoText((String)string)) {
            throw new IllegalStateException("The MEM incoming URL for forwarding to DC/DP is not configured.");
        }
        return string;
    }

    @Nonnull
    public static ESuccess forwardMessage(@Nonnull IncomingEDMRequest incomingEDMRequest) {
        return DC_DP_TriggerViaHttp.forwardMessage(incomingEDMRequest, DC_DP_TriggerViaHttp._getConfiguredDestURL());
    }

    @Nonnull
    public static ESuccess forwardMessage(@Nonnull IncomingEDMRequest incomingEDMRequest, @Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"Destination URL");
        TCIncomingMessage tCIncomingMessage = new TCIncomingMessage();
        tCIncomingMessage.setMetadata(DC_DP_TriggerViaHttp._createMetadata(incomingEDMRequest.getMetadata(), TCPayloadType.REQUEST));
        tCIncomingMessage.addPayload(DC_DP_TriggerViaHttp._createPayload(incomingEDMRequest.getRequest().getWriter().getAsBytes(), incomingEDMRequest.getTopLevelContentID(), CRegRep4.MIME_TYPE_EBRS_XML));
        return DC_DP_TriggerViaHttp._forwardMessage(tCIncomingMessage, string);
    }

    @Nonnull
    public static ESuccess forwardMessage(@Nonnull IncomingEDMResponse incomingEDMResponse) {
        return DC_DP_TriggerViaHttp.forwardMessage(incomingEDMResponse, DC_DP_TriggerViaHttp._getConfiguredDestURL());
    }

    @Nonnull
    public static ESuccess forwardMessage(@Nonnull IncomingEDMResponse incomingEDMResponse, @Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"Destination URL");
        TCIncomingMessage tCIncomingMessage = new TCIncomingMessage();
        tCIncomingMessage.setMetadata(DC_DP_TriggerViaHttp._createMetadata(incomingEDMResponse.getMetadata(), TCPayloadType.RESPONSE));
        tCIncomingMessage.addPayload(DC_DP_TriggerViaHttp._createPayload(incomingEDMResponse.getResponse().getWriter().getAsBytes(), incomingEDMResponse.getTopLevelContentID(), CRegRep4.MIME_TYPE_EBRS_XML));
        for (MEPayload mEPayload : incomingEDMResponse.attachments().values()) {
            tCIncomingMessage.addPayload(DC_DP_TriggerViaHttp._createPayload(mEPayload.getData().bytes(), mEPayload.getContentID(), mEPayload.getMimeType()));
        }
        return DC_DP_TriggerViaHttp._forwardMessage(tCIncomingMessage, string);
    }

    @Nonnull
    public static ESuccess forwardMessage(@Nonnull IncomingEDMErrorResponse incomingEDMErrorResponse) {
        return DC_DP_TriggerViaHttp.forwardMessage(incomingEDMErrorResponse, DC_DP_TriggerViaHttp._getConfiguredDestURL());
    }

    @Nonnull
    public static ESuccess forwardMessage(@Nonnull IncomingEDMErrorResponse incomingEDMErrorResponse, @Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"Destination URL");
        TCIncomingMessage tCIncomingMessage = new TCIncomingMessage();
        tCIncomingMessage.setMetadata(DC_DP_TriggerViaHttp._createMetadata(incomingEDMErrorResponse.getMetadata(), TCPayloadType.ERROR_RESPONSE));
        tCIncomingMessage.addPayload(DC_DP_TriggerViaHttp._createPayload(incomingEDMErrorResponse.getErrorResponse().getWriter().getAsBytes(), incomingEDMErrorResponse.getTopLevelContentID(), CRegRep4.MIME_TYPE_EBRS_XML));
        return DC_DP_TriggerViaHttp._forwardMessage(tCIncomingMessage, string);
    }
}

