/*
 * Decompiled with CFR 0.152.
 */
package eu.toop.connector.app.smp;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.url.URLHelper;
import com.helger.peppolid.IDocumentTypeIdentifier;
import com.helger.peppolid.IParticipantIdentifier;
import com.helger.peppolid.IProcessIdentifier;
import com.helger.peppolid.factory.BDXR1IdentifierFactory;
import com.helger.smpclient.bdxr1.BDXRClientReadOnly;
import com.helger.smpclient.bdxr1.IBDXRServiceGroupProvider;
import com.helger.smpclient.bdxr1.IBDXRServiceMetadataProvider;
import com.helger.smpclient.url.BDXLURLProvider;
import com.helger.smpclient.url.ISMPURLProvider;
import com.helger.smpclient.url.SMPDNSResolutionException;
import com.helger.xsds.bdxr.smp1.DocumentIdentifierType;
import com.helger.xsds.bdxr.smp1.EndpointType;
import com.helger.xsds.bdxr.smp1.ParticipantIdentifierType;
import com.helger.xsds.bdxr.smp1.ProcessIdentifierType;
import com.helger.xsds.bdxr.smp1.ProcessListType;
import com.helger.xsds.bdxr.smp1.ProcessType;
import com.helger.xsds.bdxr.smp1.ServiceEndpointList;
import com.helger.xsds.bdxr.smp1.ServiceInformationType;
import com.helger.xsds.bdxr.smp1.ServiceMetadataType;
import com.helger.xsds.bdxr.smp1.SignedServiceMetadataType;
import eu.toop.connector.api.TCConfig;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import javax.annotation.Nonnull;

public abstract class AbstractDDClient {
    protected AbstractDDClient() {
    }

    @Nonnull
    private static BDXRClientReadOnly _getSMPClient(@Nonnull IParticipantIdentifier iParticipantIdentifier) throws SMPDNSResolutionException {
        if (TCConfig.R2D2.isR2D2UseDNS()) {
            ValueEnforcer.notNull((Object)iParticipantIdentifier, (String)"RecipientID");
            return new BDXRClientReadOnly((ISMPURLProvider)BDXLURLProvider.INSTANCE, iParticipantIdentifier, TCConfig.R2D2.getR2D2SML());
        }
        return new BDXRClientReadOnly(TCConfig.R2D2.getR2D2SMPUrl());
    }

    @Nonnull
    public static IBDXRServiceGroupProvider getServiceGroupProvider(@Nonnull IParticipantIdentifier iParticipantIdentifier) throws SMPDNSResolutionException {
        return AbstractDDClient._getSMPClient(iParticipantIdentifier);
    }

    @Nonnull
    public static IBDXRServiceMetadataProvider getServiceMetadataProvider(@Nonnull IParticipantIdentifier iParticipantIdentifier2, @Nonnull IDocumentTypeIdentifier iDocumentTypeIdentifier, @Nonnull IProcessIdentifier iProcessIdentifier, @Nonnull String string) throws SMPDNSResolutionException {
        if (!TCConfig.R2D2.isR2D2UseDNS()) {
            String string2 = TCConfig.R2D2.getR2D2StaticEndpointURL();
            X509Certificate x509Certificate = TCConfig.R2D2.getR2D2StaticCertificate();
            if (URLHelper.getAsURL((String)string2) != null && x509Certificate != null) {
                return (iParticipantIdentifier, iDocumentTypeIdentifier2) -> {
                    SignedServiceMetadataType signedServiceMetadataType = new SignedServiceMetadataType();
                    ServiceMetadataType serviceMetadataType = new ServiceMetadataType();
                    ServiceInformationType serviceInformationType = new ServiceInformationType();
                    serviceInformationType.setParticipantIdentifier((ParticipantIdentifierType)BDXR1IdentifierFactory.INSTANCE.createParticipantIdentifier(iParticipantIdentifier.getScheme(), iParticipantIdentifier.getValue()));
                    serviceInformationType.setDocumentIdentifier((DocumentIdentifierType)BDXR1IdentifierFactory.INSTANCE.createDocumentTypeIdentifier(iDocumentTypeIdentifier.getScheme(), iDocumentTypeIdentifier.getValue()));
                    ProcessListType processListType = new ProcessListType();
                    ProcessType processType = new ProcessType();
                    processType.setProcessIdentifier((ProcessIdentifierType)BDXR1IdentifierFactory.INSTANCE.createProcessIdentifier(iProcessIdentifier.getScheme(), iProcessIdentifier.getValue()));
                    ServiceEndpointList serviceEndpointList = new ServiceEndpointList();
                    EndpointType endpointType = new EndpointType();
                    endpointType.setEndpointURI(string2);
                    endpointType.setRequireBusinessLevelSignature(Boolean.FALSE);
                    try {
                        endpointType.setCertificate(x509Certificate.getEncoded());
                    }
                    catch (CertificateEncodingException certificateEncodingException) {
                        throw new IllegalArgumentException("Failed to encode certificate " + x509Certificate);
                    }
                    endpointType.setServiceDescription("Mocked service");
                    endpointType.setTechnicalContactUrl("Mocked service - no support");
                    endpointType.setTransportProfile(string);
                    serviceEndpointList.addEndpoint(endpointType);
                    processType.setServiceEndpointList(serviceEndpointList);
                    processListType.addProcess(processType);
                    serviceInformationType.setProcessList(processListType);
                    serviceMetadataType.setServiceInformation(serviceInformationType);
                    signedServiceMetadataType.setServiceMetadata(serviceMetadataType);
                    return signedServiceMetadataType;
                };
            }
        }
        return AbstractDDClient._getSMPClient(iParticipantIdentifier2);
    }
}

