/*
 * Decompiled with CFR 0.152.
 */
package eu.toop.connector.app.smp;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.collection.impl.CommonsTreeMap;
import com.helger.commons.collection.impl.ICommonsSortedMap;
import com.helger.peppolid.CIdentifier;
import com.helger.peppolid.IParticipantIdentifier;
import com.helger.smpclient.bdxr1.IBDXRServiceGroupProvider;
import com.helger.smpclient.exception.SMPClientException;
import com.helger.smpclient.url.SMPDNSResolutionException;
import com.helger.xsds.bdxr.smp1.ServiceGroupType;
import com.helger.xsds.bdxr.smp1.ServiceMetadataReferenceType;
import eu.toop.connector.api.dd.IDDServiceGroupHrefProvider;
import eu.toop.connector.api.error.ITCErrorHandler;
import eu.toop.connector.app.smp.AbstractDDClient;
import eu.toop.edm.error.EToopErrorCode;
import eu.toop.edm.error.IToopErrorCode;
import javax.annotation.Nonnull;

public class DDServiceGroupHrefProviderSMP
extends AbstractDDClient
implements IDDServiceGroupHrefProvider {
    @Nonnull
    public ICommonsSortedMap<String, String> getAllServiceGroupHrefs(@Nonnull IParticipantIdentifier iParticipantIdentifier, @Nonnull ITCErrorHandler iTCErrorHandler) {
        ValueEnforcer.notNull((Object)iParticipantIdentifier, (String)"ParticipantID");
        ValueEnforcer.notNull((Object)iTCErrorHandler, (String)"ErrorHandler");
        try {
            CommonsTreeMap commonsTreeMap = new CommonsTreeMap();
            IBDXRServiceGroupProvider iBDXRServiceGroupProvider = DDServiceGroupHrefProviderSMP.getServiceGroupProvider(iParticipantIdentifier);
            ServiceGroupType serviceGroupType = iBDXRServiceGroupProvider.getServiceGroupOrNull(iParticipantIdentifier);
            if (serviceGroupType != null && serviceGroupType.getServiceMetadataReferenceCollection() != null) {
                for (ServiceMetadataReferenceType serviceMetadataReferenceType : serviceGroupType.getServiceMetadataReferenceCollection().getServiceMetadataReference()) {
                    String string = CIdentifier.createPercentDecoded((String)serviceMetadataReferenceType.getHref());
                    if (commonsTreeMap.put((Object)string, (Object)serviceMetadataReferenceType.getHref()) == null) continue;
                    iTCErrorHandler.onWarning("The SMP ServiceGroup list contains the duplicate URL '" + string + "'", (IToopErrorCode)EToopErrorCode.GEN);
                }
            }
            return commonsTreeMap;
        }
        catch (SMPClientException | SMPDNSResolutionException throwable) {
            throw new IllegalStateException(throwable);
        }
    }
}

