/*
 * Decompiled with CFR 0.152.
 */
package eu.toop.connector.app;

import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.datetime.PDTFactory;
import com.helger.commons.datetime.PDTWebDateHelper;
import com.helger.commons.debug.GlobalDebug;
import com.helger.commons.system.SystemProperties;
import com.helger.json.IJsonObject;
import com.helger.json.JsonObject;
import com.helger.settings.ISettings;
import eu.toop.connector.api.TCConfig;
import eu.toop.connector.app.CTC;
import java.time.ZonedDateTime;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class TCStatusHelper {
    private TCStatusHelper() {
    }

    @Nonnull
    @ReturnsMutableCopy
    public static IJsonObject getDefaultStatusData() {
        ISettings iSettings = TCConfig.getConfigFile().getSettings();
        JsonObject jsonObject = new JsonObject();
        jsonObject.add("status.datetime", (Object)PDTWebDateHelper.getAsStringXSD((ZonedDateTime)PDTFactory.getCurrentZonedDateTimeUTC()));
        jsonObject.add("version.toop-connector", (Object)CTC.getVersionNumber());
        jsonObject.add("version.build-datetime", (Object)CTC.getBuildTimestamp());
        jsonObject.add("version.java", (Object)SystemProperties.getJavaVersion());
        jsonObject.add("global.debug", GlobalDebug.isDebugMode());
        jsonObject.add("global.production", GlobalDebug.isProductionMode());
        for (Map.Entry entry : iSettings.entrySet()) {
            String string = (String)entry.getKey();
            if (string.contains("password")) continue;
            jsonObject.add(string, entry.getValue());
        }
        return jsonObject;
    }
}

