/*
 * Decompiled with CFR 0.152.
 */
package eu.toop.connector.app.mp;

import com.helger.asic.SignatureHelper;
import com.helger.commons.ValueEnforcer;
import com.helger.commons.concurrent.SimpleReadWriteLock;
import eu.toop.connector.api.TCConfig;
import eu.toop.connector.api.r2d2.IR2D2EndpointProvider;
import eu.toop.connector.api.r2d2.IR2D2ParticipantIDProvider;
import eu.toop.connector.api.smm.ISMMConceptProvider;
import eu.toop.connector.app.mp.IToDC;
import eu.toop.connector.app.mp.IToDP;
import eu.toop.connector.app.mp.ToDCViaToopInterfaceHttp;
import eu.toop.connector.app.mp.ToDPViaToopInterfaceHttp;
import eu.toop.connector.app.r2d2.R2D2EndpointProviderBDXRSMP1;
import eu.toop.connector.app.r2d2.R2D2ParticipantIDProviderTOOPDirectory;
import eu.toop.connector.app.smm.SMMConceptProviderFileBased;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class MPConfig {
    private static final SimpleReadWriteLock s_aRWLock = new SimpleReadWriteLock();
    @GuardedBy(value="s_aRWLock")
    private static SignatureHelper s_aSH;
    @GuardedBy(value="s_aRWLock")
    private static ISMMConceptProvider s_aCP;
    @GuardedBy(value="s_aRWLock")
    private static IR2D2ParticipantIDProvider s_aPIDP;
    @GuardedBy(value="s_aRWLock")
    private static IR2D2EndpointProvider s_aEPP;
    @GuardedBy(value="s_aRWLock")
    private static IToDP s_aToDP;
    @GuardedBy(value="s_aRWLock")
    private static IToDC s_aToDC;

    private MPConfig() {
    }

    public static void setToDefault() {
        s_aRWLock.writeLocked(() -> {
            s_aSH = null;
            s_aCP = new SMMConceptProviderFileBased();
            s_aPIDP = new R2D2ParticipantIDProviderTOOPDirectory();
            s_aEPP = new R2D2EndpointProviderBDXRSMP1();
            s_aToDP = new ToDPViaToopInterfaceHttp();
            s_aToDC = new ToDCViaToopInterfaceHttp();
        });
    }

    @Nonnull
    public static SignatureHelper getSignatureHelper() {
        SignatureHelper signatureHelper = (SignatureHelper)s_aRWLock.readLocked(() -> s_aSH);
        if (signatureHelper == null) {
            signatureHelper = new SignatureHelper(TCConfig.getKeystoreType(), TCConfig.getKeystorePath(), TCConfig.getKeystorePassword(), TCConfig.getKeystoreKeyAlias(), TCConfig.getKeystoreKeyPassword());
            MPConfig.setSignatureHelper(signatureHelper);
        }
        return signatureHelper;
    }

    public static void setSignatureHelper(@Nonnull SignatureHelper signatureHelper) {
        ValueEnforcer.notNull((Object)signatureHelper, (String)"SignatureHelper");
        s_aRWLock.writeLocked(() -> {
            s_aSH = signatureHelper;
            return s_aSH;
        });
    }

    @Nonnull
    public static ISMMConceptProvider getSMMConceptProvider() {
        return (ISMMConceptProvider)s_aRWLock.readLocked(() -> s_aCP);
    }

    public static void setSMMConceptProvider(@Nonnull ISMMConceptProvider iSMMConceptProvider) {
        ValueEnforcer.notNull((Object)iSMMConceptProvider, (String)"ConceptProvider");
        s_aRWLock.writeLocked(() -> {
            s_aCP = iSMMConceptProvider;
            return s_aCP;
        });
    }

    @Nonnull
    public static IR2D2ParticipantIDProvider getParticipantIDProvider() {
        return (IR2D2ParticipantIDProvider)s_aRWLock.readLocked(() -> s_aPIDP);
    }

    public static void setParticipantIDProvider(@Nonnull IR2D2ParticipantIDProvider iR2D2ParticipantIDProvider) {
        ValueEnforcer.notNull((Object)iR2D2ParticipantIDProvider, (String)"ParticipantIDProvider");
        s_aRWLock.writeLocked(() -> {
            s_aPIDP = iR2D2ParticipantIDProvider;
            return s_aPIDP;
        });
    }

    @Nonnull
    public static IR2D2EndpointProvider getEndpointProvider() {
        return (IR2D2EndpointProvider)s_aRWLock.readLocked(() -> s_aEPP);
    }

    public static void setEndpointProvider(@Nonnull IR2D2EndpointProvider iR2D2EndpointProvider) {
        ValueEnforcer.notNull((Object)iR2D2EndpointProvider, (String)"EndpointProvider");
        s_aRWLock.writeLocked(() -> {
            s_aEPP = iR2D2EndpointProvider;
            return s_aEPP;
        });
    }

    @Nonnull
    public static IToDP getToDP() {
        return (IToDP)s_aRWLock.readLocked(() -> s_aToDP);
    }

    public static void setToDP(@Nonnull IToDP iToDP) {
        ValueEnforcer.notNull((Object)iToDP, (String)"ToDP");
        s_aRWLock.writeLocked(() -> {
            s_aToDP = iToDP;
            return s_aToDP;
        });
    }

    @Nonnull
    public static IToDC getToDC() {
        return (IToDC)s_aRWLock.readLocked(() -> s_aToDC);
    }

    public static void setToDC(@Nonnull IToDC iToDC) {
        ValueEnforcer.notNull((Object)iToDC, (String)"ToDC");
        s_aRWLock.writeLocked(() -> {
            s_aToDC = iToDC;
            return s_aToDC;
        });
    }

    static {
        MPConfig.setToDefault();
    }
}

