/*
 * Decompiled with CFR 0.152.
 */
package eu.toop.connector.app.mp;

import com.helger.commons.concurrent.collector.IConcurrentPerformer;
import com.helger.commons.error.level.EErrorLevel;
import com.helger.commons.error.level.IErrorLevel;
import com.helger.commons.id.factory.GlobalIDFactory;
import eu.toop.commons.dataexchange.v140.TDETOOPResponseType;
import eu.toop.commons.exchange.ToopResponseWithAttachments140;
import eu.toop.connector.app.mp.MPConfig;
import eu.toop.kafkaclient.ToopKafkaClient;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class MessageProcessorDCIncomingPerformer
implements IConcurrentPerformer<ToopResponseWithAttachments140> {
    private static final Logger LOGGER = LoggerFactory.getLogger(MessageProcessorDCIncomingPerformer.class);

    MessageProcessorDCIncomingPerformer() {
    }

    public void runAsync(@Nonnull ToopResponseWithAttachments140 toopResponseWithAttachments140) throws Exception {
        TDETOOPResponseType tDETOOPResponseType = toopResponseWithAttachments140.getResponse();
        String string = tDETOOPResponseType.getDataRequestIdentifier() != null ? tDETOOPResponseType.getDataRequestIdentifier().getValue() : "temp-tc4-id-" + GlobalIDFactory.getNewIntID();
        String string2 = "[" + string + "] ";
        ToopKafkaClient.send((IErrorLevel)EErrorLevel.INFO, () -> string2 + "Received DC Incoming Request (4/4)");
        MPConfig.getToDC().passResponseOnToDC(toopResponseWithAttachments140);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(string2 + "End of processing");
        }
    }
}

