/*
 * Decompiled with CFR 0.152.
 */
package eu.toop.connector.app.mp;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.UsedViaReflection;
import com.helger.commons.concurrent.BasicThreadFactory;
import com.helger.commons.concurrent.ExecutorServiceHelper;
import com.helger.commons.concurrent.collector.ConcurrentCollectorSingle;
import com.helger.commons.concurrent.collector.IConcurrentPerformer;
import com.helger.commons.error.level.EErrorLevel;
import com.helger.commons.error.level.IErrorLevel;
import com.helger.commons.state.ESuccess;
import com.helger.scope.IScope;
import com.helger.web.scope.singleton.AbstractGlobalWebSingleton;
import eu.toop.commons.exchange.ToopRequestWithAttachments140;
import eu.toop.connector.app.mp.MessageProcessorDCOutgoingPerformer;
import eu.toop.kafkaclient.ToopKafkaClient;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MessageProcessorDCOutgoing
extends AbstractGlobalWebSingleton {
    private static final Logger LOGGER = LoggerFactory.getLogger(MessageProcessorDCOutgoing.class);
    private static final ThreadFactory s_aThreadFactory = new BasicThreadFactory.Builder().setNamingPattern("MP-DC-Out-%d").setDaemon(true).build();
    private final ConcurrentCollectorSingle<ToopRequestWithAttachments140> m_aCollector = new ConcurrentCollectorSingle();
    private final ExecutorService m_aExecutorPool;

    @Deprecated
    @UsedViaReflection
    public MessageProcessorDCOutgoing() {
        this.m_aCollector.setPerformer((IConcurrentPerformer)new MessageProcessorDCOutgoingPerformer());
        this.m_aExecutorPool = Executors.newSingleThreadExecutor(s_aThreadFactory);
        this.m_aExecutorPool.submit(() -> this.m_aCollector.collect());
    }

    @Nonnull
    public static MessageProcessorDCOutgoing getInstance() {
        return (MessageProcessorDCOutgoing)MessageProcessorDCOutgoing.getGlobalSingleton(MessageProcessorDCOutgoing.class);
    }

    protected void onDestroy(@Nonnull IScope iScope) throws Exception {
        this.m_aCollector.stopQueuingNewObjects();
        ExecutorServiceHelper.shutdownAndWaitUntilAllTasksAreFinished((ExecutorService)this.m_aExecutorPool);
    }

    @Nonnull
    public ESuccess enqueue(@Nonnull ToopRequestWithAttachments140 toopRequestWithAttachments140) {
        ValueEnforcer.notNull((Object)toopRequestWithAttachments140, (String)"Msg");
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Enqueueing new object for step 1/4: " + toopRequestWithAttachments140);
        }
        try {
            this.m_aCollector.queueObject((Object)toopRequestWithAttachments140);
            return ESuccess.SUCCESS;
        }
        catch (IllegalStateException illegalStateException) {
            ToopKafkaClient.send((IErrorLevel)EErrorLevel.ERROR, () -> "Cannot enqueue " + toopRequestWithAttachments140, (Throwable)illegalStateException);
            return ESuccess.FAILURE;
        }
    }
}

