/*
 * Decompiled with CFR 0.152.
 */
package eu.toop.connector.app.mp;

import com.helger.asic.AsicUtils;
import com.helger.asic.SignatureHelper;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.concurrent.collector.IConcurrentPerformer;
import com.helger.commons.error.level.EErrorLevel;
import com.helger.commons.error.level.IErrorLevel;
import com.helger.commons.error.list.ErrorList;
import com.helger.commons.id.factory.GlobalIDFactory;
import com.helger.commons.io.ByteArrayWrapper;
import com.helger.commons.io.stream.NonBlockingByteArrayOutputStream;
import com.helger.commons.lang.StackTraceHelper;
import com.helger.commons.mutable.MutableInt;
import com.helger.commons.string.StringHelper;
import com.helger.commons.text.IMultilingualText;
import com.helger.commons.text.MultilingualText;
import com.helger.jaxb.validation.WrappedCollectingValidationEventHandler;
import com.helger.peppolid.IDocumentTypeIdentifier;
import com.helger.peppolid.IParticipantIdentifier;
import com.helger.peppolid.IProcessIdentifier;
import eu.toop.commons.codelist.EPredefinedDocumentTypeIdentifier;
import eu.toop.commons.concept.ConceptValue;
import eu.toop.commons.concept.EConceptType;
import eu.toop.commons.dataexchange.v140.TDEConceptRequestType;
import eu.toop.commons.dataexchange.v140.TDEDataElementRequestType;
import eu.toop.commons.dataexchange.v140.TDEErrorType;
import eu.toop.commons.dataexchange.v140.TDETOOPRequestType;
import eu.toop.commons.dataexchange.v140.TDETOOPResponseType;
import eu.toop.commons.error.EToopErrorCategory;
import eu.toop.commons.error.EToopErrorCode;
import eu.toop.commons.error.EToopErrorOrigin;
import eu.toop.commons.error.EToopErrorSeverity;
import eu.toop.commons.error.IToopErrorCode;
import eu.toop.commons.error.ToopErrorException;
import eu.toop.commons.exchange.ToopMessageBuilder140;
import eu.toop.commons.exchange.ToopRequestWithAttachments140;
import eu.toop.commons.exchange.ToopResponseWithAttachments140;
import eu.toop.commons.jaxb.ToopWriter;
import eu.toop.commons.jaxb.ToopXSDHelper140;
import eu.toop.commons.schematron.TOOPSchematron140Validator;
import eu.toop.commons.usecase.SMMDocumentTypeMapping;
import eu.toop.connector.api.TCConfig;
import eu.toop.connector.api.TCSettings;
import eu.toop.connector.api.as4.IMERoutingInformation;
import eu.toop.connector.api.as4.MEException;
import eu.toop.connector.api.as4.MEMessage;
import eu.toop.connector.api.as4.MEPayload;
import eu.toop.connector.api.as4.MERoutingInformation;
import eu.toop.connector.api.as4.MessageExchangeManager;
import eu.toop.connector.api.r2d2.IR2D2Endpoint;
import eu.toop.connector.api.r2d2.IR2D2ErrorHandler;
import eu.toop.connector.api.smm.IMappedValueList;
import eu.toop.connector.api.smm.ISMMUnmappableCallback;
import eu.toop.connector.api.smm.MappedValue;
import eu.toop.connector.app.TCDumpHelper;
import eu.toop.connector.app.mp.MPConfig;
import eu.toop.connector.app.mp.MPHelper;
import eu.toop.connector.app.mp.MessageProcessorDCIncoming;
import eu.toop.connector.app.r2d2.R2D2Client;
import eu.toop.connector.app.smm.SMMClient;
import eu.toop.kafkaclient.ToopKafkaClient;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Locale;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.bind.ValidationEventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

final class MessageProcessorDCOutgoingPerformer
implements IConcurrentPerformer<ToopRequestWithAttachments140> {
    private static final Logger LOGGER = LoggerFactory.getLogger(MessageProcessorDCOutgoingPerformer.class);

    MessageProcessorDCOutgoingPerformer() {
    }

    @Nonnull
    private static TDEErrorType _createError(@Nonnull IErrorLevel iErrorLevel, @Nonnull String string, @Nonnull EToopErrorCategory eToopErrorCategory, @Nonnull IToopErrorCode iToopErrorCode, @Nonnull String string2, @Nullable Throwable throwable) {
        ToopKafkaClient.send((IErrorLevel)iErrorLevel, () -> string + "[" + (String)iToopErrorCode.getID() + "] " + string2, (Throwable)throwable);
        return ToopMessageBuilder140.createError(null, (EToopErrorOrigin)EToopErrorOrigin.REQUEST_SUBMISSION, (EToopErrorCategory)eToopErrorCategory, (IToopErrorCode)iToopErrorCode, (EToopErrorSeverity)(iErrorLevel.isError() ? EToopErrorSeverity.FAILURE : EToopErrorSeverity.WARNING), (IMultilingualText)new MultilingualText(Locale.US, string2), (String)(throwable == null ? null : StackTraceHelper.getStackAsString((Throwable)throwable)));
    }

    @Nonnull
    private static TDEErrorType _createError(@Nonnull String string, @Nonnull EToopErrorCategory eToopErrorCategory, @Nonnull IToopErrorCode iToopErrorCode, @Nonnull String string2, @Nullable Throwable throwable) {
        return MessageProcessorDCOutgoingPerformer._createError((IErrorLevel)EErrorLevel.ERROR, string, eToopErrorCategory, iToopErrorCode, string2, throwable);
    }

    @Nonnull
    private static TDEErrorType _createGenericError(@Nonnull String string, @Nonnull Throwable throwable) {
        return MessageProcessorDCOutgoingPerformer._createError(string, EToopErrorCategory.TECHNICAL_ERROR, (IToopErrorCode)EToopErrorCode.GEN, throwable.getMessage(), throwable);
    }

    private static void _iterateNonTCConcepts(@Nonnull TDETOOPRequestType tDETOOPRequestType, @Nonnull Consumer<TDEConceptRequestType> consumer) {
        for (TDEDataElementRequestType tDEDataElementRequestType : tDETOOPRequestType.getDataElementRequest()) {
            TDEConceptRequestType tDEConceptRequestType = tDEDataElementRequestType.getConceptRequest();
            if (tDEConceptRequestType.getSemanticMappingExecutionIndicator().isValue() || EConceptType.TC.getID().equals(tDEConceptRequestType.getConceptTypeCode().getValue())) continue;
            consumer.accept(tDEConceptRequestType);
        }
    }

    public void runAsync(@Nonnull ToopRequestWithAttachments140 toopRequestWithAttachments140) {
        int n;
        Iterator iterator;
        ICommonsList iCommonsList2;
        Object object;
        ErrorList errorList;
        TDETOOPRequestType tDETOOPRequestType = toopRequestWithAttachments140.getRequest();
        String string = tDETOOPRequestType.getDocumentUniversalUniqueIdentifier() != null ? tDETOOPRequestType.getDocumentUniversalUniqueIdentifier().getValue() : "temp-tc1-id-" + GlobalIDFactory.getNewIntID();
        String string2 = "[" + string + "] ";
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        ToopKafkaClient.send((IErrorLevel)EErrorLevel.INFO, () -> "Created new unique request ID [" + string + "]");
        ToopKafkaClient.send((IErrorLevel)EErrorLevel.INFO, () -> string2 + "Received DC Request (1/4)");
        if (TCConfig.isMPSchematronValidationEnabled()) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(string2 + "Performing Schematron validation on incoming TOOP request");
            }
            errorList = new ErrorList();
            object = ((ToopWriter)ToopWriter.request140().setValidationEventHandler((ValidationEventHandler)new WrappedCollectingValidationEventHandler(errorList))).getAsDocument((Object)tDETOOPRequestType);
            if (object == null) {
                for (ICommonsList iCommonsList2 : errorList) {
                    commonsArrayList.add((Object)MessageProcessorDCOutgoingPerformer._createError(iCommonsList2.getErrorLevel(), string2, EToopErrorCategory.PARSING, (IToopErrorCode)EToopErrorCode.IF_001, iCommonsList2.getErrorText(Locale.US), iCommonsList2.getLinkedException()));
                }
            } else {
                iterator = new TOOPSchematron140Validator();
                iCommonsList2 = iterator.validateTOOPMessage((Document)object);
                for (EPredefinedDocumentTypeIdentifier ePredefinedDocumentTypeIdentifier : iCommonsList2) {
                    commonsArrayList.add((Object)MessageProcessorDCOutgoingPerformer._createError(ePredefinedDocumentTypeIdentifier.getFlag(), string2, EToopErrorCategory.PARSING, (IToopErrorCode)EToopErrorCode.IF_001, "[" + ePredefinedDocumentTypeIdentifier.getLocation() + "] [Test: " + ePredefinedDocumentTypeIdentifier.getTest() + "] " + ePredefinedDocumentTypeIdentifier.getText(), null));
                }
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(string2 + "Finished Schematron validation with the following results: " + errorList);
            }
        } else {
            ToopKafkaClient.send((IErrorLevel)EErrorLevel.INFO, () -> string2 + "Schematron validation was explicitly disabled.");
        }
        if (commonsArrayList.isEmpty()) {
            EPredefinedDocumentTypeIdentifier ePredefinedDocumentTypeIdentifier;
            errorList = TCSettings.getIdentifierFactory();
            object = tDETOOPRequestType.getRoutingInformation();
            iterator = object == null ? null : errorList.createParticipantIdentifier(object.getDataConsumerElectronicAddressIdentifier().getSchemeID(), object.getDataConsumerElectronicAddressIdentifier().getValue());
            iCommonsList2 = object == null ? null : errorList.createDocumentTypeIdentifier(object.getDocumentTypeIdentifier().getSchemeID(), object.getDocumentTypeIdentifier().getValue());
            Iterator iterator2 = object == null ? null : errorList.createProcessIdentifier(object.getProcessIdentifier().getSchemeID(), object.getProcessIdentifier().getValue());
            EPredefinedDocumentTypeIdentifier ePredefinedDocumentTypeIdentifier2 = ePredefinedDocumentTypeIdentifier = object == null ? null : EPredefinedDocumentTypeIdentifier.getFromDocumentTypeIdentifierOrNull((String)object.getDocumentTypeIdentifier().getSchemeID(), (String)object.getDocumentTypeIdentifier().getValue());
            if (ePredefinedDocumentTypeIdentifier == null) {
                String string3 = "Failed to resolve document type " + (object == null ? null : object.getDocumentTypeIdentifier().getSchemeID() + "::" + object.getDocumentTypeIdentifier().getValue());
                commonsArrayList.add((Object)MessageProcessorDCOutgoingPerformer._createError(string2, EToopErrorCategory.PARSING, (IToopErrorCode)EToopErrorCode.IF_001, string3, null));
            } else {
                Object object2;
                NonBlockingByteArrayOutputStream nonBlockingByteArrayOutputStream;
                String string4;
                ICommonsList<IR2D2Endpoint> iCommonsList3;
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug(string2 + "Selected document type: " + ePredefinedDocumentTypeIdentifier);
                }
                SMMClient sMMClient = new SMMClient();
                MessageProcessorDCOutgoingPerformer._iterateNonTCConcepts(tDETOOPRequestType, tDEConceptRequestType -> sMMClient.addConceptToBeMapped(ConceptValue.create((TDEConceptRequestType)tDEConceptRequestType)));
                int n2 = sMMClient.getTotalCountConceptsToBeMapped();
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug(string2 + "A total of " + n2 + " concepts need to be mapped");
                }
                if (n2 > 0) {
                    iCommonsList3 = null;
                    try {
                        string4 = SMMDocumentTypeMapping.getToopSMDomainOrNull((EPredefinedDocumentTypeIdentifier)ePredefinedDocumentTypeIdentifier);
                        if (string4 == null) {
                            iCommonsList3 = new ICommonsList<IR2D2Endpoint>();
                            ToopKafkaClient.send((IErrorLevel)EErrorLevel.INFO, () -> string2 + "Found no SMM document type mapping for document type " + ePredefinedDocumentTypeIdentifier);
                        } else {
                            nonBlockingByteArrayOutputStream = (arg_0, arg_1, arg_2, arg_3) -> MessageProcessorDCOutgoingPerformer.lambda$runAsync$6108ecc3$1((ICommonsList)commonsArrayList, arg_0, arg_1, arg_2, arg_3);
                            ToopKafkaClient.send((IErrorLevel)EErrorLevel.INFO, () -> string2 + "SMM client is mapping " + sMMClient.getTotalCountConceptsToBeMapped() + " concept(s) to namespace '" + string4 + "'");
                            iCommonsList3 = sMMClient.performMapping(string2, string4, MPConfig.getSMMConceptProvider(), (ISMMUnmappableCallback)nonBlockingByteArrayOutputStream);
                            ToopKafkaClient.send((IErrorLevel)EErrorLevel.INFO, (String)(string2 + "SMM client mapping found " + iCommonsList3.size() + " mapping(s)"));
                        }
                    }
                    catch (Exception exception) {
                        commonsArrayList.add((Object)MessageProcessorDCOutgoingPerformer._createError(string2, EToopErrorCategory.SEMANTIC_MAPPING, (IToopErrorCode)EToopErrorCode.SM_001, "Failed to invoke semantic mapping", exception));
                    }
                    if (commonsArrayList.isEmpty()) {
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug(string2 + "Starting to add mapped SMM concepts to the TOOP request");
                        }
                        string4 = iCommonsList3;
                        nonBlockingByteArrayOutputStream = new MutableInt(0);
                        MessageProcessorDCOutgoingPerformer._iterateNonTCConcepts(tDETOOPRequestType, arg_0 -> MessageProcessorDCOutgoingPerformer.lambda$runAsync$9((MutableInt)nonBlockingByteArrayOutputStream, (IMappedValueList)string4, string2, arg_0));
                        ToopKafkaClient.send((IErrorLevel)EErrorLevel.INFO, () -> MessageProcessorDCOutgoingPerformer.lambda$runAsync$10(string2, (MutableInt)nonBlockingByteArrayOutputStream));
                    }
                }
                iCommonsList3 = null;
                if (commonsArrayList.isEmpty()) {
                    String string5;
                    boolean bl;
                    string4 = TCConfig.getMEMProtocol().getTransportProfileID();
                    nonBlockingByteArrayOutputStream = (arg_0, arg_1, arg_2, arg_3) -> MessageProcessorDCOutgoingPerformer.lambda$runAsync$11aa5bcf$1((ICommonsList)commonsArrayList, string2, arg_0, arg_1, arg_2, arg_3);
                    object2 = object.getDataProviderElectronicAddressIdentifier();
                    boolean bl2 = bl = object2 != null;
                    if (bl) {
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug(string2 + "Starting SMP lookup for an explicit participant: " + object2.toString());
                        }
                        string5 = errorList.createParticipantIdentifier(object2.getSchemeID(), object2.getValue());
                        iCommonsList3 = MPConfig.getEndpointProvider().getEndpoints(string2, (IParticipantIdentifier)string5, (IDocumentTypeIdentifier)iCommonsList2, (IProcessIdentifier)iterator2, string4, (IR2D2ErrorHandler)nonBlockingByteArrayOutputStream);
                    } else {
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug(string2 + "Starting SMP lookup with country code and document type");
                        }
                        if (StringHelper.hasNoText((String)(string5 = object.getDataProviderCountryCode().getValue()))) {
                            commonsArrayList.add((Object)MessageProcessorDCOutgoingPerformer._createError(string2, EToopErrorCategory.DYNAMIC_DISCOVERY, (IToopErrorCode)EToopErrorCode.IF_001, "Failed to find destination country code to query!", null));
                        }
                        if (commonsArrayList.isEmpty()) {
                            iCommonsList3 = R2D2Client.getParticipantIDsAndEndpoints(string2, string5, (IDocumentTypeIdentifier)iCommonsList2, MPConfig.getParticipantIDProvider(), (IProcessIdentifier)iterator2, string4, MPConfig.getEndpointProvider(), (IR2D2ErrorHandler)nonBlockingByteArrayOutputStream);
                        }
                    }
                    if (commonsArrayList.isEmpty()) {
                        int n3 = iCommonsList3 == null ? 0 : iCommonsList3.size();
                        ToopKafkaClient.send((IErrorLevel)EErrorLevel.INFO, () -> string2 + "R2D2 found " + n3 + " endpoints for " + (bl ? "single participant" : "multi participant") + " lookup");
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug(string2 + "Endpoint details: " + iCommonsList3);
                        }
                        if (n3 == 0) {
                            commonsArrayList.add((Object)MessageProcessorDCOutgoingPerformer._createError(string2, EToopErrorCategory.DYNAMIC_DISCOVERY, (IToopErrorCode)EToopErrorCode.DD_006, "Found no endpoints for transport profile '" + string4 + "' by querying Directory and SMP", null));
                        }
                    }
                }
                if (commonsArrayList.isEmpty()) {
                    Object object3;
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug(string2 + "Started creating TOOP request ASIC container");
                    }
                    string4 = null;
                    nonBlockingByteArrayOutputStream = new NonBlockingByteArrayOutputStream();
                    object2 = null;
                    try {
                        try {
                            object3 = TCDumpHelper.getDumpOutputStream((OutputStream)nonBlockingByteArrayOutputStream, TCConfig.getDebugToDPDumpPathIfEnabled(), "to-dp.asic");
                            Throwable throwable = null;
                            try {
                                ToopMessageBuilder140.createRequestMessageAsic((TDETOOPRequestType)tDETOOPRequestType, (OutputStream)object3, (SignatureHelper)MPConfig.getSignatureHelper());
                            }
                            catch (Throwable throwable2) {
                                throwable = throwable2;
                                throw throwable2;
                            }
                            finally {
                                if (object3 != null) {
                                    if (throwable != null) {
                                        try {
                                            ((OutputStream)object3).close();
                                        }
                                        catch (Throwable throwable3) {
                                            throwable.addSuppressed(throwable3);
                                        }
                                    } else {
                                        ((OutputStream)object3).close();
                                    }
                                }
                            }
                        }
                        catch (ToopErrorException toopErrorException) {
                            commonsArrayList.add((Object)MessageProcessorDCOutgoingPerformer._createError(string2, EToopErrorCategory.E_DELIVERY, toopErrorException.getErrorCode(), toopErrorException.getMessage(), toopErrorException.getCause()));
                        }
                        catch (IOException iOException) {
                            commonsArrayList.add((Object)MessageProcessorDCOutgoingPerformer._createGenericError(string2, iOException));
                        }
                        string4 = ByteArrayWrapper.create((NonBlockingByteArrayOutputStream)nonBlockingByteArrayOutputStream, (boolean)false);
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug(string2 + "Created TOOP request ASIC container has " + string4.size() + " bytes");
                        }
                    }
                    catch (Throwable throwable) {
                        object2 = throwable;
                        throw throwable;
                    }
                    finally {
                        if (nonBlockingByteArrayOutputStream != null) {
                            if (object2 != null) {
                                try {
                                    nonBlockingByteArrayOutputStream.close();
                                }
                                catch (Throwable throwable) {
                                    ((Throwable)object2).addSuppressed(throwable);
                                }
                            } else {
                                nonBlockingByteArrayOutputStream.close();
                            }
                        }
                    }
                    if (commonsArrayList.isEmpty()) {
                        nonBlockingByteArrayOutputStream = new MEPayload(AsicUtils.MIMETYPE_ASICE, string, (ByteArrayWrapper)string4);
                        object2 = MEMessage.create((MEPayload)nonBlockingByteArrayOutputStream);
                        object3 = iCommonsList3.iterator();
                        if (object3.hasNext()) {
                            IR2D2Endpoint iR2D2Endpoint = (IR2D2Endpoint)object3.next();
                            ToopKafkaClient.send((IErrorLevel)EErrorLevel.INFO, () -> string2 + "Sending MEM message to '" + iR2D2Endpoint.getEndpointURL() + "' using transport protocol '" + iR2D2Endpoint.getTransportProtocol() + "'");
                            MERoutingInformation mERoutingInformation = new MERoutingInformation((IParticipantIdentifier)iterator, iR2D2Endpoint.getParticipantID(), (IDocumentTypeIdentifier)iCommonsList2, (IProcessIdentifier)iterator2, iR2D2Endpoint.getTransportProtocol(), iR2D2Endpoint.getEndpointURL(), iR2D2Endpoint.getCertificate());
                            try {
                                MessageExchangeManager.getConfiguredImplementation().sendDCOutgoing((IMERoutingInformation)mERoutingInformation, (MEMessage)object2);
                                if (LOGGER.isDebugEnabled()) {
                                    LOGGER.debug(string2 + "sendDCOutgoing returned without exception");
                                }
                            }
                            catch (MEException mEException) {
                                commonsArrayList.add((Object)MessageProcessorDCOutgoingPerformer._createError(string2, EToopErrorCategory.E_DELIVERY, (IToopErrorCode)EToopErrorCode.ME_001, "Error sending message", mEException));
                            }
                        }
                    }
                }
            }
        }
        if ((n = commonsArrayList.size()) > 0) {
            ToopKafkaClient.send((IErrorLevel)EErrorLevel.INFO, () -> string2 + n + " error(s) were found - directly pushing to queue 4/4.");
            object = ToopMessageBuilder140.createResponse((TDETOOPRequestType)tDETOOPRequestType);
            MPHelper.fillDefaultResponseFields(string2, (TDETOOPResponseType)object);
            object.getError().addAll(commonsArrayList);
            iterator = new ToopResponseWithAttachments140((TDETOOPResponseType)object, toopRequestWithAttachments140.attachments());
            MessageProcessorDCIncoming.getInstance().enqueue((ToopResponseWithAttachments140)iterator);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(string2 + "End of processing");
        }
    }

    private static /* synthetic */ void lambda$runAsync$11aa5bcf$1(ICommonsList iCommonsList, String string, EErrorLevel eErrorLevel, String string2, Throwable throwable, IToopErrorCode iToopErrorCode) {
        iCommonsList.add((Object)MessageProcessorDCOutgoingPerformer._createError((IErrorLevel)eErrorLevel, string, EToopErrorCategory.DYNAMIC_DISCOVERY, iToopErrorCode, string2, throwable));
    }

    private static /* synthetic */ String lambda$runAsync$10(String string, MutableInt mutableInt) {
        return string + "Finished mapping to shared concept with " + mutableInt.intValue() + " invocations";
    }

    private static /* synthetic */ void lambda$runAsync$9(MutableInt mutableInt, IMappedValueList iMappedValueList, String string, TDEConceptRequestType tDEConceptRequestType) {
        mutableInt.inc();
        boolean bl = false;
        ConceptValue conceptValue = ConceptValue.create((TDEConceptRequestType)tDEConceptRequestType);
        for (MappedValue mappedValue : iMappedValueList.getAllBySource(conceptValue2 -> conceptValue2.equals((Object)conceptValue))) {
            TDEConceptRequestType tDEConceptRequestType2 = new TDEConceptRequestType();
            tDEConceptRequestType2.setConceptTypeCode(ToopXSDHelper140.createCode((String)EConceptType.TC.getID()));
            tDEConceptRequestType2.setSemanticMappingExecutionIndicator(ToopXSDHelper140.createIndicator((boolean)false));
            tDEConceptRequestType2.setConceptNamespace(ToopXSDHelper140.createIdentifier((String)mappedValue.getDestination().getNamespace()));
            tDEConceptRequestType2.setConceptName(ToopXSDHelper140.createText((String)mappedValue.getDestination().getValue()));
            tDEConceptRequestType.addConceptRequest(tDEConceptRequestType2);
            bl = true;
        }
        if (bl) {
            tDEConceptRequestType.getSemanticMappingExecutionIndicator().setValue(true);
        } else {
            ToopKafkaClient.send((IErrorLevel)EErrorLevel.WARN, () -> string + "Found no source mapping of " + conceptValue + " in " + iMappedValueList);
        }
    }

    private static /* synthetic */ void lambda$runAsync$6108ecc3$1(ICommonsList iCommonsList, String string, String string2, String string3, String string4) {
        String string5 = "Found no mapping for '" + string2 + '#' + string3 + "' to destination namespace '" + string4 + "'";
        iCommonsList.add((Object)MessageProcessorDCOutgoingPerformer._createError(string, EToopErrorCategory.SEMANTIC_MAPPING, (IToopErrorCode)EToopErrorCode.SM_002, string5, null));
    }
}

