/*
 * Decompiled with CFR 0.152.
 */
package eu.toop.connector.app.mp;

import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.concurrent.collector.IConcurrentPerformer;
import com.helger.commons.error.level.EErrorLevel;
import com.helger.commons.error.level.IErrorLevel;
import com.helger.commons.id.factory.GlobalIDFactory;
import com.helger.commons.lang.StackTraceHelper;
import com.helger.commons.string.StringHelper;
import com.helger.commons.text.IMultilingualText;
import com.helger.commons.text.MultilingualText;
import eu.toop.commons.concept.ConceptValue;
import eu.toop.commons.concept.EConceptType;
import eu.toop.commons.dataexchange.v140.TDEConceptRequestType;
import eu.toop.commons.dataexchange.v140.TDEDataElementRequestType;
import eu.toop.commons.dataexchange.v140.TDEErrorType;
import eu.toop.commons.dataexchange.v140.TDETOOPRequestType;
import eu.toop.commons.dataexchange.v140.TDETOOPResponseType;
import eu.toop.commons.error.EToopErrorCategory;
import eu.toop.commons.error.EToopErrorCode;
import eu.toop.commons.error.EToopErrorOrigin;
import eu.toop.commons.error.EToopErrorSeverity;
import eu.toop.commons.error.IToopErrorCode;
import eu.toop.commons.exchange.ToopMessageBuilder140;
import eu.toop.commons.exchange.ToopRequestWithAttachments140;
import eu.toop.commons.exchange.ToopResponseWithAttachments140;
import eu.toop.commons.jaxb.ToopXSDHelper140;
import eu.toop.connector.api.TCConfig;
import eu.toop.connector.api.smm.IMappedValueList;
import eu.toop.connector.api.smm.ISMMUnmappableCallback;
import eu.toop.connector.api.smm.MappedValue;
import eu.toop.connector.app.mp.MPConfig;
import eu.toop.connector.app.mp.MPHelper;
import eu.toop.connector.app.mp.MessageProcessorDPOutgoing;
import eu.toop.connector.app.smm.SMMClient;
import eu.toop.kafkaclient.ToopKafkaClient;
import java.io.Serializable;
import java.util.Locale;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class MessageProcessorDPIncomingPerformer
implements IConcurrentPerformer<ToopRequestWithAttachments140> {
    private static final Logger LOGGER = LoggerFactory.getLogger(MessageProcessorDPIncomingPerformer.class);

    MessageProcessorDPIncomingPerformer() {
    }

    @Nonnull
    private static TDEErrorType _createError(@Nonnull IErrorLevel iErrorLevel, @Nonnull String string, @Nonnull EToopErrorCategory eToopErrorCategory, @Nonnull IToopErrorCode iToopErrorCode, @Nonnull String string2, @Nullable Throwable throwable) {
        ToopKafkaClient.send((IErrorLevel)iErrorLevel, () -> string + "[" + (String)iToopErrorCode.getID() + "] " + string2, (Throwable)throwable);
        return ToopMessageBuilder140.createError(null, (EToopErrorOrigin)EToopErrorOrigin.REQUEST_RECEPTION, (EToopErrorCategory)eToopErrorCategory, (IToopErrorCode)iToopErrorCode, (EToopErrorSeverity)EToopErrorSeverity.FAILURE, (IMultilingualText)new MultilingualText(Locale.US, string2), (String)(throwable == null ? null : StackTraceHelper.getStackAsString((Throwable)throwable)));
    }

    @Nonnull
    private static TDEErrorType _createGenericError(@Nonnull String string, @Nonnull Throwable throwable) {
        return MessageProcessorDPIncomingPerformer._createError((IErrorLevel)EErrorLevel.ERROR, string, EToopErrorCategory.TECHNICAL_ERROR, (IToopErrorCode)EToopErrorCode.GEN, throwable.getMessage(), throwable);
    }

    private static void _iterateTCConcepts(@Nonnull TDETOOPRequestType tDETOOPRequestType, @Nonnull Consumer<TDEConceptRequestType> consumer) {
        for (TDEDataElementRequestType tDEDataElementRequestType : tDETOOPRequestType.getDataElementRequest()) {
            TDEConceptRequestType tDEConceptRequestType = tDEDataElementRequestType.getConceptRequest();
            if (!tDEConceptRequestType.getSemanticMappingExecutionIndicator().isValue() && EConceptType.TC.getID().equals(tDEConceptRequestType.getConceptTypeCode().getValue())) {
                consumer.accept(tDEConceptRequestType);
                continue;
            }
            for (TDEConceptRequestType tDEConceptRequestType2 : tDEConceptRequestType.getConceptRequest()) {
                if (tDEConceptRequestType2.getSemanticMappingExecutionIndicator().isValue() || !EConceptType.TC.getID().equals(tDEConceptRequestType2.getConceptTypeCode().getValue())) continue;
                consumer.accept(tDEConceptRequestType2);
            }
        }
    }

    public void runAsync(@Nonnull ToopRequestWithAttachments140 toopRequestWithAttachments140) throws Exception {
        int n;
        TDETOOPRequestType tDETOOPRequestType = toopRequestWithAttachments140.getRequest().clone();
        String string = tDETOOPRequestType.getDocumentUniversalUniqueIdentifier() != null ? tDETOOPRequestType.getDocumentUniversalUniqueIdentifier().getValue() : "temp-tc2-id-" + GlobalIDFactory.getNewIntID();
        String string2 = "[" + string + "] ";
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        ToopKafkaClient.send((IErrorLevel)EErrorLevel.INFO, () -> string2 + "Received DP Incoming Request (2/4)");
        String string3 = TCConfig.getSMMMappingNamespaceURIForDP();
        if (StringHelper.hasText((String)string3)) {
            SMMClient sMMClient = new SMMClient();
            MessageProcessorDPIncomingPerformer._iterateTCConcepts(tDETOOPRequestType, tDEConceptRequestType -> sMMClient.addConceptToBeMapped(ConceptValue.create((TDEConceptRequestType)tDEConceptRequestType)));
            int n2 = sMMClient.getTotalCountConceptsToBeMapped();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(string2 + "A total of " + n2 + " concepts need to be mapped");
            }
            if (n2 > 0) {
                ToopKafkaClient.send((IErrorLevel)EErrorLevel.INFO, () -> string2 + "SMM client is mapping " + sMMClient.getTotalCountConceptsToBeMapped() + " concept(s) to namespace '" + string3 + "'");
                boolean bl = TCConfig.isSMMDPMappingErrorFatal();
                ISMMUnmappableCallback & Serializable intersect = (arg_0, arg_1, arg_2, arg_3) -> MessageProcessorDPIncomingPerformer.lambda$runAsync$84a9aafe$1(bl, (ICommonsList)commonsArrayList, arg_0, arg_1, arg_2, arg_3);
                IMappedValueList iMappedValueList = sMMClient.performMapping(string2, string3, MPConfig.getSMMConceptProvider(), intersect);
                ToopKafkaClient.send((IErrorLevel)EErrorLevel.INFO, () -> string2 + "SMM client mapping found " + iMappedValueList.size() + " mapping(s)");
                MessageProcessorDPIncomingPerformer._iterateTCConcepts(tDETOOPRequestType, tDEConceptRequestType -> {
                    tDEConceptRequestType.getSemanticMappingExecutionIndicator().setValue(true);
                    ConceptValue conceptValue = ConceptValue.create((TDEConceptRequestType)tDEConceptRequestType);
                    for (MappedValue mappedValue : iMappedValueList.getAllBySource(conceptValue2 -> conceptValue2.equals((Object)conceptValue))) {
                        TDEConceptRequestType tDEConceptRequestType2 = new TDEConceptRequestType();
                        tDEConceptRequestType2.setConceptTypeCode(ToopXSDHelper140.createCode((String)EConceptType.DP.getID()));
                        tDEConceptRequestType2.setSemanticMappingExecutionIndicator(ToopXSDHelper140.createIndicator((boolean)false));
                        tDEConceptRequestType2.setConceptNamespace(ToopXSDHelper140.createIdentifier((String)mappedValue.getDestination().getNamespace()));
                        tDEConceptRequestType2.setConceptName(ToopXSDHelper140.createText((String)mappedValue.getDestination().getValue()));
                        tDEConceptRequestType.addConceptRequest(tDEConceptRequestType2);
                    }
                });
                ToopKafkaClient.send((IErrorLevel)EErrorLevel.INFO, () -> string2 + "Finished mapping concepts to namespace '" + string3 + "'.");
            }
        } else {
            ToopKafkaClient.send((IErrorLevel)EErrorLevel.INFO, () -> string2 + "No destination mapping URI provided, so no mapping executed.");
        }
        if (commonsArrayList.isEmpty()) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(string2 + "No errors found. Now forwarding to the DP");
            }
            if (MPConfig.getToDP().passRequestOnToDP(new ToopRequestWithAttachments140(tDETOOPRequestType, toopRequestWithAttachments140.attachments())).isFailure()) {
                commonsArrayList.add((Object)MessageProcessorDPIncomingPerformer._createError((IErrorLevel)EErrorLevel.ERROR, string2, EToopErrorCategory.E_DELIVERY, (IToopErrorCode)EToopErrorCode.GEN, "Error sending request to DP", null));
            }
        }
        if ((n = commonsArrayList.size()) > 0) {
            ToopKafkaClient.send((IErrorLevel)EErrorLevel.INFO, () -> string2 + n + " error(s) were found - directly pushing to queue 3/4.");
            TDETOOPResponseType tDETOOPResponseType = ToopMessageBuilder140.createResponse((TDETOOPRequestType)tDETOOPRequestType);
            MPHelper.fillDefaultResponseFields(string2, tDETOOPResponseType);
            tDETOOPResponseType.getError().addAll(commonsArrayList);
            ToopResponseWithAttachments140 toopResponseWithAttachments140 = new ToopResponseWithAttachments140(tDETOOPResponseType, toopRequestWithAttachments140.attachments());
            MessageProcessorDPOutgoing.getInstance().enqueue(toopResponseWithAttachments140);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(string2 + "End of processing");
        }
    }

    private static /* synthetic */ void lambda$runAsync$84a9aafe$1(boolean bl, ICommonsList iCommonsList, String string, String string2, String string3, String string4) {
        String string5 = "Found no mapping for '" + string2 + '#' + string3 + "' to destination namespace '" + string4 + "'";
        if (bl) {
            iCommonsList.add((Object)MessageProcessorDPIncomingPerformer._createError((IErrorLevel)EErrorLevel.ERROR, string, EToopErrorCategory.SEMANTIC_MAPPING, (IToopErrorCode)EToopErrorCode.SM_002, string5, null));
        } else {
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn(string + string5 + " (continuing anyway)");
            }
            ToopKafkaClient.send((IErrorLevel)EErrorLevel.WARN, () -> string + string5);
        }
    }
}

