/*
 * Decompiled with CFR 0.152.
 */
package eu.toop.connector.app.mp;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.UsedViaReflection;
import com.helger.commons.concurrent.BasicThreadFactory;
import com.helger.commons.concurrent.ExecutorServiceHelper;
import com.helger.commons.concurrent.collector.ConcurrentCollectorSingle;
import com.helger.commons.concurrent.collector.IConcurrentPerformer;
import com.helger.commons.error.level.EErrorLevel;
import com.helger.commons.error.level.IErrorLevel;
import com.helger.commons.state.ESuccess;
import com.helger.scope.IScope;
import com.helger.web.scope.singleton.AbstractGlobalWebSingleton;
import eu.toop.commons.exchange.ToopResponseWithAttachments140;
import eu.toop.connector.app.mp.MessageProcessorDPOutgoingPerformer;
import eu.toop.kafkaclient.ToopKafkaClient;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MessageProcessorDPOutgoing
extends AbstractGlobalWebSingleton {
    private static final Logger LOGGER = LoggerFactory.getLogger(MessageProcessorDPOutgoing.class);
    private static final ThreadFactory s_aThreadFactory = new BasicThreadFactory.Builder().setNamingPattern("MP-DP-Out-%d").setDaemon(true).build();
    private final ConcurrentCollectorSingle<ToopResponseWithAttachments140> m_aCollector = new ConcurrentCollectorSingle();
    private final ExecutorService m_aExecutorPool;

    @Deprecated
    @UsedViaReflection
    public MessageProcessorDPOutgoing() {
        this.m_aCollector.setPerformer((IConcurrentPerformer)new MessageProcessorDPOutgoingPerformer());
        this.m_aExecutorPool = Executors.newSingleThreadExecutor(s_aThreadFactory);
        this.m_aExecutorPool.submit(() -> this.m_aCollector.collect());
    }

    @Nonnull
    public static MessageProcessorDPOutgoing getInstance() {
        return (MessageProcessorDPOutgoing)MessageProcessorDPOutgoing.getGlobalSingleton(MessageProcessorDPOutgoing.class);
    }

    protected void onDestroy(@Nonnull IScope iScope) throws Exception {
        this.m_aCollector.stopQueuingNewObjects();
        ExecutorServiceHelper.shutdownAndWaitUntilAllTasksAreFinished((ExecutorService)this.m_aExecutorPool);
    }

    @Nonnull
    public ESuccess enqueue(@Nonnull ToopResponseWithAttachments140 toopResponseWithAttachments140) {
        ValueEnforcer.notNull((Object)toopResponseWithAttachments140, (String)"Msg");
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Enqueueing new object for step 3/4: " + toopResponseWithAttachments140);
        }
        try {
            this.m_aCollector.queueObject((Object)toopResponseWithAttachments140);
            return ESuccess.SUCCESS;
        }
        catch (IllegalStateException illegalStateException) {
            ToopKafkaClient.send((IErrorLevel)EErrorLevel.ERROR, () -> "Cannot enqueue " + toopResponseWithAttachments140, (Throwable)illegalStateException);
            return ESuccess.FAILURE;
        }
    }
}

