/*
 * Decompiled with CFR 0.152.
 */
package eu.toop.connector.app.mp;

import com.helger.asic.AsicUtils;
import com.helger.asic.SignatureHelper;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.concurrent.collector.IConcurrentPerformer;
import com.helger.commons.error.level.EErrorLevel;
import com.helger.commons.error.level.IErrorLevel;
import com.helger.commons.error.list.ErrorList;
import com.helger.commons.id.factory.GlobalIDFactory;
import com.helger.commons.io.ByteArrayWrapper;
import com.helger.commons.io.stream.NonBlockingByteArrayOutputStream;
import com.helger.commons.lang.StackTraceHelper;
import com.helger.commons.text.IMultilingualText;
import com.helger.commons.text.MultilingualText;
import com.helger.jaxb.validation.WrappedCollectingValidationEventHandler;
import com.helger.peppolid.IDocumentTypeIdentifier;
import com.helger.peppolid.IParticipantIdentifier;
import com.helger.peppolid.IProcessIdentifier;
import com.helger.schematron.svrl.AbstractSVRLMessage;
import eu.toop.commons.dataexchange.v140.TDEDataProviderType;
import eu.toop.commons.dataexchange.v140.TDEErrorType;
import eu.toop.commons.dataexchange.v140.TDETOOPResponseType;
import eu.toop.commons.error.EToopErrorCategory;
import eu.toop.commons.error.EToopErrorCode;
import eu.toop.commons.error.EToopErrorOrigin;
import eu.toop.commons.error.EToopErrorSeverity;
import eu.toop.commons.error.IToopErrorCode;
import eu.toop.commons.error.ToopErrorException;
import eu.toop.commons.exchange.AsicReadEntry;
import eu.toop.commons.exchange.AsicWriteEntry;
import eu.toop.commons.exchange.ToopMessageBuilder140;
import eu.toop.commons.exchange.ToopResponseWithAttachments140;
import eu.toop.commons.jaxb.ToopWriter;
import eu.toop.commons.schematron.TOOPSchematron140Validator;
import eu.toop.connector.api.TCConfig;
import eu.toop.connector.api.TCSettings;
import eu.toop.connector.api.as4.IMERoutingInformation;
import eu.toop.connector.api.as4.MEException;
import eu.toop.connector.api.as4.MEMessage;
import eu.toop.connector.api.as4.MEPayload;
import eu.toop.connector.api.as4.MERoutingInformation;
import eu.toop.connector.api.as4.MessageExchangeManager;
import eu.toop.connector.api.r2d2.IR2D2Endpoint;
import eu.toop.connector.api.r2d2.IR2D2ErrorHandler;
import eu.toop.connector.app.TCDumpHelper;
import eu.toop.connector.app.mp.MPConfig;
import eu.toop.kafkaclient.ToopKafkaClient;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.bind.ValidationEventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

final class MessageProcessorDPOutgoingPerformer
implements IConcurrentPerformer<ToopResponseWithAttachments140> {
    private static final Logger LOGGER = LoggerFactory.getLogger(MessageProcessorDPOutgoingPerformer.class);

    MessageProcessorDPOutgoingPerformer() {
    }

    @Nonnull
    private static TDEErrorType _createError(@Nonnull IErrorLevel iErrorLevel, @Nonnull String string, @Nonnull EToopErrorCategory eToopErrorCategory, @Nonnull IToopErrorCode iToopErrorCode, @Nonnull String string2, @Nullable Throwable throwable) {
        ToopKafkaClient.send((IErrorLevel)iErrorLevel, () -> string + "[" + (String)iToopErrorCode.getID() + "] " + string2, (Throwable)throwable);
        return ToopMessageBuilder140.createError(null, (EToopErrorOrigin)EToopErrorOrigin.RESPONSE_SUBMISSION, (EToopErrorCategory)eToopErrorCategory, (IToopErrorCode)iToopErrorCode, (EToopErrorSeverity)(iErrorLevel.isError() ? EToopErrorSeverity.FAILURE : EToopErrorSeverity.WARNING), (IMultilingualText)new MultilingualText(Locale.US, string2), (String)(throwable == null ? null : StackTraceHelper.getStackAsString((Throwable)throwable)));
    }

    @Nonnull
    private static TDEErrorType _createError(@Nonnull String string, @Nonnull EToopErrorCategory eToopErrorCategory, @Nonnull IToopErrorCode iToopErrorCode, @Nonnull String string2, @Nullable Throwable throwable) {
        return MessageProcessorDPOutgoingPerformer._createError((IErrorLevel)EErrorLevel.ERROR, string, eToopErrorCategory, iToopErrorCode, string2, throwable);
    }

    @Nonnull
    private static TDEErrorType _createGenericError(@Nonnull String string, @Nonnull Throwable throwable) {
        return MessageProcessorDPOutgoingPerformer._createError(string, EToopErrorCategory.TECHNICAL_ERROR, (IToopErrorCode)EToopErrorCode.GEN, throwable.getMessage(), throwable);
    }

    public void runAsync(@Nonnull ToopResponseWithAttachments140 toopResponseWithAttachments140) throws Exception {
        int n;
        Object object;
        ICommonsList iCommonsList2;
        Document document;
        ErrorList errorList;
        TDETOOPResponseType tDETOOPResponseType = toopResponseWithAttachments140.getResponse();
        String string = tDETOOPResponseType.getDataRequestIdentifier() != null ? tDETOOPResponseType.getDataRequestIdentifier().getValue() : "temp-tc3-id-" + GlobalIDFactory.getNewIntID();
        String string2 = "[" + string + "] ";
        ToopKafkaClient.send((IErrorLevel)EErrorLevel.INFO, () -> string2 + "Received DP outgoing response (3/4)");
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        if (TCConfig.isMPSchematronValidationEnabled()) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(string2 + "Performing Schematron validation on incoming TOOP response");
            }
            errorList = new ErrorList();
            document = ((ToopWriter)ToopWriter.response140().setValidationEventHandler((ValidationEventHandler)new WrappedCollectingValidationEventHandler(errorList))).getAsDocument((Object)tDETOOPResponseType);
            if (document == null) {
                for (ICommonsList iCommonsList2 : errorList) {
                    commonsArrayList.add((Object)MessageProcessorDPOutgoingPerformer._createError(iCommonsList2.getErrorLevel(), string2, EToopErrorCategory.PARSING, (IToopErrorCode)EToopErrorCode.IF_001, iCommonsList2.getErrorText(Locale.US), iCommonsList2.getLinkedException()));
                }
            } else {
                object = new TOOPSchematron140Validator();
                iCommonsList2 = object.validateTOOPMessage(document);
                for (AbstractSVRLMessage abstractSVRLMessage : iCommonsList2) {
                    commonsArrayList.add((Object)MessageProcessorDPOutgoingPerformer._createError(abstractSVRLMessage.getFlag(), string2, EToopErrorCategory.PARSING, (IToopErrorCode)EToopErrorCode.IF_001, "[" + abstractSVRLMessage.getLocation() + "] [Test: " + abstractSVRLMessage.getTest() + "] " + abstractSVRLMessage.getText(), null));
                }
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(string2 + "Finished Schematron validation with the following results: " + errorList);
            }
        } else {
            ToopKafkaClient.send((IErrorLevel)EErrorLevel.INFO, () -> string2 + "Schematron validation was explicitly disabled.");
        }
        if (commonsArrayList.isEmpty()) {
            TDEDataProviderType tDEDataProviderType = errorList = tDETOOPResponseType.getDataProvider().isEmpty() ? null : tDETOOPResponseType.getDataProviderAtIndex(0);
            if (errorList == null) {
                commonsArrayList.add((Object)MessageProcessorDPOutgoingPerformer._createError(string2, EToopErrorCategory.PARSING, (IToopErrorCode)EToopErrorCode.IF_001, "The DataProvider element is missing in the response", null));
            } else {
                String string3;
                AbstractSVRLMessage abstractSVRLMessage;
                document = TCSettings.getIdentifierFactory();
                object = tDETOOPResponseType.getRoutingInformation();
                iCommonsList2 = document.createParticipantIdentifier(object.getDataConsumerElectronicAddressIdentifier().getSchemeID(), object.getDataConsumerElectronicAddressIdentifier().getValue());
                Iterator iterator = document.createDocumentTypeIdentifier(object.getDocumentTypeIdentifier().getSchemeID(), object.getDocumentTypeIdentifier().getValue());
                abstractSVRLMessage = document.createProcessIdentifier(object.getProcessIdentifier().getSchemeID(), object.getProcessIdentifier().getValue());
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug(string2 + "Starting SMP lookup for an source participant: " + iCommonsList2.getURIEncoded());
                }
                String string4 = TCConfig.getMEMProtocol().getTransportProfileID();
                String string5 = (arg_0, arg_1, arg_2, arg_3) -> MessageProcessorDPOutgoingPerformer.lambda$runAsync$170670eb$1((ICommonsList)commonsArrayList, string2, arg_0, arg_1, arg_2, arg_3);
                ICommonsList iCommonsList3 = MPConfig.getEndpointProvider().getEndpoints(string2, (IParticipantIdentifier)iCommonsList2, (IDocumentTypeIdentifier)iterator, (IProcessIdentifier)abstractSVRLMessage, string4, (IR2D2ErrorHandler)string5);
                ToopKafkaClient.send((IErrorLevel)(iCommonsList3.size() == 1 ? EErrorLevel.INFO : EErrorLevel.ERROR), () -> string2 + "R2D2 found " + iCommonsList3.size() + " endpoint(s)");
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug(string2 + "Endpoint details: " + iCommonsList3);
                }
                string4 = null;
                if (object.getDataProviderElectronicAddressIdentifier() == null) {
                    commonsArrayList.add((Object)MessageProcessorDPOutgoingPerformer._createError(string2, EToopErrorCategory.PARSING, (IToopErrorCode)EToopErrorCode.IF_001, "The RoutingInformation/DataProviderElectronicAddressIdentifier element is missing in the response", null));
                } else {
                    string5 = object.getDataProviderElectronicAddressIdentifier().getSchemeID();
                    string4 = document.createParticipantIdentifier(string5, string3 = object.getDataProviderElectronicAddressIdentifier().getValue());
                    if (string4 == null) {
                        commonsArrayList.add((Object)MessageProcessorDPOutgoingPerformer._createError(string2, EToopErrorCategory.PARSING, (IToopErrorCode)EToopErrorCode.IF_001, "The RoutingInformation/DataProviderElectronicAddressIdentifier element contains invalid values '" + string5 + "' and '" + string3 + "'", null));
                    }
                }
                if (iCommonsList3.isEmpty()) {
                    commonsArrayList.add((Object)MessageProcessorDPOutgoingPerformer._createError(string2, EToopErrorCategory.DYNAMIC_DISCOVERY, (IToopErrorCode)EToopErrorCode.DD_004, "Found no matching DC endpoint - not transmitting response from DP '" + (string4 == null ? "null" : string4.getURIEncoded()) + "' to DC '" + iCommonsList2.getURIEncoded() + "'!", null));
                }
                if (commonsArrayList.isEmpty()) {
                    CommonsArrayList commonsArrayList2;
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug(string2 + "Started creating TOOP response ASIC container");
                    }
                    string5 = null;
                    string3 = new NonBlockingByteArrayOutputStream();
                    Throwable throwable = null;
                    try {
                        try (OutputStream outputStream = TCDumpHelper.getDumpOutputStream((OutputStream)((Object)string3), TCConfig.getDebugToDCDumpPathIfEnabled(), "to-dc.asic");){
                            commonsArrayList2 = new CommonsArrayList();
                            for (AsicReadEntry asicReadEntry : toopResponseWithAttachments140.attachments()) {
                                commonsArrayList2.add((Object)AsicWriteEntry.create((AsicReadEntry)asicReadEntry));
                            }
                            ToopMessageBuilder140.createResponseMessageAsic((TDETOOPResponseType)tDETOOPResponseType, (OutputStream)outputStream, (SignatureHelper)MPConfig.getSignatureHelper(), (Iterable)commonsArrayList2);
                        }
                        catch (ToopErrorException toopErrorException) {
                            commonsArrayList.add((Object)MessageProcessorDPOutgoingPerformer._createError(string2, EToopErrorCategory.E_DELIVERY, toopErrorException.getErrorCode(), toopErrorException.getMessage(), toopErrorException.getCause()));
                        }
                        catch (IOException iOException) {
                            commonsArrayList.add((Object)MessageProcessorDPOutgoingPerformer._createGenericError(string2, iOException));
                        }
                        string5 = ByteArrayWrapper.create((NonBlockingByteArrayOutputStream)string3, (boolean)false);
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug(string2 + "Created TOOP response ASIC container has " + string5.size() + " bytes");
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (string3 != null) {
                            if (throwable != null) {
                                try {
                                    string3.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                            } else {
                                string3.close();
                            }
                        }
                    }
                    if (commonsArrayList.isEmpty()) {
                        string3 = new MEPayload(AsicUtils.MIMETYPE_ASICE, string, (ByteArrayWrapper)string5);
                        throwable = MEMessage.create((MEPayload)string3);
                        for (Throwable throwable4 : iCommonsList3) {
                            ToopKafkaClient.send((IErrorLevel)EErrorLevel.INFO, () -> MessageProcessorDPOutgoingPerformer.lambda$runAsync$4(string2, (IR2D2Endpoint)throwable4));
                            commonsArrayList2 = new MERoutingInformation((IParticipantIdentifier)string4, throwable4.getParticipantID(), (IDocumentTypeIdentifier)iterator, (IProcessIdentifier)abstractSVRLMessage, throwable4.getTransportProtocol(), throwable4.getEndpointURL(), throwable4.getCertificate());
                            try {
                                MessageExchangeManager.getConfiguredImplementation().sendDPOutgoing((IMERoutingInformation)commonsArrayList2, (MEMessage)throwable);
                                if (!LOGGER.isDebugEnabled()) continue;
                                LOGGER.debug(string2 + "sendDPOutgoing returned without exception");
                            }
                            catch (MEException mEException) {
                                commonsArrayList.add((Object)MessageProcessorDPOutgoingPerformer._createError(string2, EToopErrorCategory.E_DELIVERY, (IToopErrorCode)EToopErrorCode.ME_001, "Error sending message", mEException));
                            }
                        }
                    }
                }
            }
        }
        if ((n = commonsArrayList.size()) > 0) {
            ToopKafkaClient.send((IErrorLevel)EErrorLevel.INFO, () -> string2 + n + " error(s) were found - returning errors to DP.");
            tDETOOPResponseType.getError().addAll(commonsArrayList);
            if (MPConfig.getToDP().returnErrorResponseToDP(toopResponseWithAttachments140).isFailure()) {
                ToopKafkaClient.send((IErrorLevel)EErrorLevel.ERROR, () -> string2 + "Error sending response back to DP");
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(string2 + "End of processing");
        }
    }

    private static /* synthetic */ String lambda$runAsync$4(String string, IR2D2Endpoint iR2D2Endpoint) {
        return string + "Sending MEM message to '" + iR2D2Endpoint.getEndpointURL() + "' using transport protocol '" + iR2D2Endpoint.getTransportProtocol() + "'";
    }

    private static /* synthetic */ void lambda$runAsync$170670eb$1(ICommonsList iCommonsList, String string, EErrorLevel eErrorLevel, String string2, Throwable throwable, IToopErrorCode iToopErrorCode) {
        iCommonsList.add((Object)MessageProcessorDPOutgoingPerformer._createError((IErrorLevel)eErrorLevel, string, EToopErrorCategory.DYNAMIC_DISCOVERY, iToopErrorCode, string2, throwable));
    }
}

