/*
 * Decompiled with CFR 0.152.
 */
package eu.toop.connector.app.r2d2;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.collection.impl.ICommonsSet;
import com.helger.commons.error.level.EErrorLevel;
import com.helger.commons.error.level.IErrorLevel;
import com.helger.commons.string.StringHelper;
import com.helger.peppolid.IDocumentTypeIdentifier;
import com.helger.peppolid.IIdentifier;
import com.helger.peppolid.IParticipantIdentifier;
import com.helger.peppolid.IProcessIdentifier;
import eu.toop.commons.error.EToopErrorCode;
import eu.toop.commons.error.IToopErrorCode;
import eu.toop.connector.api.r2d2.IR2D2Endpoint;
import eu.toop.connector.api.r2d2.IR2D2EndpointProvider;
import eu.toop.connector.api.r2d2.IR2D2ErrorHandler;
import eu.toop.connector.api.r2d2.IR2D2ParticipantIDProvider;
import eu.toop.kafkaclient.ToopKafkaClient;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public class R2D2Client {
    private R2D2Client() {
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsList<IR2D2Endpoint> getParticipantIDsAndEndpoints(@Nonnull String string, @Nonnull @Nonempty String string2, @Nonnull IDocumentTypeIdentifier iDocumentTypeIdentifier, @Nonnull IR2D2ParticipantIDProvider iR2D2ParticipantIDProvider, @Nonnull IProcessIdentifier iProcessIdentifier, @Nonnull @Nonempty String string3, @Nonnull IR2D2EndpointProvider iR2D2EndpointProvider, @Nonnull IR2D2ErrorHandler iR2D2ErrorHandler) {
        ValueEnforcer.notEmpty((CharSequence)string2, (String)"CountryCode");
        ValueEnforcer.isTrue((string2.length() == 2 ? 1 : 0) != 0, (String)"CountryCode must have length 2");
        ValueEnforcer.notNull((Object)iDocumentTypeIdentifier, (String)"DocumentTypeID");
        ValueEnforcer.notNull((Object)iR2D2ParticipantIDProvider, (String)"ParticipantIDProvider");
        ValueEnforcer.notNull((Object)iProcessIdentifier, (String)"ProcessID");
        ValueEnforcer.notEmpty((CharSequence)string3, (String)"TransportProfileID");
        ValueEnforcer.notNull((Object)iR2D2EndpointProvider, (String)"EndpointProvider");
        ValueEnforcer.notNull((Object)iR2D2ErrorHandler, (String)"ErrorHandler");
        ToopKafkaClient.send((IErrorLevel)EErrorLevel.INFO, () -> string + "Participant ID lookup (" + string2 + ", " + iDocumentTypeIdentifier.getURIEncoded() + ", " + iProcessIdentifier.getURIEncoded() + ", " + string3 + ") using participant ID provider " + iR2D2ParticipantIDProvider + " and endpoint ID provider " + iR2D2EndpointProvider);
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        ICommonsSet iCommonsSet = iR2D2ParticipantIDProvider.getAllParticipantIDs(string, string2, iDocumentTypeIdentifier, iR2D2ErrorHandler);
        ToopKafkaClient.send((IErrorLevel)EErrorLevel.INFO, () -> string + "Participant ID lookup result[" + iCommonsSet.size() + "]: " + StringHelper.getImplodedMapped((String)", ", (Iterable)iCommonsSet, IIdentifier::getURIEncoded));
        if (iCommonsSet.isEmpty()) {
            iR2D2ErrorHandler.onError("Participant ID lookup returned no matches", (IToopErrorCode)EToopErrorCode.DD_004);
        } else {
            for (IParticipantIdentifier iParticipantIdentifier : iCommonsSet) {
                ICommonsList iCommonsList = iR2D2EndpointProvider.getEndpoints(string, iParticipantIdentifier, iDocumentTypeIdentifier, iProcessIdentifier, string3, iR2D2ErrorHandler);
                commonsArrayList.addAll((Collection)iCommonsList);
                if (!iCommonsList.isEmpty()) continue;
                iR2D2ErrorHandler.onWarning("Endpoint lookup for '" + iParticipantIdentifier.getURIEncoded() + "' and document type ID '" + iDocumentTypeIdentifier.getURIEncoded() + "' and process ID '" + iProcessIdentifier.getURIEncoded() + "' and transport profile '" + string3 + "' returned in no endpoints", (IToopErrorCode)EToopErrorCode.DD_005);
            }
        }
        return commonsArrayList;
    }
}

