/*
 * Decompiled with CFR 0.152.
 */
package eu.toop.connector.app.r2d2;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.CollectionHelper;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.error.level.EErrorLevel;
import com.helger.commons.error.level.IErrorLevel;
import com.helger.commons.io.stream.NonBlockingByteArrayInputStream;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.peppol.bdxrclient.BDXRClient;
import com.helger.peppol.smpclient.exception.SMPClientException;
import com.helger.peppol.url.PeppolDNSResolutionException;
import com.helger.peppolid.IDocumentTypeIdentifier;
import com.helger.peppolid.IParticipantIdentifier;
import com.helger.peppolid.IProcessIdentifier;
import com.helger.peppolid.simple.process.SimpleProcessIdentifier;
import com.helger.security.certificate.CertificateHelper;
import com.helger.xsds.bdxr.smp1.EndpointType;
import com.helger.xsds.bdxr.smp1.ProcessIdentifierType;
import com.helger.xsds.bdxr.smp1.ProcessType;
import com.helger.xsds.bdxr.smp1.ServiceInformationType;
import com.helger.xsds.bdxr.smp1.SignedServiceMetadataType;
import eu.toop.commons.error.EToopErrorCode;
import eu.toop.commons.error.IToopErrorCode;
import eu.toop.connector.api.TCConfig;
import eu.toop.connector.api.TCSettings;
import eu.toop.connector.api.r2d2.IR2D2Endpoint;
import eu.toop.connector.api.r2d2.IR2D2EndpointProvider;
import eu.toop.connector.api.r2d2.IR2D2ErrorHandler;
import eu.toop.connector.api.r2d2.R2D2Endpoint;
import eu.toop.kafkaclient.ToopKafkaClient;
import java.io.InputStream;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public class R2D2EndpointProviderBDXRSMP1
implements IR2D2EndpointProvider {
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<IR2D2Endpoint> getEndpoints(@Nonnull String string, @Nonnull IParticipantIdentifier iParticipantIdentifier, @Nonnull IDocumentTypeIdentifier iDocumentTypeIdentifier, @Nonnull IProcessIdentifier iProcessIdentifier, @Nonnull @Nonempty String string2, @Nonnull IR2D2ErrorHandler iR2D2ErrorHandler) {
        ValueEnforcer.notNull((Object)iParticipantIdentifier, (String)"Recipient");
        ValueEnforcer.notNull((Object)iDocumentTypeIdentifier, (String)"DocumentTypeID");
        ValueEnforcer.notNull((Object)iProcessIdentifier, (String)"ProcessID");
        ValueEnforcer.notEmpty((CharSequence)string2, (String)"TransportProfileID");
        ValueEnforcer.notNull((Object)iR2D2ErrorHandler, (String)"ErrorHandler");
        ToopKafkaClient.send((IErrorLevel)EErrorLevel.INFO, () -> string + "SMP lookup (" + iParticipantIdentifier.getURIEncoded() + ", " + iDocumentTypeIdentifier.getURIEncoded() + ", " + iProcessIdentifier.getURIEncoded() + ", " + string2 + ")");
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        try {
            ServiceInformationType serviceInformationType;
            BDXRClient bDXRClient = TCConfig.isR2D2UseDNS() ? new BDXRClient(TCSettings.getSMPUrlProvider(), iParticipantIdentifier, TCConfig.getR2D2SML()) : new BDXRClient(TCConfig.getR2D2SMPUrl());
            SignedServiceMetadataType signedServiceMetadataType = bDXRClient.getServiceMetadataOrNull(iParticipantIdentifier, iDocumentTypeIdentifier);
            ServiceInformationType serviceInformationType2 = serviceInformationType = signedServiceMetadataType == null ? null : signedServiceMetadataType.getServiceMetadata().getServiceInformation();
            if (serviceInformationType != null) {
                ProcessType processType2 = (ProcessType)CollectionHelper.findFirst((Iterable)serviceInformationType.getProcessList().getProcess(), processType -> SimpleProcessIdentifier.wrap((ProcessIdentifierType)processType.getProcessIdentifier()).hasSameContent(iProcessIdentifier));
                if (processType2 != null) {
                    for (EndpointType endpointType : processType2.getServiceEndpointList().getEndpoint()) {
                        if (!string2.equals(endpointType.getTransportProfile())) continue;
                        CertificateFactory certificateFactory = CertificateHelper.getX509CertificateFactory();
                        X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate((InputStream)new NonBlockingByteArrayInputStream(endpointType.getCertificate()));
                        if (StringHelper.hasNoText((String)endpointType.getEndpointURI())) {
                            ToopKafkaClient.send((IErrorLevel)EErrorLevel.WARN, () -> string + "SMP lookup result: endpoint has no URI");
                            continue;
                        }
                        certificateFactory = new R2D2Endpoint(iParticipantIdentifier, endpointType.getTransportProfile(), endpointType.getEndpointURI(), x509Certificate);
                        commonsArrayList.add((Object)certificateFactory);
                        ToopKafkaClient.send((IErrorLevel)EErrorLevel.INFO, () -> string + "SMP lookup result: " + endpointType.getTransportProfile() + ", " + endpointType.getEndpointURI());
                    }
                }
            } else {
                ToopKafkaClient.send((IErrorLevel)EErrorLevel.INFO, () -> string + "SMP lookup result: maybe a redirect?");
            }
        }
        catch (SMPClientException | PeppolDNSResolutionException throwable) {
            iR2D2ErrorHandler.onError(string + "Error fetching SMP endpoint " + iParticipantIdentifier.getURIEncoded() + "/" + iDocumentTypeIdentifier.getURIEncoded() + "/" + iProcessIdentifier.getURIEncoded(), throwable, (IToopErrorCode)EToopErrorCode.DD_002);
        }
        catch (CertificateException certificateException) {
            iR2D2ErrorHandler.onError(string + "Error validating the signature from SMP response for endpoint " + iParticipantIdentifier.getURIEncoded() + "/" + iDocumentTypeIdentifier.getURIEncoded() + "/" + iProcessIdentifier.getURIEncoded(), (Throwable)certificateException, (IToopErrorCode)EToopErrorCode.DD_003);
        }
        return commonsArrayList;
    }

    public String toString() {
        return new ToStringGenerator((Object)this).getToString();
    }
}

