/*
 * Decompiled with CFR 0.152.
 */
package eu.toop.connector.app.r2d2;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.collection.impl.CommonsHashSet;
import com.helger.commons.collection.impl.ICommonsSet;
import com.helger.commons.error.level.EErrorLevel;
import com.helger.commons.error.level.IErrorLevel;
import com.helger.commons.string.ToStringGenerator;
import com.helger.commons.url.ISimpleURL;
import com.helger.commons.url.SimpleURL;
import com.helger.httpclient.HttpClientManager;
import com.helger.httpclient.IHttpClientProvider;
import com.helger.httpclient.response.ResponseHandlerJson;
import com.helger.json.IJson;
import com.helger.json.IJsonArray;
import com.helger.json.IJsonObject;
import com.helger.peppolid.IDocumentTypeIdentifier;
import com.helger.peppolid.IParticipantIdentifier;
import eu.toop.commons.error.EToopErrorCode;
import eu.toop.commons.error.IToopErrorCode;
import eu.toop.connector.api.TCConfig;
import eu.toop.connector.api.TCSettings;
import eu.toop.connector.api.http.TCHttpClientFactory;
import eu.toop.connector.api.r2d2.IR2D2ErrorHandler;
import eu.toop.connector.api.r2d2.IR2D2ParticipantIDProvider;
import eu.toop.kafkaclient.ToopKafkaClient;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;

public class R2D2ParticipantIDProviderTOOPDirectory
implements IR2D2ParticipantIDProvider {
    private static final int MAX_RESULTS_PER_PAGE = 100;
    private final String m_sBaseURL;

    public R2D2ParticipantIDProviderTOOPDirectory() {
        this(TCConfig.getR2D2DirectoryBaseUrl());
    }

    public R2D2ParticipantIDProviderTOOPDirectory(@Nonnull String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"BaseURL");
        this.m_sBaseURL = string;
    }

    @Nonnull
    @Nonempty
    public final String getBaseURL() {
        return this.m_sBaseURL;
    }

    @Nullable
    private static IJsonObject _fetchJsonObject(@Nonnull String string, @Nonnull HttpClientManager httpClientManager, @Nonnull ISimpleURL iSimpleURL) throws IOException {
        ResponseHandlerJson responseHandlerJson;
        HttpGet httpGet = new HttpGet(iSimpleURL.getAsURI());
        IJson iJson = (IJson)httpClientManager.execute((HttpUriRequest)httpGet, (ResponseHandler)(responseHandlerJson = new ResponseHandlerJson()));
        if (iJson != null && iJson.isObject()) {
            return iJson.getAsObject();
        }
        ToopKafkaClient.send((IErrorLevel)EErrorLevel.ERROR, () -> string + "Failed to fetch " + iSimpleURL.getAsStringWithEncodedParameters() + " - stopping");
        return null;
    }

    @Nonnull
    public ICommonsSet<IParticipantIdentifier> getAllParticipantIDs(@Nonnull String string, @Nonnull @Nonempty String string2, @Nonnull IDocumentTypeIdentifier iDocumentTypeIdentifier, @Nonnull IR2D2ErrorHandler iR2D2ErrorHandler) {
        CommonsHashSet commonsHashSet;
        block22: {
            commonsHashSet = new CommonsHashSet();
            TCHttpClientFactory tCHttpClientFactory = new TCHttpClientFactory();
            try (HttpClientManager httpClientManager = new HttpClientManager((IHttpClientProvider)tCHttpClientFactory);){
                SimpleURL simpleURL = (SimpleURL)((SimpleURL)((SimpleURL)new SimpleURL(this.m_sBaseURL + "/search/1.0/json").add("doctype", iDocumentTypeIdentifier.getURIEncoded())).add("country", string2)).add("rpc", 100);
                IJsonObject iJsonObject = R2D2ParticipantIDProviderTOOPDirectory._fetchJsonObject(string, httpClientManager, (ISimpleURL)simpleURL);
                if (iJsonObject == null) break block22;
                int n = 0;
                int n2 = 0;
                do {
                    int n3 = 0;
                    IJsonArray iJsonArray = iJsonObject.getAsArray("matches");
                    if (iJsonArray != null) {
                        for (IJson iJson : iJsonArray) {
                            ++n3;
                            IJsonObject iJsonObject2 = iJson.getAsObject().getAsObject("participantID");
                            if (iJsonObject2 != null) {
                                String string3 = iJsonObject2.getAsString((Object)"scheme");
                                String string4 = iJsonObject2.getAsString((Object)"value");
                                IParticipantIdentifier iParticipantIdentifier = TCSettings.getIdentifierFactory().createParticipantIdentifier(string3, string4);
                                if (iParticipantIdentifier != null) {
                                    commonsHashSet.add((Object)iParticipantIdentifier);
                                    continue;
                                }
                                ToopKafkaClient.send((IErrorLevel)EErrorLevel.WARN, () -> string + "Failed to create participant identifier from '" + string3 + "' and '" + string4 + "'");
                                continue;
                            }
                            ToopKafkaClient.send((IErrorLevel)EErrorLevel.WARN, () -> string + "Match does not contain participant ID");
                        }
                    } else {
                        ToopKafkaClient.send((IErrorLevel)EErrorLevel.WARN, () -> string + "JSON response contains no 'matches'");
                    }
                    if (n3 < 100) {
                    } else {
                        if (++n2 <= 100) continue;
                        ToopKafkaClient.send((IErrorLevel)EErrorLevel.ERROR, () -> string + "Endless loop in PD fetching?");
                    }
                    break;
                } while ((iJsonObject = R2D2ParticipantIDProviderTOOPDirectory._fetchJsonObject(string, httpClientManager, (ISimpleURL)simpleURL.getClone().add("rpi", ++n))) != null);
            }
            catch (IOException iOException) {
                iR2D2ErrorHandler.onError(string + "Error querying TOOP Directory for matches (" + string2 + ", " + iDocumentTypeIdentifier.getURIEncoded() + ")", (Throwable)iOException, (IToopErrorCode)EToopErrorCode.DD_001);
            }
        }
        return commonsHashSet;
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("BaseURL", (Object)this.m_sBaseURL).getToString();
    }
}

