/*
 * Decompiled with CFR 0.152.
 */
package eu.toop.connector.app.searchdp;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.string.StringHelper;
import com.helger.commons.url.ISimpleURL;
import com.helger.commons.url.SimpleURL;
import com.helger.httpclient.HttpClientManager;
import com.helger.httpclient.IHttpClientProvider;
import com.helger.httpclient.response.ResponseHandlerMicroDom;
import com.helger.xml.microdom.IMicroDocument;
import eu.toop.connector.api.TCConfig;
import eu.toop.connector.api.http.TCHttpClientFactory;
import eu.toop.connector.app.searchdp.ISearchDPCallback;
import eu.toop.connector.app.searchdp.SearchDPByCountryInputParams;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class SearchDPByCountryHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(SearchDPByCountryHandler.class);

    private SearchDPByCountryHandler() {
    }

    @Nonnull
    public static SearchDPByCountryInputParams extractInputParams(@Nonnull String string) {
        SearchDPByCountryInputParams searchDPByCountryInputParams = new SearchDPByCountryInputParams();
        String string2 = StringHelper.trimStartAndEnd((String)string, (char)'/');
        String[] stringArray = StringHelper.getExplodedArray((char)'/', (String)string2);
        if (stringArray.length >= 1) {
            searchDPByCountryInputParams.setCountryCode(stringArray[0]);
            if (stringArray.length >= 2) {
                searchDPByCountryInputParams.setDocumentType(stringArray[1]);
            }
        }
        return searchDPByCountryInputParams;
    }

    public static void performSearch(@Nonnull SearchDPByCountryInputParams searchDPByCountryInputParams, @Nonnull ISearchDPCallback iSearchDPCallback) throws IOException {
        ValueEnforcer.notNull((Object)searchDPByCountryInputParams, (String)"InputParams");
        ValueEnforcer.isTrue(() -> searchDPByCountryInputParams.hasCountryCode(), (String)"InputParams must have a country code");
        ValueEnforcer.notNull((Object)iSearchDPCallback, (String)"Callback");
        String string = TCConfig.getR2D2DirectoryBaseUrl();
        if (StringHelper.hasNoText((String)string)) {
            throw new IllegalStateException("The Directory base URL configuration is missing");
        }
        TCHttpClientFactory tCHttpClientFactory = new TCHttpClientFactory();
        try (HttpClientManager httpClientManager = new HttpClientManager((IHttpClientProvider)tCHttpClientFactory);){
            ResponseHandlerMicroDom responseHandlerMicroDom;
            HttpGet httpGet;
            IMicroDocument iMicroDocument;
            SimpleURL simpleURL = new SimpleURL(string + "/search/1.0/xml");
            simpleURL.add("rpc", 1000);
            simpleURL.add("identifierScheme", "DataSubjectIdentifierScheme");
            simpleURL.add("country", searchDPByCountryInputParams.getCountryCode().getCountry());
            if (searchDPByCountryInputParams.hasDocumentTypeID()) {
                simpleURL.add("doctype", searchDPByCountryInputParams.getDocumentTypeID().getURIEncoded());
            }
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Querying " + simpleURL.getAsStringWithEncodedParameters());
            }
            if ((iMicroDocument = (IMicroDocument)httpClientManager.execute((HttpUriRequest)(httpGet = new HttpGet(simpleURL.getAsURI())), (ResponseHandler)(responseHandlerMicroDom = new ResponseHandlerMicroDom()))) == null || iMicroDocument.getDocumentElement() == null) {
                if (LOGGER.isErrorEnabled()) {
                    LOGGER.error("Failed to invoke the Directory query '" + simpleURL.getAsStringWithEncodedParameters() + "'");
                }
                iSearchDPCallback.onQueryDirectoryError((ISimpleURL)simpleURL);
            } else {
                iSearchDPCallback.onQueryDirectorySuccess(iMicroDocument);
            }
        }
    }
}

