/*
 * Decompiled with CFR 0.152.
 */
package eu.toop.connector.app.searchdp;

import com.helger.commons.locale.country.CountryCache;
import com.helger.commons.state.ESuccess;
import com.helger.commons.string.StringHelper;
import com.helger.peppolid.IDocumentTypeIdentifier;
import eu.toop.connector.api.TCSettings;
import java.io.Serializable;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SearchDPByCountryInputParams
implements Serializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(SearchDPByCountryInputParams.class);
    private Locale m_aCountryCode;
    private IDocumentTypeIdentifier m_aDocTypeID;

    @Nonnull
    public ESuccess setCountryCode(@Nullable String string) {
        if (StringHelper.hasText((String)string)) {
            String string2 = string.trim();
            Locale locale = CountryCache.getInstance().getCountry(string2);
            if (locale != null) {
                this.m_aCountryCode = locale;
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("Using country code '" + string2 + "' for /search-dp-by-country");
                }
                return ESuccess.SUCCESS;
            }
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("Country code '" + string2 + "' could not be resolved to a valid country");
            }
        }
        return ESuccess.FAILURE;
    }

    @Nullable
    public Locale getCountryCode() {
        return this.m_aCountryCode;
    }

    public boolean hasCountryCode() {
        return this.m_aCountryCode != null;
    }

    @Nonnull
    public ESuccess setDocumentType(@Nullable String string) {
        if (StringHelper.hasText((String)string)) {
            String string2 = string.trim();
            IDocumentTypeIdentifier iDocumentTypeIdentifier = TCSettings.getIdentifierFactory().parseDocumentTypeIdentifier(string2);
            if (iDocumentTypeIdentifier != null) {
                this.m_aDocTypeID = iDocumentTypeIdentifier;
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("Using document type ID '" + string2 + "' for /search-dp-by-country");
                }
                return ESuccess.SUCCESS;
            }
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("Document type ID '" + string2 + "' could not be parsed");
            }
        }
        return ESuccess.FAILURE;
    }

    @Nullable
    public IDocumentTypeIdentifier getDocumentTypeID() {
        return this.m_aDocTypeID;
    }

    public boolean hasDocumentTypeID() {
        return this.m_aDocTypeID != null;
    }
}

