/*
 * Decompiled with CFR 0.152.
 */
package eu.toop.connector.app.servlet;

import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.error.level.EErrorLevel;
import com.helger.commons.error.level.IErrorLevel;
import com.helger.commons.mime.CMimeType;
import eu.toop.commons.dataexchange.v140.TDETOOPRequestType;
import eu.toop.commons.dataexchange.v140.TDETOOPResponseType;
import eu.toop.commons.exchange.AsicReadEntry;
import eu.toop.commons.exchange.ToopMessageBuilder140;
import eu.toop.connector.api.TCConfig;
import eu.toop.connector.app.TCDumpHelper;
import eu.toop.connector.app.mp.MPTrigger;
import eu.toop.connector.app.servlet.TCUnifiedResponse;
import eu.toop.kafkaclient.ToopKafkaClient;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nonnull;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@WebServlet(value={"/from-dc"})
public class FromDCServlet
extends HttpServlet {
    protected void doPost(@Nonnull HttpServletRequest httpServletRequest, @Nonnull HttpServletResponse httpServletResponse) throws ServletException, IOException {
        ToopKafkaClient.send((IErrorLevel)EErrorLevel.INFO, () -> "MP got /from-dc HTTP request (1/4)");
        TCUnifiedResponse tCUnifiedResponse = new TCUnifiedResponse(httpServletRequest);
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        TDETOOPRequestType tDETOOPRequestType = ToopMessageBuilder140.parseRequestMessage((InputStream)TCDumpHelper.getDumpInputStream((InputStream)httpServletRequest.getInputStream(), TCConfig.getDebugFromDCDumpPathIfEnabled(), "from-dc.asic"), arg_0 -> ((ICommonsList)commonsArrayList).add(arg_0));
        if (tDETOOPRequestType == null) {
            ToopKafkaClient.send((IErrorLevel)EErrorLevel.ERROR, () -> "The /from-dc request does not contain an ASiC archive, or the ASiC archive does not contain a TOOP DataRequest!");
            tCUnifiedResponse.setContentAndCharset("The provided ASIC container could not be interpreted as a valid TOOP request.", StandardCharsets.UTF_8);
            tCUnifiedResponse.setMimeType(CMimeType.TEXT_PLAIN);
            tCUnifiedResponse.setStatus(400);
        } else {
            if (tDETOOPRequestType instanceof TDETOOPResponseType) {
                ToopKafkaClient.send((IErrorLevel)EErrorLevel.WARN, () -> "The /from-dc request contains a TOOP Response, but needs a TOOP Request only. Please check your endpoint configuration.");
            }
            MPTrigger.fromDC_1_of_4(tDETOOPRequestType, (ICommonsList<AsicReadEntry>)commonsArrayList);
            tCUnifiedResponse.setStatus(202);
        }
        tCUnifiedResponse.applyToResponse(httpServletResponse);
    }
}

