/*
 * Decompiled with CFR 0.152.
 */
package eu.toop.connector.app.servlet;

import com.helger.commons.mime.CMimeType;
import com.helger.commons.mime.IMimeType;
import com.helger.commons.mime.MimeType;
import com.helger.commons.string.StringHelper;
import com.helger.commons.url.ISimpleURL;
import com.helger.servlet.response.UnifiedResponse;
import com.helger.xml.microdom.IMicroDocument;
import com.helger.xml.microdom.IMicroNode;
import com.helger.xml.microdom.serialize.MicroWriter;
import com.helger.xml.namespace.INamespaceContext;
import com.helger.xml.namespace.MapBasedNamespaceContext;
import com.helger.xml.serialize.write.IXMLWriterSettings;
import com.helger.xml.serialize.write.XMLWriterSettings;
import eu.toop.connector.app.searchdp.ISearchDPCallback;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class SearchDPCallback
implements ISearchDPCallback {
    private static final Logger LOGGER = LoggerFactory.getLogger(SearchDPCallback.class);
    private final UnifiedResponse m_aUnifiedResponse;

    SearchDPCallback(@Nonnull UnifiedResponse unifiedResponse) {
        this.m_aUnifiedResponse = unifiedResponse;
    }

    @Override
    public void onQueryDirectoryError(@Nonnull ISimpleURL iSimpleURL) {
        this.m_aUnifiedResponse.disableCaching();
        this.m_aUnifiedResponse.setStatus(500);
    }

    @Override
    public void onQueryDirectorySuccess(@Nonnull IMicroDocument iMicroDocument) {
        XMLWriterSettings xMLWriterSettings = new XMLWriterSettings();
        MapBasedNamespaceContext mapBasedNamespaceContext = new MapBasedNamespaceContext();
        if (StringHelper.hasText((String)iMicroDocument.getDocumentElement().getNamespaceURI())) {
            mapBasedNamespaceContext.setDefaultNamespaceURI(iMicroDocument.getDocumentElement().getNamespaceURI());
        }
        xMLWriterSettings.setNamespaceContext((INamespaceContext)mapBasedNamespaceContext);
        String string = MicroWriter.getNodeAsString((IMicroNode)iMicroDocument, (IXMLWriterSettings)xMLWriterSettings);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Returning " + string.length() + " characters of successul XML response back");
        }
        this.m_aUnifiedResponse.disableCaching();
        this.m_aUnifiedResponse.setMimeType((IMimeType)new MimeType(CMimeType.APPLICATION_XML).addParameter("charset", xMLWriterSettings.getCharset().name()));
        this.m_aUnifiedResponse.setContentAndCharset(string, xMLWriterSettings.getCharset());
    }
}

