/*
 * Decompiled with CFR 0.152.
 */
package eu.toop.connector.app.servlet;

import com.helger.commons.collection.CollectionHelper;
import com.helger.commons.datetime.PDTFactory;
import com.helger.commons.debug.GlobalDebug;
import com.helger.commons.mime.CMimeType;
import com.helger.commons.text.util.TextHelper;
import com.helger.security.keystore.IKeyStoreType;
import com.helger.security.keystore.KeyStoreHelper;
import com.helger.security.keystore.LoadedKeyStore;
import eu.toop.connector.api.TCConfig;
import eu.toop.connector.api.as4.MessageExchangeManager;
import eu.toop.connector.app.CTC;
import eu.toop.connector.app.mp.MPConfig;
import java.io.IOException;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.servlet.ServletException;
import javax.servlet.ServletRegistration;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@WebServlet(value={""})
public class TCRootServlet
extends HttpServlet {
    protected void doGet(@Nonnull HttpServletRequest httpServletRequest, @Nonnull HttpServletResponse httpServletResponse) throws ServletException, IOException {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<html><head><title>TOOP Connector</title><style>").append("* { font-family: sans-serif; } a:link, a:visited, a:hover, a:active { color: #2255ff; } code { font-family:monospace; color:#e83e8c; }").append("</style></head><body>");
        stringBuilder.append("<h1>TOOP Connector</h1>");
        stringBuilder.append("<div>Version: ").append(CTC.getVersionNumber()).append("</div>");
        stringBuilder.append("<div>Build timestamp: ").append(CTC.getBuildTimestamp()).append("</div>");
        stringBuilder.append("<div>Current time: ").append(PDTFactory.getCurrentZonedDateTimeUTC().toString()).append("</div>");
        stringBuilder.append("<div><a href='tc-status'>Check /tc-status</a></div>");
        stringBuilder.append("<h2>Registered Message Exchange implementations</h2>");
        for (Map.Entry entry : CollectionHelper.getSortedByKey((Map)MessageExchangeManager.getAll()).entrySet()) {
            stringBuilder.append("<div>ID <code>").append((String)entry.getKey()).append("</code> mapped to ").append(entry.getValue()).append("</div>");
        }
        stringBuilder.append("<h2>Message Processor Configuration</h2>");
        stringBuilder.append("<div><code>SignatureHelper</code>=").append(MPConfig.getSignatureHelper()).append("</div>");
        stringBuilder.append("<div><code>SMMConceptProvider</code>=").append(MPConfig.getSMMConceptProvider()).append("</div>");
        stringBuilder.append("<div><code>ParticipantIDProvider</code>=").append(MPConfig.getParticipantIDProvider()).append("</div>");
        stringBuilder.append("<div><code>EndpointProvider</code>=").append(MPConfig.getEndpointProvider()).append("</div>");
        stringBuilder.append("<h2>Certificate Configuration</h2>");
        stringBuilder.append("<div>Key store path <code>").append(TCConfig.getKeystorePath()).append("</code> of type <code>").append(TCConfig.getKeystoreType()).append("</code> using alias <code>").append(TCConfig.getKeystoreKeyAlias()).append("</code></div>");
        LoadedKeyStore loadedKeyStore = KeyStoreHelper.loadKeyStore((IKeyStoreType)TCConfig.getKeystoreType(), (String)TCConfig.getKeystorePath(), (String)TCConfig.getKeystorePassword());
        if (loadedKeyStore.isFailure()) {
            stringBuilder.append("<div><strong>Error loading keystore: ").append(loadedKeyStore.getErrorText(TextHelper.EN)).append("</strong></div>");
        } else {
            Map.Entry entry;
            stringBuilder.append("<div>Keystore was loaded successfully</div>");
            entry = KeyStoreHelper.loadPrivateKey((KeyStore)loadedKeyStore.getKeyStore(), (String)TCConfig.getKeystorePath(), (String)TCConfig.getKeystoreKeyAlias(), (char[])TCConfig.getKeystoreKeyPassword().toCharArray());
            if (entry.isFailure()) {
                stringBuilder.append("<div><strong>Error loading key: ").append(entry.getErrorText(TextHelper.EN)).append("</strong></div>");
            } else {
                X509Certificate x509Certificate = (X509Certificate)((KeyStore.PrivateKeyEntry)entry.getKeyEntry()).getCertificate();
                stringBuilder.append("<div>Successfully loaded certificate</div>");
                stringBuilder.append("<div>Subject: <code>").append(x509Certificate.getSubjectX500Principal().getName()).append("</code></div>");
                stringBuilder.append("<div>Issuer: <code>").append(x509Certificate.getIssuerX500Principal().getName()).append("</code></div>");
                stringBuilder.append("<div>Serial number: <code>0x").append(x509Certificate.getSerialNumber().toString(16)).append("</code></div>");
            }
        }
        if (GlobalDebug.isDebugMode()) {
            stringBuilder.append("<h2>servlet information</h2>");
            for (Map.Entry entry : CollectionHelper.getSortedByKey((Map)httpServletRequest.getServletContext().getServletRegistrations()).entrySet()) {
                stringBuilder.append("<div>Servlet <code>").append((String)entry.getKey()).append("</code> mapped to ").append(((ServletRegistration)entry.getValue()).getMappings()).append("</div>");
            }
        }
        stringBuilder.append("</body></html>");
        httpServletResponse.addHeader("Content-Type", CMimeType.TEXT_HTML.getAsString());
        httpServletResponse.getWriter().write(stringBuilder.toString());
        httpServletResponse.getWriter().flush();
    }
}

