/*
 * Decompiled with CFR 0.152.
 */
package eu.toop.connector.app.servlet;

import com.helger.commons.mime.CMimeType;
import com.helger.commons.mime.IMimeType;
import com.helger.commons.mime.MimeType;
import com.helger.json.IJsonObject;
import com.helger.json.JsonObject;
import com.helger.servlet.response.UnifiedResponse;
import com.helger.web.scope.IRequestWebScopeWithoutResponse;
import com.helger.xservlet.handler.simple.IXServletSimpleHandler;
import eu.toop.connector.api.TCConfig;
import eu.toop.connector.app.TCStatusHelper;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class TCStatusXServletHandler
implements IXServletSimpleHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(TCStatusXServletHandler.class);
    private static final Charset CHARSET = StandardCharsets.UTF_8;

    TCStatusXServletHandler() {
    }

    public void handleRequest(@Nonnull IRequestWebScopeWithoutResponse iRequestWebScopeWithoutResponse, @Nonnull UnifiedResponse unifiedResponse) throws Exception {
        IJsonObject iJsonObject;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Status information requested");
        }
        if (TCConfig.isStatusEnabled()) {
            iJsonObject = TCStatusHelper.getDefaultStatusData();
        } else {
            iJsonObject = new JsonObject();
            iJsonObject.add("status.enabled", false);
        }
        unifiedResponse.disableCaching();
        unifiedResponse.setMimeType((IMimeType)new MimeType(CMimeType.APPLICATION_JSON).addParameter("charset", CHARSET.name()));
        unifiedResponse.setContentAndCharset(iJsonObject.getAsJsonString(), CHARSET);
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Return status JSON: " + iJsonObject.getAsJsonString());
        }
    }
}

