/*
 * Decompiled with CFR 0.152.
 */
package eu.toop.connector.app.smm;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.CommonsHashMap;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.collection.impl.ICommonsMap;
import eu.toop.commons.concept.ConceptValue;
import eu.toop.connector.api.smm.IMappedValueList;
import eu.toop.connector.api.smm.ISMMClient;
import eu.toop.connector.api.smm.ISMMConceptProvider;
import eu.toop.connector.api.smm.ISMMUnmappableCallback;
import eu.toop.connector.api.smm.MappedValue;
import eu.toop.connector.api.smm.MappedValueList;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class SMMClient
implements ISMMClient {
    private final ICommonsMap<String, ICommonsList<String>> m_aSrcMap = new CommonsHashMap();

    @Nonnull
    public SMMClient addConceptToBeMapped(@Nonnull @Nonempty String string2, @Nonnull @Nonempty String string3) {
        ValueEnforcer.notEmpty((CharSequence)string2, (String)"Scheme");
        ValueEnforcer.notEmpty((CharSequence)string3, (String)"Value");
        ((ICommonsList)this.m_aSrcMap.computeIfAbsent((Object)string2, string -> new CommonsArrayList())).add((Object)string3);
        return this;
    }

    @Nonnegative
    public int getTotalCountConceptsToBeMapped() {
        int n = 0;
        for (ICommonsList iCommonsList : this.m_aSrcMap.values()) {
            n += iCommonsList.size();
        }
        return n;
    }

    @Nonnull
    @ReturnsMutableCopy
    public IMappedValueList performMapping(@Nonnull String string, @Nonnull @Nonempty String string2, @Nonnull ISMMConceptProvider iSMMConceptProvider, @Nullable ISMMUnmappableCallback iSMMUnmappableCallback) {
        ValueEnforcer.notNull((Object)string, (String)"LogPrefix");
        ValueEnforcer.notEmpty((CharSequence)string2, (String)"DestNamespace");
        ValueEnforcer.notNull((Object)iSMMConceptProvider, (String)"ConceptProvider");
        MappedValueList mappedValueList = new MappedValueList();
        for (Map.Entry entry : this.m_aSrcMap.entrySet()) {
            Object object;
            Object object22;
            String string3 = (String)entry.getKey();
            if (string3.equals(string2)) {
                for (Object object22 : (ICommonsList)entry.getValue()) {
                    object = new ConceptValue(string3, (String)object22);
                    mappedValueList.addMappedValue(new MappedValue(object, object));
                }
                continue;
            }
            Iterator iterator = iSMMConceptProvider.getAllMappedValues(string, string3, string2);
            object22 = ((ICommonsList)entry.getValue()).iterator();
            while (object22.hasNext()) {
                object = (String)object22.next();
                MappedValueList mappedValueList2 = iterator.getAllBySource(arg_0 -> SMMClient.lambda$performMapping$1((String)object, arg_0));
                if (mappedValueList2.isEmpty()) {
                    if (iSMMUnmappableCallback == null) continue;
                    iSMMUnmappableCallback.onUnmappableValue(string, string3, (String)object, string2);
                    continue;
                }
                if (mappedValueList2.size() > 1) {
                    throw new IllegalStateException();
                }
                mappedValueList.addAllMappedValues((IMappedValueList)mappedValueList2);
            }
        }
        return mappedValueList;
    }

    private static /* synthetic */ boolean lambda$performMapping$1(String string, ConceptValue conceptValue) {
        return conceptValue.hasValue(string);
    }
}

