/*
 * Decompiled with CFR 0.152.
 */
package eu.toop.connector.app.smm;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.collection.impl.CommonsHashMap;
import com.helger.commons.collection.impl.ICommonsMap;
import com.helger.commons.io.resource.ClassPathResource;
import com.helger.commons.io.resource.IReadableResource;
import com.helger.xml.microdom.IMicroDocument;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.serialize.MicroReader;
import eu.toop.connector.api.smm.ISMMConceptProvider;
import eu.toop.connector.api.smm.MappedValueList;
import java.util.Map;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SMMConceptProviderFileBased
implements ISMMConceptProvider {
    public static final IReadableResource DEFAULT_RES = new ClassPathResource("semantic-mapping-default.xml");
    private static final Logger LOGGER = LoggerFactory.getLogger(SMMConceptProviderFileBased.class);
    private final ICommonsMap<String, ICommonsMap<String, ICommonsMap<String, String>>> m_aMappings = new CommonsHashMap();

    public SMMConceptProviderFileBased() {
        this(DEFAULT_RES);
    }

    public SMMConceptProviderFileBased(@Nonnull IReadableResource iReadableResource) {
        ValueEnforcer.notNull((Object)iReadableResource, (String)"Res");
        IMicroDocument iMicroDocument = MicroReader.readMicroXML((IReadableResource)iReadableResource);
        if (iMicroDocument == null || iMicroDocument.getDocumentElement() == null) {
            throw new IllegalStateException("Failed to read " + iReadableResource + " as XML");
        }
        int n = 0;
        for (IMicroElement iMicroElement : iMicroDocument.getDocumentElement().getAllChildElements("toop")) {
            String string2 = iMicroElement.getAttributeValue("ns");
            ICommonsMap iCommonsMap = (ICommonsMap)this.m_aMappings.computeIfAbsent((Object)string2, string -> new CommonsHashMap());
            for (IMicroElement iMicroElement2 : iMicroElement.getAllChildElements("external")) {
                string2 = iMicroElement2.getAttributeValue("ns");
                ICommonsMap iCommonsMap2 = (ICommonsMap)iCommonsMap.computeIfAbsent((Object)string2, string -> new CommonsHashMap());
                for (IMicroElement iMicroElement3 : iMicroElement2.getAllChildElements("item")) {
                    String string3 = iMicroElement3.getAttributeValue("toop");
                    String string4 = iMicroElement3.getAttributeValue("external");
                    iCommonsMap2.put((Object)string3, (Object)string4);
                    ++n;
                }
            }
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Read " + n + " semantic mapping items from " + iReadableResource.getPath());
        }
    }

    @Nonnull
    public MappedValueList getAllMappedValues(@Nonnull String string, @Nonnull String string2, @Nonnull String string3) {
        ICommonsMap iCommonsMap;
        boolean bl;
        LOGGER.info(string + "getAllMappedValues (" + string2 + ", " + string3 + ")");
        MappedValueList mappedValueList = new MappedValueList();
        ICommonsMap iCommonsMap2 = (ICommonsMap)this.m_aMappings.get((Object)string2);
        if (iCommonsMap2 != null) {
            bl = true;
        } else {
            iCommonsMap2 = (ICommonsMap)this.m_aMappings.get((Object)string3);
            bl = false;
        }
        if (iCommonsMap2 != null && (iCommonsMap = (ICommonsMap)iCommonsMap2.get((Object)(bl ? string3 : string2))) != null) {
            for (Map.Entry entry : iCommonsMap.entrySet()) {
                if (bl) {
                    mappedValueList.addMappedValue(string2, (String)entry.getKey(), string3, (String)entry.getValue());
                    continue;
                }
                mappedValueList.addMappedValue(string2, (String)entry.getValue(), string3, (String)entry.getKey());
            }
        }
        return mappedValueList;
    }
}

