/*
 * Decompiled with CFR 0.152.
 */
package eu.toop.playground.dc.config.enums;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;

public enum DCConfig {
    INSTANCE;

    private final String CONFIG_FILE = "dcui.conf";
    private final Config config;

    private DCConfig() {
        Config config = ConfigFactory.parseResources((String)"dcui.conf");
        Config config2 = ConfigFactory.parseFile((File)Paths.get("/toop-dir/demo-ui-dc/dcui.conf", new String[0]).toFile());
        Path path = Paths.get("./dcui.conf", new String[0]);
        this.config = ConfigFactory.parseFile((File)path.toFile()).withFallback((ConfigMergeable)config2).withFallback((ConfigMergeable)config).resolve();
    }

    public boolean useMockDSD() {
        return this.config.getBoolean("use-mock-dsd");
    }

    public boolean useDirectSubmit() {
        return this.config.getBoolean("use-direct-submit");
    }

    public boolean isDumpingEnabled() {
        return this.config.getBoolean("dump-messages");
    }

    public String getDumpLocation() {
        return this.config.getString("dump-location");
    }

    public String getKafkaClientTopic() {
        return this.getKafkaClientConfig().getString("topic");
    }

    public boolean isKafkaClientEnabled() {
        return this.getKafkaClientConfig().getBoolean("enabled");
    }

    public String getKafkaClientURL() {
        return this.getKafkaClientConfig().getString("url");
    }

    public String getSubmitRequestURL() {
        return this.useDirectSubmit() ? this.getEloniaDP().getString("submit-request-url") : this.getSimulatorDP().getString("submit-request-url");
    }

    public String getDSDEndpointURL() {
        return this.getSimulatorDP().getString("dsd-url");
    }

    public String getDefaultEloniaDevParticipantIdScheme() {
        return this.getEloniaDP().getString("participant-id-scheme");
    }

    public String getDefaultEloniaDevParticipantIdValue() {
        return this.getEloniaDP().getString("participant-id-value");
    }

    public String getDefaultFreedoniaDCSenderIdScheme() {
        return this.getFreedoniaDC().getString("sender-id-scheme");
    }

    public String getDefaultFreedoniaDCSenderIdValue() {
        return this.getFreedoniaDC().getString("sender-id-value");
    }

    private Config getKafkaClientConfig() {
        return this.config.getConfig("kafka-client");
    }

    private Config getFreedoniaDC() {
        return this.config.getConfig("dc").getConfig("freedonia");
    }

    private Config getEloniaDP() {
        return this.config.getConfig("dp").getConfig("elonia");
    }

    private Config getSimulatorDP() {
        return this.config.getConfig("dp").getConfig("simulator");
    }
}

