/*
 * Decompiled with CFR 0.152.
 */
package eu.toop.playground.dc.servlet;

import eu.toop.edm.EDMErrorResponse;
import eu.toop.edm.EDMResponse;
import eu.toop.edm.IEDMTopLevelObject;
import eu.toop.edm.xml.EDMPayloadDeterminator;
import eu.toop.playground.dc.ui.service.BroadcasterService;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebServlet(name="EDMResponseDirectServlet", urlPatterns={"/from-dp"})
public class EDMResponseDirectServlet
extends HttpServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(EDMResponseDirectServlet.class);

    protected void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream((InputStream)httpServletRequest.getInputStream());
        IEDMTopLevelObject iEDMTopLevelObject = EDMPayloadDeterminator.parseAndFind((InputStream)bufferedInputStream);
        if (iEDMTopLevelObject != null && iEDMTopLevelObject instanceof EDMResponse) {
            EDMResponse eDMResponse = (EDMResponse)iEDMTopLevelObject;
            LOGGER.debug("EDMResponse {} successfully retrieved.", (Object)eDMResponse.getRequestID());
            BroadcasterService.INSTANCE.broadcast(eDMResponse);
            httpServletResponse.setStatus(200);
        } else if (iEDMTopLevelObject != null && iEDMTopLevelObject instanceof EDMErrorResponse) {
            EDMErrorResponse eDMErrorResponse = (EDMErrorResponse)iEDMTopLevelObject;
            LOGGER.debug("EDMErrorResponse {} successfully retrieved.", (Object)eDMErrorResponse.getRequestID());
            BroadcasterService.INSTANCE.broadcast(eDMErrorResponse);
            httpServletResponse.setStatus(200);
        } else {
            LOGGER.debug("Unable to parse input, returning BAD REQUEST:400");
            httpServletResponse.setStatus(400);
        }
    }
}

