/*
 * Decompiled with CFR 0.152.
 */
package eu.toop.playground.dc.servlet;

import com.helger.commons.error.level.EErrorLevel;
import com.helger.commons.error.level.IErrorLevel;
import com.helger.commons.io.stream.StreamHelper;
import eu.toop.connector.api.rest.TCIncomingMessage;
import eu.toop.connector.api.rest.TCIncomingMetadata;
import eu.toop.connector.api.rest.TCPayload;
import eu.toop.connector.api.rest.TCRestJAXB;
import eu.toop.edm.EDMErrorResponse;
import eu.toop.edm.EDMResponse;
import eu.toop.edm.IEDMTopLevelObject;
import eu.toop.edm.xml.EDMPayloadDeterminator;
import eu.toop.kafkaclient.ToopKafkaClient;
import eu.toop.playground.dc.servlet.EDMResponseServlet;
import eu.toop.playground.dc.ui.model.Attachment;
import eu.toop.playground.dc.ui.model.EDMResponseWithAttachment;
import eu.toop.playground.dc.ui.model.enums.EMimeType;
import eu.toop.playground.dc.ui.model.enums.EResponseType;
import eu.toop.playground.dc.ui.service.BroadcasterService;
import eu.toop.playground.dc.util.MessageDumper;
import eu.toop.playground.dc.util.MessageType;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebServlet(name="EDMResponseSimServlet", urlPatterns={"/to-dc"})
public class EDMResponseServlet
extends HttpServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(EDMResponseServlet.class);

    protected void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        byte[] byArray = StreamHelper.getAllBytes((InputStream)httpServletRequest.getInputStream());
        MessageDumper.dumpMessage((byte[])byArray, (MessageType)MessageType.INCOMING);
        LOGGER.info("Freedonia DC Servlet received a TC incoming message.");
        String string = new String(byArray, StandardCharsets.UTF_8);
        LOGGER.debug("Freedonia DC is printing the TC incoming message:\n{}", (Object)string);
        TCIncomingMessage tCIncomingMessage = (TCIncomingMessage)TCRestJAXB.incomingMessage().read(string);
        if (tCIncomingMessage == null) {
            ToopKafkaClient.send((IErrorLevel)EErrorLevel.ERROR, (String)"Freedonia DC is unable to read TC incoming message...");
            LOGGER.debug("Freedonia DC is unable to read TC incoming message...");
        }
        ToopKafkaClient.send((IErrorLevel)EErrorLevel.INFO, (String)"Freedonia DC Servlet read the TC incoming message successfully.");
        LOGGER.debug("Freedonia DC Servlet read the TC incoming message successfully.");
        LOGGER.debug("Freedonia DC Servlet is trying to read the TC incoming message's metadata.");
        ToopKafkaClient.send((IErrorLevel)EErrorLevel.INFO, (String)"Freedonia DC Servlet is trying to read the TC incoming message's metadata.");
        TCIncomingMetadata tCIncomingMetadata = tCIncomingMessage.getMetadata();
        if (tCIncomingMetadata == null) {
            ToopKafkaClient.send((IErrorLevel)EErrorLevel.ERROR, (String)"Freedonia DC Servlet is unable to read TC incoming message's metadata...");
            LOGGER.debug("Freedonia DC Servlet is unable to read TC incoming message's metadata...");
        }
        ToopKafkaClient.send((IErrorLevel)EErrorLevel.INFO, (String)"Freedonia DC Servlet read the TC incoming message's metadata successfully.");
        LOGGER.debug("Freedonia DC Servlet read the TC incoming message's metadata successfully.");
        LOGGER.debug("Number of payloads: {}", (Object)tCIncomingMessage.getPayloadCount());
        switch (1.$SwitchMap$eu$toop$playground$dc$ui$model$enums$EResponseType[this.extractResponseType(tCIncomingMessage).ordinal()]) {
            case 1: {
                this.parseResponse(tCIncomingMessage);
                break;
            }
            case 2: {
                this.parseResponseWithAttachments(tCIncomingMessage);
            }
        }
    }

    private void parseResponse(TCIncomingMessage tCIncomingMessage) {
        if (tCIncomingMessage.getPayloadCount() == 1 && tCIncomingMessage.getPayloadAtIndex(0).getMimeType().equals(EMimeType.RESPONSE_TYPE.getValue())) {
            TCPayload tCPayload = tCIncomingMessage.getPayloadAtIndex(0);
            LOGGER.debug("Freedonia DC Servlet read a payload with Content ID: {}", (Object)tCPayload.getContentID());
            LOGGER.debug("Freedonia DC Servlet read a payload  Mime Type: {}", (Object)tCPayload.getMimeType());
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(tCPayload.getValue());
            IEDMTopLevelObject iEDMTopLevelObject = EDMPayloadDeterminator.parseAndFind((InputStream)byteArrayInputStream);
            if (iEDMTopLevelObject != null && iEDMTopLevelObject instanceof EDMResponse) {
                EDMResponse eDMResponse = (EDMResponse)iEDMTopLevelObject;
                ToopKafkaClient.send((IErrorLevel)EErrorLevel.INFO, (String)"Freedonia DC Servlet read an EDMResponse payload.");
                this.broadcast(eDMResponse);
                LOGGER.debug("Freedonia DC Servlet read an EDMResponse payload:\n {}", (Object)eDMResponse.getWriter().getAsString());
            } else if (iEDMTopLevelObject != null && iEDMTopLevelObject instanceof EDMErrorResponse) {
                EDMErrorResponse eDMErrorResponse = (EDMErrorResponse)iEDMTopLevelObject;
                ToopKafkaClient.send((IErrorLevel)EErrorLevel.INFO, (String)"Freedonia DC Servlet read an EDMErrorResponse payload.");
                this.broadcast(eDMErrorResponse);
                LOGGER.debug("Freedonia DC Servlet read an EDMErrorResponse payload:\n {}", (Object)eDMErrorResponse.getWriter().getAsString());
            } else {
                ToopKafkaClient.send((IErrorLevel)EErrorLevel.ERROR, (String)"Freedonia DC is unable to parse payload value...");
                LOGGER.error("Freedonia DC is unable to parse payload value...");
            }
        }
    }

    private void parseResponseWithAttachments(TCIncomingMessage tCIncomingMessage) {
        EDMResponse eDMResponse = null;
        ArrayList<Attachment> arrayList = new ArrayList<Attachment>();
        for (TCPayload tCPayload : tCIncomingMessage.getPayload()) {
            LOGGER.debug("Freedonia DC Servlet read a payload with Content ID: {}", (Object)tCPayload.getContentID());
            LOGGER.debug("Freedonia DC Servlet read a payload  Mime Type: {}", (Object)tCPayload.getMimeType());
            ToopKafkaClient.send((IErrorLevel)EErrorLevel.INFO, (String)("Freedonia DC Servlet read a payload witn Conent ID: " + tCPayload.getContentID()));
            ToopKafkaClient.send((IErrorLevel)EErrorLevel.INFO, (String)("Freedonia DC Servlet read a payload  Mime Type: " + tCPayload.getMimeType()));
            if (tCPayload.getMimeType().equals(EMimeType.RESPONSE_TYPE.getValue())) {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(tCPayload.getValue());
                IEDMTopLevelObject iEDMTopLevelObject = EDMPayloadDeterminator.parseAndFind((InputStream)byteArrayInputStream);
                if (iEDMTopLevelObject != null && iEDMTopLevelObject instanceof EDMResponse) {
                    eDMResponse = (EDMResponse)iEDMTopLevelObject;
                    ToopKafkaClient.send((IErrorLevel)EErrorLevel.INFO, (String)"Freedonia DC Servlet read an EDMResponse payload.");
                    LOGGER.debug("Freedonia DC Servlet read an EDMResponse payload:\n {}", (Object)eDMResponse.getWriter().getAsString());
                    continue;
                }
                ToopKafkaClient.send((IErrorLevel)EErrorLevel.ERROR, (String)"Freedonia DC is unable to parse payload value...");
                LOGGER.error("Freedonia DC is unable to parse payload value...");
                continue;
            }
            arrayList.add(new Attachment(tCPayload.getValue(), tCPayload.getContentID(), tCPayload.getMimeType()));
        }
        if (eDMResponse != null && !arrayList.isEmpty()) {
            EDMResponseWithAttachment eDMResponseWithAttachment = new EDMResponseWithAttachment(eDMResponse);
            eDMResponseWithAttachment.getAttachmentList().addAll(arrayList);
            this.broadcast(eDMResponseWithAttachment);
        }
    }

    private EResponseType extractResponseType(TCIncomingMessage tCIncomingMessage) {
        return tCIncomingMessage.getPayloadCount() > 1 ? EResponseType.EDM_RESPONSE_WITH_ATTACHMENT : EResponseType.EDM_RESPONSE_OR_ERROR_RESPONSE;
    }

    private void broadcast(EDMResponseWithAttachment eDMResponseWithAttachment) {
        BroadcasterService.INSTANCE.broadcast(eDMResponseWithAttachment);
    }

    private void broadcast(EDMErrorResponse eDMErrorResponse) {
        BroadcasterService.INSTANCE.broadcast(eDMErrorResponse);
    }

    private void broadcast(EDMResponse eDMResponse) {
        BroadcasterService.INSTANCE.broadcast(eDMResponse);
    }
}

