/*
 * Decompiled with CFR 0.152.
 */
package eu.toop.playground.dc.ui.component;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.Composite;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.button.ButtonVariant;
import com.vaadin.flow.component.icon.Icon;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.server.InputStreamFactory;
import com.vaadin.flow.server.StreamResource;
import eu.toop.edm.EDMErrorResponse;
import eu.toop.edm.EDMResponse;
import eu.toop.playground.dc.ui.model.EDMResponseWithAttachment;
import eu.toop.playground.dc.ui.presenter.MainPresenter;
import java.io.ByteArrayInputStream;
import java.io.Serializable;
import java.util.Objects;
import org.vaadin.olli.FileDownloadWrapper;

public class ActionButtonComponent
extends Composite<HorizontalLayout> {
    Button showResponseBtn;
    Button showErrorResponseBtn;
    Button downloadResponse;
    Button downloadResponseWithAttachment;
    Button downloadErrorResponse;
    Button showResponseAttachBtn;
    MainPresenter presenter;
    EDMResponse response;
    EDMResponseWithAttachment edmResponseWithAttachment;
    EDMErrorResponse errorResponse;

    public ActionButtonComponent(MainPresenter mainPresenter) {
        this.presenter = mainPresenter;
        this.showResponseBtn = new Button("show response");
        this.showResponseAttachBtn = new Button("show response");
        this.showErrorResponseBtn = new Button("show error");
        this.downloadResponse = new Button();
        this.downloadErrorResponse = new Button();
        this.downloadResponseWithAttachment = new Button();
        this.showResponseBtn.addThemeVariants(new ButtonVariant[]{ButtonVariant.LUMO_PRIMARY});
        this.showResponseAttachBtn.addThemeVariants(new ButtonVariant[]{ButtonVariant.LUMO_PRIMARY});
        this.showErrorResponseBtn.addThemeVariants(new ButtonVariant[]{ButtonVariant.LUMO_PRIMARY, ButtonVariant.LUMO_ERROR});
        this.downloadResponse.addThemeVariants(new ButtonVariant[]{ButtonVariant.LUMO_PRIMARY});
        this.downloadResponseWithAttachment.addThemeVariants(new ButtonVariant[]{ButtonVariant.LUMO_PRIMARY});
        this.downloadErrorResponse.addThemeVariants(new ButtonVariant[]{ButtonVariant.LUMO_PRIMARY, ButtonVariant.LUMO_ERROR});
        this.downloadResponse.setIcon((Component)new Icon(VaadinIcon.DOWNLOAD_ALT));
        this.downloadResponseWithAttachment.setIcon((Component)new Icon(VaadinIcon.DOWNLOAD_ALT));
        this.downloadErrorResponse.setIcon((Component)new Icon(VaadinIcon.DOWNLOAD_ALT));
        this.enableBtns(Boolean.valueOf(false));
        this.showResponseBtn.addClickListener((ComponentEventListener & Serializable)clickEvent -> mainPresenter.showResponse(this.response));
        this.showResponseAttachBtn.addClickListener((ComponentEventListener & Serializable)clickEvent -> mainPresenter.showResponse(this.edmResponseWithAttachment));
        this.showErrorResponseBtn.addClickListener((ComponentEventListener & Serializable)clickEvent -> mainPresenter.showErrorResponse(this.errorResponse));
        FileDownloadWrapper fileDownloadWrapper = new FileDownloadWrapper(new StreamResource("TOOPResponse.xml", (InputStreamFactory & Serializable)() -> new ByteArrayInputStream(Objects.requireNonNull(this.response.getWriter().getAsBytes()))));
        FileDownloadWrapper fileDownloadWrapper2 = new FileDownloadWrapper(new StreamResource("TOOPResponseWithAttachment.xml", (InputStreamFactory & Serializable)() -> new ByteArrayInputStream(Objects.requireNonNull(this.edmResponseWithAttachment.getEdmResponse().getWriter().getAsBytes()))));
        FileDownloadWrapper fileDownloadWrapper3 = new FileDownloadWrapper(new StreamResource("TOOPErrorResponse.xml", (InputStreamFactory & Serializable)() -> new ByteArrayInputStream(Objects.requireNonNull(this.errorResponse.getWriter().getAsBytes()))));
        fileDownloadWrapper.wrapComponent((Component)this.downloadResponse);
        fileDownloadWrapper3.wrapComponent((Component)this.downloadErrorResponse);
        fileDownloadWrapper2.wrapComponent((Component)this.downloadResponseWithAttachment);
        ((HorizontalLayout)this.getContent()).add(new Component[]{this.showResponseBtn, fileDownloadWrapper});
        ((HorizontalLayout)this.getContent()).add(new Component[]{this.showResponseAttachBtn, fileDownloadWrapper2});
        ((HorizontalLayout)this.getContent()).add(new Component[]{this.showErrorResponseBtn, fileDownloadWrapper3});
    }

    public void enableBtns(Boolean bl) {
        this.showResponseBtn.setEnabled(bl.booleanValue());
        this.downloadResponse.setEnabled(bl.booleanValue());
    }

    public void enableAttachBtns(Boolean bl) {
        this.showResponseAttachBtn.setEnabled(bl.booleanValue());
        this.downloadResponseWithAttachment.setEnabled(bl.booleanValue());
    }

    public void enableErrorBtns(Boolean bl) {
        this.showErrorResponseBtn.setEnabled(bl.booleanValue());
        this.downloadErrorResponse.setEnabled(bl.booleanValue());
    }

    public void showBtns(Boolean bl) {
        this.showResponseBtn.setVisible(bl.booleanValue());
        this.downloadResponse.setVisible(bl.booleanValue());
    }

    public void showAttachBtns(Boolean bl) {
        this.showResponseAttachBtn.setVisible(bl.booleanValue());
        this.downloadResponseWithAttachment.setVisible(bl.booleanValue());
    }

    public void showErrorBtns(Boolean bl) {
        this.showErrorResponseBtn.setVisible(bl.booleanValue());
        this.downloadErrorResponse.setVisible(bl.booleanValue());
    }

    public void setResponse(EDMResponse eDMResponse) {
        this.response = eDMResponse;
    }

    public void setResponseWithAttachment(EDMResponseWithAttachment eDMResponseWithAttachment) {
        this.edmResponseWithAttachment = eDMResponseWithAttachment;
    }

    public void setErrorResponse(EDMErrorResponse eDMErrorResponse) {
        this.errorResponse = eDMErrorResponse;
    }
}

