/*
 * Decompiled with CFR 0.152.
 */
package eu.toop.playground.dc.ui.component;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.Composite;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.button.ButtonVariant;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.html.H3;
import com.vaadin.flow.component.icon.Icon;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.notification.Notification;
import com.vaadin.flow.component.notification.NotificationVariant;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.treegrid.TreeGrid;
import com.vaadin.flow.data.selection.MultiSelect;
import com.vaadin.flow.data.selection.MultiSelectionListener;
import com.vaadin.flow.function.ValueProvider;
import com.vaadin.flow.server.InputStreamFactory;
import com.vaadin.flow.server.StreamResource;
import eu.toop.edm.EDMRequest;
import eu.toop.edm.model.ConceptPojo;
import eu.toop.playground.dc.ui.component.TopLevelSlotComponent;
import eu.toop.playground.dc.ui.model.ConceptQueryFVBean;
import eu.toop.playground.dc.ui.model.dto.DSDDatasetResponseDto;
import eu.toop.playground.dc.ui.presenter.MainPresenter;
import eu.toop.playground.dc.ui.util.Utilities;
import java.io.ByteArrayInputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vaadin.olli.FileDownloadWrapper;

public class ConceptQueryComponent
extends Composite<VerticalLayout> {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)ConceptQueryComponent.class.getName());
    MainPresenter presenter;
    Div conceptSelectionBox = new Div();
    Div messageCreationBox = new Div();
    TopLevelSlotComponent topLevelSlotComponent;
    H3 conceptSelectionHeader = new H3("Concept Selection: ");
    H3 createConceptQueryHeader = new H3("Create ConceptQuery:  ");
    Button createRequestBtn;
    MultiSelect<Grid<DSDDatasetResponseDto>, DSDDatasetResponseDto> selected;
    Div distributionBox;
    H3 distributionSelectionHeader = new H3("Data Provider and Dataset Selection: ");
    Grid<DSDDatasetResponseDto> datasetGrid;
    Button downloadBtn = new Button();
    FileDownloadWrapper buttonWrapper;
    ConceptQueryFVBean conceptQueryFVBean;

    public ConceptQueryComponent(MainPresenter mainPresenter, ConceptQueryFVBean conceptQueryFVBean) {
        this.presenter = mainPresenter;
        this.conceptQueryFVBean = conceptQueryFVBean;
        this.topLevelSlotComponent = new TopLevelSlotComponent(mainPresenter, conceptQueryFVBean, this);
        this.messageCreationBox.setClassName("messageCreationBox");
        mainPresenter.populateConceptSelectionGrid(this);
        this.createRequestBtn = new Button("Create Request");
        this.createRequestBtn.addThemeVariants(new ButtonVariant[]{ButtonVariant.LUMO_PRIMARY});
        this.createRequestBtn.addClickListener((ComponentEventListener & Serializable)clickEvent -> {
            for (DSDDatasetResponseDto dSDDatasetResponseDto : this.selected.getSelectedItems()) {
                mainPresenter.validateDS();
                if (!mainPresenter.validationCheckPass()) {
                    mainPresenter.createConceptRequestMessage(this, dSDDatasetResponseDto);
                    continue;
                }
                Notification notification = new Notification("Missing Required Fields. Please fill in all the required fields", 9000, Notification.Position.TOP_START);
                notification.addThemeVariants(new NotificationVariant[]{NotificationVariant.LUMO_PRIMARY, NotificationVariant.LUMO_ERROR});
                notification.open();
            }
        });
        this.messageCreationBox.add(new Component[]{this.createConceptQueryHeader, this.createRequestBtn});
        this.downloadBtn.addThemeVariants(new ButtonVariant[]{ButtonVariant.LUMO_PRIMARY});
        this.downloadBtn.setIcon((Component)new Icon(VaadinIcon.DOWNLOAD_ALT));
        ((VerticalLayout)this.getContent()).add(new Component[]{this.topLevelSlotComponent});
    }

    public void renderConceptDatasetList(List<DSDDatasetResponseDto> list) {
        if (Utilities.datasetGridExists((Grid)this.datasetGrid)) {
            this.distributionBox.remove(new Component[]{this.datasetGrid});
            this.distributionBox.remove(new Component[]{this.conceptSelectionBox});
        }
        List list2 = list.stream().filter(dSDDatasetResponseDto -> dSDDatasetResponseDto.getAccessServiceConforms().contains("2.1")).collect(Collectors.toList());
        this.distributionBox = new Div();
        this.distributionBox.setClassName("distributionSelectionBox");
        LOGGER.debug("ConceptDataset: " + list2.stream().collect(Collectors.toList()));
        this.datasetGrid = new Grid(DSDDatasetResponseDto.class);
        this.datasetGrid.setItems(list2);
        this.datasetGrid.removeAllColumns();
        this.datasetGrid.setSelectionMode(Grid.SelectionMode.MULTI);
        this.datasetGrid.addColumn(DSDDatasetResponseDto::getDatasetId).setHeader("DatasetIdentifier").setResizable(true);
        this.datasetGrid.addColumn((ValueProvider & Serializable)dSDDatasetResponseDto -> ((DSDDatasetResponseDto)list2.get(0)).getParticipantId().getValue().toString()).setHeader("ParticipantID").setResizable(true);
        this.datasetGrid.addColumn((ValueProvider & Serializable)dSDDatasetResponseDto -> ((DSDDatasetResponseDto)list2.get(0)).getParticipantId().getScheme()).setHeader("Participant Scheme ID").setResizable(true);
        this.datasetGrid.addColumn((ValueProvider & Serializable)dSDDatasetResponseDto -> ((DSDDatasetResponseDto)list2.get(0)).getDoctypeId().getValue()).setHeader("Document Type ID").setResizable(true);
        this.datasetGrid.addColumn((ValueProvider & Serializable)dSDDatasetResponseDto -> ((DSDDatasetResponseDto)list2.get(0)).getDoctypeId().getScheme()).setHeader("Document Scheme ID").setResizable(true);
        this.datasetGrid.addColumn(DSDDatasetResponseDto::getDistributionFormat).setHeader("Format").setResizable(true);
        this.datasetGrid.addColumn(DSDDatasetResponseDto::getAccessServiceConforms).setHeader("Conforms to").setResizable(true);
        this.selected = this.datasetGrid.asMultiSelect();
        this.selected.addSelectionListener((MultiSelectionListener & Serializable)multiSelectionEvent -> {
            LOGGER.debug(Arrays.toString(this.selected.getSelectedItems().stream().map(dSDDatasetResponseDto -> dSDDatasetResponseDto.getParticipantId().getValue()).collect(Collectors.toList()).toArray()));
            if (this.selected.getSelectedItems().size() == 1) {
                this.distributionBox.add(new Component[]{this.conceptSelectionBox});
            } else if (this.selected.getSelectedItems().size() == 0) {
                this.distributionBox.remove(new Component[]{this.conceptSelectionBox});
            }
        });
        this.distributionBox.add(new Component[]{this.datasetGrid});
        ((VerticalLayout)this.getContent()).add(new Component[]{this.distributionSelectionHeader, this.distributionBox});
    }

    public void renderConceptSelectionGrid(List<ConceptPojo> list) {
        TreeGrid treeGrid = new TreeGrid(ConceptPojo.class);
        treeGrid.setItems(list, ConceptPojo::getAllChildren);
        treeGrid.removeAllColumns();
        treeGrid.setSelectionMode(Grid.SelectionMode.MULTI);
        treeGrid.addHierarchyColumn(ConceptPojo::getName).setHeader("Concept QName").setResizable(true);
        MultiSelect multiSelect = treeGrid.asMultiSelect();
        multiSelect.addSelectionListener((MultiSelectionListener & Serializable)multiSelectionEvent -> {
            if (multiSelect.getSelectedItems().size() >= 1) {
                this.conceptSelectionBox.add(new Component[]{this.messageCreationBox});
            } else if (multiSelect.getSelectedItems().size() == 0) {
                this.conceptSelectionBox.remove(new Component[]{this.messageCreationBox});
            }
        });
        multiSelect.addValueChangeListener((HasValue.ValueChangeListener & Serializable)componentValueChangeEvent -> {
            List list = multiSelect.getSelectedItems().stream().collect(Collectors.toList());
            if (multiSelect.getSelectedItems().size() == 1) {
                if (treeGrid.getTreeData().getParent(list.get(0)) != null) {
                    treeGrid.select(treeGrid.getTreeData().getParent(list.get(0)));
                } else if (treeGrid.getTreeData().getChildren(list.get(0)) != null) {
                    multiSelect.deselectAll();
                }
            }
            this.presenter.notifyConceptSelection(multiSelect.getSelectedItems());
        });
        this.conceptSelectionBox.add(new Component[]{this.conceptSelectionHeader, treeGrid});
    }

    public void downloadXML(EDMRequest eDMRequest) {
        FileDownloadWrapper fileDownloadWrapper = new FileDownloadWrapper(new StreamResource("TOOPRequest.xml", (InputStreamFactory & Serializable)() -> new ByteArrayInputStream(Objects.requireNonNull(eDMRequest.getWriter().getAsBytes()))));
        fileDownloadWrapper.wrapComponent((Component)this.downloadBtn);
        Notification notification = new Notification("Created TOOPRequest Document", 3000, Notification.Position.TOP_START);
        notification.addThemeVariants(new NotificationVariant[]{NotificationVariant.LUMO_SUCCESS});
        notification.open();
        this.messageCreationBox.add(new Component[]{fileDownloadWrapper});
    }

    public void resetConceptBean(ConceptQueryFVBean conceptQueryFVBean) {
        this.conceptQueryFVBean = conceptQueryFVBean;
        this.topLevelSlotComponent.resetConceptBean(conceptQueryFVBean);
    }
}

