/*
 * Decompiled with CFR 0.152.
 */
package eu.toop.playground.dc.ui.component;

import com.helger.commons.mime.MimeTypeParser;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.Composite;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.html.Anchor;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.html.H2;
import com.vaadin.flow.component.icon.Icon;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.treegrid.TreeGrid;
import com.vaadin.flow.function.ValueProvider;
import com.vaadin.flow.server.AbstractStreamResource;
import com.vaadin.flow.server.InputStreamFactory;
import com.vaadin.flow.server.StreamResource;
import eu.toop.edm.EDMRequest;
import eu.toop.edm.model.DatasetPojo;
import eu.toop.edm.response.IEDMResponsePayloadDocument;
import eu.toop.edm.response.IEDMResponsePayloadDocumentReference;
import eu.toop.playground.dc.ui.component.RequestByIDButtonComponent;
import eu.toop.playground.dc.ui.model.Attachment;
import eu.toop.playground.dc.ui.model.DocumentResponseFVBean;
import eu.toop.playground.dc.ui.presenter.MainPresenter;
import java.io.ByteArrayInputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Optional;

public class DocumentResponseComponent
extends Composite<VerticalLayout> {
    H2 documentHead = new H2("Document Metadata: ");
    Div documentBox;
    private final DocumentResponseFVBean documentResponseFVBean;

    public DocumentResponseComponent(DocumentResponseFVBean documentResponseFVBean, MainPresenter mainPresenter) {
        this.documentResponseFVBean = documentResponseFVBean;
        this.documentBox = new Div();
        this.documentBox.setClassName("documentBox");
        TreeGrid treeGrid = new TreeGrid(DatasetPojo.class);
        treeGrid.setItems((Collection)documentResponseFVBean.getDatasetList());
        treeGrid.removeAllColumns();
        if (documentResponseFVBean.getResponse().getAllPayloadProviders().get(0) instanceof IEDMResponsePayloadDocumentReference) {
            ((Grid.Column)treeGrid.addColumn((ValueProvider & Serializable)datasetPojo -> (String)datasetPojo.getAllIDs().get(0)).setResizable(true)).setHeader("Document Number");
        } else if (documentResponseFVBean.getResponse().getAllPayloadProviders().get(0) instanceof IEDMResponsePayloadDocument) {
            treeGrid.addColumn((ValueProvider & Serializable)datasetPojo -> (String)datasetPojo.getAllIDs().get(0)).setHeader("Document Number").setResizable(true);
        }
        treeGrid.addColumn(DatasetPojo::getAllDescriptions).setHeader("Description").setResizable(true);
        treeGrid.addColumn(DatasetPojo::getAllTitles).setHeader("Title").setResizable(true);
        treeGrid.addColumn((ValueProvider & Serializable)datasetPojo -> datasetPojo.getDistribution() != null ? datasetPojo.getDistribution().getDocumentType() : null).setHeader("Document Type").setResizable(true);
        treeGrid.addColumn(DatasetPojo::getLanguage).setHeader("Language").setResizable(true);
        treeGrid.addColumn(DatasetPojo::getIssuedDT).setHeader("Release Date").setResizable(true);
        treeGrid.addColumn((ValueProvider & Serializable)datasetPojo -> datasetPojo.getCreator() != null ? datasetPojo.getCreator().getName() : null).setHeader("Creator Name").setResizable(true);
        treeGrid.addColumn((ValueProvider & Serializable)datasetPojo -> datasetPojo.getCreator() != null ? datasetPojo.getCreator().getID() : null).setHeader("Creator ID").setResizable(true);
        if (documentResponseFVBean.getResponse().getAllPayloadProviders().get(0) instanceof IEDMResponsePayloadDocumentReference && documentResponseFVBean.getResponseWithAttachment() == null) {
            treeGrid.addComponentColumn((ValueProvider & Serializable)datasetPojo -> new RequestByIDButtonComponent(mainPresenter, (String)datasetPojo.getAllIDs().get(0), this)).setHeader("Fetch Document").setResizable(true);
        }
        if (documentResponseFVBean.getResponseWithAttachment() != null && documentResponseFVBean.getResponseWithAttachment().getEdmResponse().getAllPayloadProviders().get(0) instanceof IEDMResponsePayloadDocument) {
            treeGrid.addComponentColumn((ValueProvider & Serializable)datasetPojo -> {
                Optional<Attachment> optional = documentResponseFVBean.getResponseWithAttachment().getAttachmentList().stream().filter(attachment -> ((String)datasetPojo.getAllIDs().get(0)).equals(attachment.getContentID())).findFirst();
                if (optional.isPresent()) {
                    Attachment attachment2 = optional.get();
                    Icon icon = new Icon(VaadinIcon.DOWNLOAD);
                    icon.setColor("097bd3");
                    icon.setSize("30");
                    String string = MimeTypeParser.parseMimeType((String)attachment2.getMimeType()).getContentSubType();
                    Anchor anchor = new Anchor((AbstractStreamResource)new StreamResource("attachment." + string, (InputStreamFactory & Serializable)() -> new ByteArrayInputStream(attachment2.getAsByteArray())), "");
                    anchor.getElement().setAttribute("download", true);
                    anchor.setHref((AbstractStreamResource)new StreamResource("attachment." + string, (InputStreamFactory & Serializable)() -> new ByteArrayInputStream(attachment2.getAsByteArray())));
                    anchor.add(new Component[]{icon});
                    return anchor;
                }
                Anchor anchor = new Anchor();
                Icon icon = new Icon(VaadinIcon.CLOSE);
                icon.setSize("30");
                anchor.add(new Component[]{icon});
                anchor.setEnabled(false);
                return anchor;
            }).setHeader("Download").setResizable(true);
        }
        this.documentBox.add(new Component[]{treeGrid});
        ((VerticalLayout)this.getContent()).setPadding(false);
        ((VerticalLayout)this.getContent()).add(new Component[]{this.documentHead, this.documentBox});
    }

    public DocumentResponseFVBean getDocumentResponseFVBean() {
        return this.documentResponseFVBean;
    }

    public void downloadXML(EDMRequest eDMRequest) {
    }
}

