/*
 * Decompiled with CFR 0.152.
 */
package eu.toop.playground.dc.ui.component;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.Composite;
import com.vaadin.flow.component.combobox.ComboBox;
import com.vaadin.flow.component.formlayout.FormLayout;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.html.H5;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.data.binder.BeanValidationBinder;
import com.vaadin.flow.data.binder.BinderValidationStatus;
import com.vaadin.flow.data.binder.PropertyId;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.dom.ElementFactory;
import eu.toop.edm.model.EToopIdentifierType;
import eu.toop.playground.dc.ui.component.AddressComponent;
import eu.toop.playground.dc.ui.model.AddressBean;
import eu.toop.playground.dc.ui.model.LegalPersonFVBean;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LegalPersonComponent
extends Composite<FormLayout> {
    private static final Logger LOGGER = LoggerFactory.getLogger(LegalPersonComponent.class);
    private LegalPersonFVBean legalPersonFVBean;
    @PropertyId(value="legalEntityLegalID")
    TextField legalEntityLegalID = new TextField("Legal Entity Legal ID: ");
    @PropertyId(value="legalEntityLegalIDScheme")
    ComboBox<String> legalEntityLegalIDScheme = new ComboBox();
    @PropertyId(value="legalEntityID")
    TextField legalEntityID = new TextField("Legal Entity ID: ");
    @PropertyId(value="legalEntityIDScheme")
    ComboBox<String> legalEntityIDScheme = new ComboBox();
    @PropertyId(value="legalEntityName")
    TextField legalEntityName = new TextField("Company Name: ");
    AddressComponent address;
    H5 legalInformationHeader = new H5("Legal Person Information: ");
    Div addressContainer;
    BeanValidationBinder<LegalPersonFVBean> binderLP;
    BinderValidationStatus<LegalPersonFVBean> status;

    public LegalPersonComponent(LegalPersonFVBean legalPersonFVBean) {
        this.legalPersonFVBean = legalPersonFVBean;
        this.binderLP = new BeanValidationBinder(LegalPersonFVBean.class, true);
        this.binderLP.setBean((Object)legalPersonFVBean);
        this.binderLP.bindInstanceFields((Object)this);
        if (legalPersonFVBean.getAddress() == null) {
            legalPersonFVBean.setAddress(new AddressBean());
        }
        this.address = new AddressComponent(legalPersonFVBean.getAddress());
        this.legalEntityLegalIDScheme.setItems((Collection)Arrays.stream(EToopIdentifierType.values()).map(EToopIdentifierType::getID).collect(Collectors.toList()));
        this.legalEntityLegalIDScheme.setLabel("Legal Entity Legal Scheme ID: ");
        this.legalEntityLegalIDScheme.setValue((Object)EToopIdentifierType.VATREGISTRATION.getID());
        this.legalEntityIDScheme.setItems((Collection)Arrays.stream(EToopIdentifierType.values()).map(EToopIdentifierType::getID).collect(Collectors.toList()));
        this.legalEntityIDScheme.setLabel("Legal Entity Scheme ID: ");
        this.legalEntityIDScheme.setValue((Object)EToopIdentifierType.EIDAS.getID());
        H5 h5 = new H5("Legal Person Address:");
        this.addressContainer = new Div(new Component[]{h5, this.address});
        this.addressContainer.setClassName("address");
        ((FormLayout)this.getContent()).add(new Component[]{this.legalInformationHeader});
        ((FormLayout)this.getContent()).getElement().appendChild(new Element[]{ElementFactory.createBr()});
        ((FormLayout)this.getContent()).add(new Component[]{this.legalEntityLegalID, this.legalEntityLegalIDScheme, this.legalEntityID, this.legalEntityIDScheme, this.legalEntityName});
        ((FormLayout)this.getContent()).getElement().appendChild(new Element[]{ElementFactory.createBr()});
        ((FormLayout)this.getContent()).add(new Component[]{this.addressContainer});
    }

    public boolean validate() {
        this.status = this.binderLP.validate();
        return this.status.hasErrors();
    }

    public void setBean(LegalPersonFVBean legalPersonFVBean) {
        this.legalPersonFVBean = legalPersonFVBean;
        this.binderLP.setBean((Object)legalPersonFVBean);
        this.binderLP.bindInstanceFields((Object)this);
    }
}

