/*
 * Decompiled with CFR 0.152.
 */
package eu.toop.playground.dc.ui.component;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.Composite;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.formlayout.FormLayout;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.radiobutton.RadioButtonGroup;
import com.vaadin.flow.component.radiobutton.RadioGroupVariant;
import eu.toop.playground.dc.ui.component.ConceptQueryComponent;
import eu.toop.playground.dc.ui.component.DocumentQueryComponent;
import eu.toop.playground.dc.ui.model.ConceptQueryFVBean;
import eu.toop.playground.dc.ui.model.DocumentQueryFVBean;
import eu.toop.playground.dc.ui.model.enums.EQueryDefinition;
import eu.toop.playground.dc.ui.presenter.MainPresenter;
import eu.toop.playground.dc.ui.util.Utilities;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryDefinitionComponent
extends Composite<FormLayout> {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)QueryDefinitionComponent.class.getName());
    MainPresenter presenter;
    ConceptQueryComponent conceptQueryComponent;
    DocumentQueryComponent documentQueryComponent;
    RadioButtonGroup<String> queryTypeRadioGroup;
    Div queryBox = new Div();

    public QueryDefinitionComponent(MainPresenter mainPresenter, Div div) {
        this.presenter = mainPresenter;
        this.queryBox.getStyle().set("width", "95%");
        ((FormLayout)this.getContent()).setWidthFull();
        this.queryTypeRadioGroup = new RadioButtonGroup();
        this.queryTypeRadioGroup.setLabel("What is the Query type: ");
        this.queryTypeRadioGroup.setItems((Collection)Arrays.stream(EQueryDefinition.values()).map(EQueryDefinition::getQueryDefinition).collect(Collectors.toList()));
        this.queryTypeRadioGroup.addThemeVariants(new RadioGroupVariant[]{RadioGroupVariant.LUMO_VERTICAL});
        this.queryTypeRadioGroup.addValueChangeListener((HasValue.ValueChangeListener & Serializable)componentValueChangeEvent -> mainPresenter.initQueryType(componentValueChangeEvent));
        this.queryBox.setClassName("queryBox");
        this.queryBox.setVisible(false);
        ((FormLayout)this.getContent()).add(new Component[]{this.queryTypeRadioGroup});
        ((FormLayout)this.getContent()).add(new Component[]{this.queryBox});
    }

    public void renderConceptQuery(ConceptQueryFVBean conceptQueryFVBean) {
        this.resetRenderedComponents();
        this.conceptQueryComponent = new ConceptQueryComponent(this.presenter, conceptQueryFVBean);
        LOGGER.debug("Render Concept Query: inside QueryDefinition Component");
        this.queryBox.setVisible(true);
        this.queryBox.add(new Component[]{this.conceptQueryComponent});
    }

    public void renderDocumentQuery(DocumentQueryFVBean documentQueryFVBean, String string) {
        this.resetRenderedComponents();
        this.documentQueryComponent = new DocumentQueryComponent(this.presenter, string, documentQueryFVBean);
        this.queryBox.setVisible(true);
        this.queryBox.add(new Component[]{this.documentQueryComponent});
        LOGGER.debug("Render Document Query: inside QueryDefinition Component");
    }

    public boolean conceptQueryComponentExists(ConceptQueryComponent conceptQueryComponent) {
        return conceptQueryComponent != null;
    }

    public boolean documentQueryComponentExists(DocumentQueryComponent documentQueryComponent) {
        return documentQueryComponent != null;
    }

    public void resetRenderedComponents() {
        if (this.documentQueryComponentExists(this.documentQueryComponent)) {
            this.queryBox.remove(new Component[]{this.documentQueryComponent});
        }
        if (this.conceptQueryComponentExists(this.conceptQueryComponent)) {
            this.queryBox.remove(new Component[]{this.conceptQueryComponent});
        }
    }

    public void setBeans(ConceptQueryFVBean conceptQueryFVBean, DocumentQueryFVBean documentQueryFVBean) {
        if (Utilities.conceptQueryComponentExists((ConceptQueryComponent)this.conceptQueryComponent)) {
            this.conceptQueryComponent.resetConceptBean(conceptQueryFVBean);
        }
        if (Utilities.documentQueryComponentExists((DocumentQueryComponent)this.documentQueryComponent)) {
            this.documentQueryComponent.resetDocumentBean(documentQueryFVBean);
        }
    }
}

