/*
 * Decompiled with CFR 0.152.
 */
package eu.toop.playground.dc.ui.component;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.Composite;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.button.ButtonVariant;
import com.vaadin.flow.component.icon.Icon;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.notification.Notification;
import com.vaadin.flow.component.notification.NotificationVariant;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.server.InputStreamFactory;
import com.vaadin.flow.server.StreamResource;
import eu.toop.edm.EDMRequest;
import eu.toop.playground.dc.ui.component.DocumentResponseComponent;
import eu.toop.playground.dc.ui.presenter.MainPresenter;
import java.io.ByteArrayInputStream;
import java.io.Serializable;
import java.util.Objects;
import org.vaadin.olli.FileDownloadWrapper;

public class RequestByIDButtonComponent
extends Composite<HorizontalLayout> {
    MainPresenter presenter;
    Button downloadRequestByIdBtn;
    Button createDocIDRequestBtn;
    EDMRequest request;

    public RequestByIDButtonComponent(MainPresenter mainPresenter, String string, DocumentResponseComponent documentResponseComponent) {
        this.presenter = mainPresenter;
        this.createDocIDRequestBtn = new Button("create request");
        this.downloadRequestByIdBtn = new Button();
        this.downloadRequestByIdBtn.setIcon((Component)new Icon(VaadinIcon.DOWNLOAD_ALT));
        this.downloadRequestByIdBtn.addThemeVariants(new ButtonVariant[]{ButtonVariant.LUMO_PRIMARY});
        this.createDocIDRequestBtn.addThemeVariants(new ButtonVariant[]{ButtonVariant.LUMO_PRIMARY});
        this.createDocIDRequestBtn.addClickListener((ComponentEventListener & Serializable)clickEvent -> mainPresenter.createDocumentRefIDRequestMessage(documentResponseComponent, string, this));
        ((HorizontalLayout)this.getContent()).add(new Component[]{this.createDocIDRequestBtn});
    }

    public void setRequest(EDMRequest eDMRequest) {
        this.request = eDMRequest;
        FileDownloadWrapper fileDownloadWrapper = new FileDownloadWrapper(new StreamResource("TOOPRequest.xml", (InputStreamFactory & Serializable)() -> new ByteArrayInputStream(Objects.requireNonNull(eDMRequest.getWriter().getAsBytes()))));
        fileDownloadWrapper.wrapComponent((Component)this.downloadRequestByIdBtn);
        Notification notification = new Notification("Created TOOPRequest Document", 3000, Notification.Position.TOP_START);
        notification.addThemeVariants(new NotificationVariant[]{NotificationVariant.LUMO_SUCCESS});
        notification.open();
        ((HorizontalLayout)this.getContent()).add(new Component[]{fileDownloadWrapper});
    }
}

