/*
 * Decompiled with CFR 0.152.
 */
package eu.toop.playground.dc.ui.component;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.Composite;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.button.ButtonVariant;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.html.H2;
import com.vaadin.flow.component.notification.Notification;
import com.vaadin.flow.component.notification.NotificationVariant;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.function.ValueProvider;
import eu.toop.edm.EDMErrorResponse;
import eu.toop.edm.EDMResponse;
import eu.toop.edm.model.EToopQueryDefinitionType;
import eu.toop.playground.dc.ui.component.ActionButtonComponent;
import eu.toop.playground.dc.ui.model.EDMResponseWithAttachment;
import eu.toop.playground.dc.ui.model.ResultBean;
import eu.toop.playground.dc.ui.presenter.MainPresenter;
import java.io.Serializable;
import java.util.List;

public class RequestStatusGridComponent
extends Composite<VerticalLayout> {
    H2 requestStatusHeader = new H2("Request Status: ");
    Div requestStatusBox;
    Grid<ResultBean> resultGrid = new Grid(ResultBean.class, true);

    public RequestStatusGridComponent() {
        this.requestStatusBox = new Div();
        this.requestStatusBox.setClassName("requestStatusBox");
        ((VerticalLayout)this.getContent()).setPadding(false);
    }

    public void renderStatusGrid(List<ResultBean> list, MainPresenter mainPresenter) {
        this.resultGrid.setItems(list);
        this.resultGrid.removeAllColumns();
        this.resultGrid.addColumn((ValueProvider & Serializable)resultBean -> resultBean.getRequest().getRequestID()).setHeader("Request ID").setResizable(true);
        this.resultGrid.addColumn((ValueProvider & Serializable)resultBean -> resultBean.getRequest().getQueryDefinition()).setHeader("Request Type").setResizable(true);
        this.resultGrid.addColumn((ValueProvider & Serializable)resultBean -> resultBean.getDpIdentifier()).setHeader("Data Provider Identifier").setResizable(true);
        this.resultGrid.addColumn((ValueProvider & Serializable)resultBean -> resultBean.getRequest().getIssueDateTime()).setHeader("Request Date/Time").setResizable(true);
        this.resultGrid.addColumn(ResultBean::getStatus).setHeader("Status").setResizable(true);
        this.resultGrid.addComponentColumn((ValueProvider & Serializable)resultBean -> {
            ActionButtonComponent actionButtonComponent = new ActionButtonComponent(mainPresenter);
            if (this.responseExists(resultBean.getResponse())) {
                actionButtonComponent.enableBtns(Boolean.valueOf(true));
                actionButtonComponent.enableAttachBtns(Boolean.valueOf(false));
                actionButtonComponent.enableErrorBtns(Boolean.valueOf(false));
                actionButtonComponent.showErrorBtns(Boolean.valueOf(false));
                actionButtonComponent.showBtns(Boolean.valueOf(true));
                actionButtonComponent.showAttachBtns(Boolean.valueOf(false));
                actionButtonComponent.setResponse(resultBean.getResponse());
            } else if (this.responseWithAttachmentsExists(resultBean.getResponseWithAttachment())) {
                actionButtonComponent.enableAttachBtns(Boolean.valueOf(true));
                actionButtonComponent.enableErrorBtns(Boolean.valueOf(false));
                actionButtonComponent.enableBtns(Boolean.valueOf(false));
                actionButtonComponent.showErrorBtns(Boolean.valueOf(false));
                actionButtonComponent.showAttachBtns(Boolean.valueOf(true));
                actionButtonComponent.showBtns(Boolean.valueOf(false));
                actionButtonComponent.setResponseWithAttachment(resultBean.getResponseWithAttachment());
            } else if (this.responseErrorExists(resultBean.getErrorResponse())) {
                actionButtonComponent.enableErrorBtns(Boolean.valueOf(true));
                actionButtonComponent.enableBtns(Boolean.valueOf(false));
                actionButtonComponent.enableAttachBtns(Boolean.valueOf(false));
                actionButtonComponent.showErrorBtns(Boolean.valueOf(true));
                actionButtonComponent.showBtns(Boolean.valueOf(false));
                actionButtonComponent.showAttachBtns(Boolean.valueOf(false));
                actionButtonComponent.setErrorResponse(resultBean.getErrorResponse());
            } else {
                actionButtonComponent.enableBtns(Boolean.valueOf(false));
                actionButtonComponent.enableAttachBtns(Boolean.valueOf(false));
                actionButtonComponent.enableErrorBtns(Boolean.valueOf(false));
                actionButtonComponent.showErrorBtns(Boolean.valueOf(false));
                actionButtonComponent.showAttachBtns(Boolean.valueOf(false));
            }
            return actionButtonComponent;
        }).setHeader("Action").setResizable(true);
        this.resultGrid.addComponentColumn((ValueProvider & Serializable)resultBean -> {
            Button button = new Button("resend request");
            button.addThemeVariants(new ButtonVariant[]{ButtonVariant.LUMO_PRIMARY});
            if (resultBean.getRequest().getQueryDefinition().getID().equals(EToopQueryDefinitionType.CONCEPT.getID())) {
                button.addClickListener((ComponentEventListener & Serializable)clickEvent -> mainPresenter.resendConceptQuery(resultBean.getRequest(), resultBean.getDsdDTO()));
            } else if (resultBean.getRequest().getQueryDefinition().getID().equals(EToopQueryDefinitionType.DOCUMENT_BY_DISTRIBUTION.getID())) {
                button.addClickListener((ComponentEventListener & Serializable)clickEvent -> mainPresenter.resendDocumentQuery(resultBean.getRequest(), resultBean.getDsdDTO()));
            } else if (resultBean.getRequest().getQueryDefinition().getID().equals(EToopQueryDefinitionType.DOCUMENT_BY_ID.getID())) {
                button.addClickListener((ComponentEventListener & Serializable)clickEvent -> mainPresenter.resendDocumentQueryByID(resultBean.getRequest(), resultBean.getDsdDTO()));
            }
            return button;
        }).setHeader("Action 2").setResizable(true);
        this.requestStatusBox.add(new Component[]{this.resultGrid});
        ((VerticalLayout)this.getContent()).add(new Component[]{this.requestStatusHeader, this.requestStatusBox});
    }

    public void refreshGrid() {
        this.resultGrid.getDataProvider().refreshAll();
        Notification notification = new Notification("Response Created...", 3000, Notification.Position.TOP_START);
        notification.addThemeVariants(new NotificationVariant[]{NotificationVariant.LUMO_PRIMARY});
        notification.open();
    }

    public boolean gridExists(Grid<ResultBean> grid) {
        return grid != null;
    }

    public boolean responseExists(EDMResponse eDMResponse) {
        return eDMResponse != null;
    }

    public boolean responseWithAttachmentsExists(EDMResponseWithAttachment eDMResponseWithAttachment) {
        return eDMResponseWithAttachment != null;
    }

    public boolean responseErrorExists(EDMErrorResponse eDMErrorResponse) {
        return eDMErrorResponse != null;
    }
}

