/*
 * Decompiled with CFR 0.152.
 */
package eu.toop.playground.dc.ui.component;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.Composite;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.button.ButtonVariant;
import com.vaadin.flow.component.combobox.ComboBox;
import com.vaadin.flow.component.formlayout.FormLayout;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.data.binder.BeanValidationBinder;
import com.vaadin.flow.data.binder.BinderValidationStatus;
import com.vaadin.flow.data.binder.PropertyId;
import eu.toop.playground.dc.ui.component.ConceptQueryComponent;
import eu.toop.playground.dc.ui.component.DocumentQueryComponent;
import eu.toop.playground.dc.ui.model.ConceptQueryFVBean;
import eu.toop.playground.dc.ui.model.DocumentQueryFVBean;
import eu.toop.playground.dc.ui.presenter.MainPresenter;
import java.io.IOException;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TopLevelSlotComponent
extends Composite<VerticalLayout> {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)TopLevelSlotComponent.class.getName());
    private Div DSDQueryBox;
    private Div fetchBox;
    private Button fetchDSD;
    @PropertyId(value="procedure")
    TextField procedure = new TextField("Procedure: ");
    @PropertyId(value="dataProviderCountry")
    TextField dataProviderCountry = new TextField("Data Provider Country: ");
    @PropertyId(value="datasetIdentifier")
    ComboBox<String> datasetIdentifier = new ComboBox();
    BinderValidationStatus<ConceptQueryFVBean> statusConcept;
    BinderValidationStatus<DocumentQueryFVBean> statusDocument;
    BeanValidationBinder<ConceptQueryFVBean> binderConceptQuery;
    BeanValidationBinder<DocumentQueryFVBean> binderDocumentQuery;
    ConceptQueryFVBean conceptQueryFVBean;
    DocumentQueryFVBean documentQueryFVBean;

    public TopLevelSlotComponent(MainPresenter mainPresenter, ConceptQueryFVBean conceptQueryFVBean, ConceptQueryComponent conceptQueryComponent) {
        this.conceptQueryFVBean = conceptQueryFVBean;
        ((VerticalLayout)this.getContent()).setSpacing(false);
        ((VerticalLayout)this.getContent()).setPadding(false);
        this.DSDQueryBox = new Div();
        this.fetchBox = new Div();
        FormLayout formLayout = new FormLayout();
        this.procedure.getStyle().set("width", "48%");
        ((VerticalLayout)this.getContent()).setWidthFull();
        this.DSDQueryBox.setClassName("DSDQueryBox");
        this.datasetIdentifier.setItems((Object[])new String[]{"REGISTERED_ORGANIZATION_TYPE"});
        this.datasetIdentifier.setPlaceholder("Select: ");
        this.datasetIdentifier.setLabel("Dataset Type Identifier: ");
        this.binderConceptQuery = new BeanValidationBinder(ConceptQueryFVBean.class, true);
        this.binderConceptQuery.setBean((Object)conceptQueryFVBean);
        this.binderConceptQuery.bindInstanceFields((Object)this);
        this.fetchDSD = new Button("fetch info");
        this.fetchDSD.addThemeVariants(new ButtonVariant[]{ButtonVariant.LUMO_PRIMARY});
        this.fetchDSD.addClickListener((ComponentEventListener & Serializable)clickEvent -> {
            try {
                this.statusConcept = this.binderConceptQuery.validate();
                if (!this.statusConcept.hasErrors() && !this.dataProviderCountry.getValue().isEmpty()) {
                    mainPresenter.populateConceptDatasetGrid(conceptQueryComponent, (String)this.datasetIdentifier.getValue(), this.dataProviderCountry.getValue());
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        });
        this.fetchBox.add(new Component[]{this.fetchDSD});
        this.DSDQueryBox.add(new Component[]{formLayout});
        formLayout.add(new Component[]{this.dataProviderCountry, this.datasetIdentifier, this.fetchDSD});
        ((VerticalLayout)this.getContent()).add(new Component[]{this.procedure, this.DSDQueryBox});
    }

    public TopLevelSlotComponent(MainPresenter mainPresenter, DocumentQueryFVBean documentQueryFVBean, DocumentQueryComponent documentQueryComponent) {
        this.documentQueryFVBean = documentQueryFVBean;
        ((VerticalLayout)this.getContent()).setSpacing(false);
        ((VerticalLayout)this.getContent()).setPadding(false);
        this.DSDQueryBox = new Div();
        this.fetchBox = new Div();
        FormLayout formLayout = new FormLayout();
        this.procedure.getStyle().set("width", "48%");
        ((VerticalLayout)this.getContent()).setWidthFull();
        this.DSDQueryBox.setClassName("DSDQueryBox");
        this.datasetIdentifier.setAllowCustomValue(true);
        this.datasetIdentifier.setItems((Object[])new String[]{"FINANCIAL_RECORD_TYPE"});
        this.datasetIdentifier.setPlaceholder("Select: ");
        this.datasetIdentifier.setLabel("Dataset Type Identifier: ");
        this.binderDocumentQuery = new BeanValidationBinder(DocumentQueryFVBean.class, true);
        this.binderDocumentQuery.setBean((Object)documentQueryFVBean);
        this.binderDocumentQuery.bindInstanceFields((Object)this);
        this.fetchDSD = new Button("fetch info");
        this.fetchDSD.addThemeVariants(new ButtonVariant[]{ButtonVariant.LUMO_PRIMARY});
        this.datasetIdentifier.addCustomValueSetListener((ComponentEventListener & Serializable)customValueSetEvent -> this.datasetIdentifier.setValue((Object)customValueSetEvent.getDetail()));
        this.fetchDSD.addClickListener((ComponentEventListener & Serializable)clickEvent -> {
            try {
                this.statusDocument = this.binderDocumentQuery.validate();
                if (!this.statusDocument.hasErrors()) {
                    mainPresenter.populateDistributionGrid(documentQueryComponent, (String)this.datasetIdentifier.getValue(), this.dataProviderCountry.getValue());
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        });
        this.fetchBox.add(new Component[]{this.fetchDSD});
        this.DSDQueryBox.add(new Component[]{formLayout});
        formLayout.add(new Component[]{this.dataProviderCountry, this.datasetIdentifier, this.fetchDSD});
        ((VerticalLayout)this.getContent()).add(new Component[]{this.procedure, this.DSDQueryBox});
    }

    public void resetConceptBean(ConceptQueryFVBean conceptQueryFVBean) {
        this.conceptQueryFVBean = conceptQueryFVBean;
        this.binderConceptQuery.setBean((Object)conceptQueryFVBean);
        this.binderConceptQuery.bindInstanceFields((Object)this);
    }

    public void resetDocumentBean(DocumentQueryFVBean documentQueryFVBean) {
        this.documentQueryFVBean = documentQueryFVBean;
        this.binderDocumentQuery.setBean((Object)documentQueryFVBean);
        this.binderDocumentQuery.bindInstanceFields((Object)this);
    }
}

