/*
 * Decompiled with CFR 0.152.
 */
package eu.toop.playground.dc.ui.presenter;

import com.helger.commons.error.level.EErrorLevel;
import com.helger.commons.error.level.IErrorLevel;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.notification.Notification;
import com.vaadin.flow.component.notification.NotificationVariant;
import com.vaadin.flow.component.upload.receivers.MemoryBuffer;
import eu.toop.edm.EDMErrorResponse;
import eu.toop.edm.EDMRequest;
import eu.toop.edm.EDMResponse;
import eu.toop.edm.model.BusinessPojo;
import eu.toop.edm.model.ConceptPojo;
import eu.toop.edm.model.DatasetPojo;
import eu.toop.edm.model.DistributionPojo;
import eu.toop.edm.model.EToopDistributionFormat;
import eu.toop.edm.model.EToopLanguageCode;
import eu.toop.edm.model.EToopQueryDefinitionType;
import eu.toop.edm.model.PersonPojo;
import eu.toop.edm.request.EDMRequestPayloadConcepts;
import eu.toop.edm.request.EDMRequestPayloadDistribution;
import eu.toop.edm.request.EDMRequestPayloadDocumentID;
import eu.toop.edm.request.IEDMRequestPayloadDocumentID;
import eu.toop.edm.response.EDMResponsePayloadConcepts;
import eu.toop.edm.response.IEDMResponsePayloadConcepts;
import eu.toop.edm.response.IEDMResponsePayloadDocument;
import eu.toop.edm.response.IEDMResponsePayloadDocumentReference;
import eu.toop.edm.response.IEDMResponsePayloadProvider;
import eu.toop.edm.response.ResponseDocumentPojo;
import eu.toop.edm.response.ResponseDocumentReferencePojo;
import eu.toop.kafkaclient.ToopKafkaClient;
import eu.toop.playground.dc.ui.component.ConceptQueryComponent;
import eu.toop.playground.dc.ui.component.DocumentQueryComponent;
import eu.toop.playground.dc.ui.component.DocumentResponseComponent;
import eu.toop.playground.dc.ui.component.RequestByIDButtonComponent;
import eu.toop.playground.dc.ui.model.AddressBean;
import eu.toop.playground.dc.ui.model.ConceptQueryFVBean;
import eu.toop.playground.dc.ui.model.ConceptResponseFVBean;
import eu.toop.playground.dc.ui.model.DocumentQueryFVBean;
import eu.toop.playground.dc.ui.model.DocumentResponseFVBean;
import eu.toop.playground.dc.ui.model.EDMResponseWithAttachment;
import eu.toop.playground.dc.ui.model.ErrorResponseFVBean;
import eu.toop.playground.dc.ui.model.LegalPersonFVBean;
import eu.toop.playground.dc.ui.model.NaturalPersonFVBean;
import eu.toop.playground.dc.ui.model.ResultBean;
import eu.toop.playground.dc.ui.model.dto.DSDDatasetResponseDto;
import eu.toop.playground.dc.ui.model.enums.EResponseStatus;
import eu.toop.playground.dc.ui.model.exceptions.EvaluationException;
import eu.toop.playground.dc.ui.service.ConceptService;
import eu.toop.playground.dc.ui.service.ConnectionService;
import eu.toop.playground.dc.ui.service.DSDService;
import eu.toop.playground.dc.ui.util.MessageCreation;
import eu.toop.playground.dc.ui.util.Utilities;
import eu.toop.playground.dc.ui.view.DynamicRequestView;
import eu.toop.regrep.rim.LocalizedStringType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MainPresenter {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)MainPresenter.class.getName());
    private DynamicRequestView view;
    private NaturalPersonFVBean naturalPersonFVBean;
    private LegalPersonFVBean legalPersonFVBean;
    private NaturalPersonFVBean naturalPersonARFVBean;
    private ConceptQueryFVBean conceptQueryFVBean;
    private ConceptResponseFVBean conceptResponseFVBean;
    private DocumentResponseFVBean documentResponseFVBean;
    private DocumentQueryFVBean documentQueryFVBean;
    private ErrorResponseFVBean errorResponseFVBean;
    private List<DSDDatasetResponseDto> DSDDatasetResponseList;
    private List<ConceptPojo> allConcepts;
    private List<ResultBean> resultBeanList;
    private ConnectionService connectionService;
    private Map<String, ResultBean> resultMap;
    private final DSDService dsdService = new DSDService();
    private final ConceptService conceptService = new ConceptService();
    private boolean hasErrors = true;

    public void init(DynamicRequestView dynamicRequestView) {
        this.view = dynamicRequestView;
        LOGGER.debug("Got concept dataset from mock DSD: ");
        this.allConcepts = this.conceptService.getConceptPojoParent();
        this.conceptQueryFVBean = new ConceptQueryFVBean();
        this.documentQueryFVBean = new DocumentQueryFVBean();
        this.naturalPersonFVBean = new NaturalPersonFVBean();
        this.legalPersonFVBean = new LegalPersonFVBean();
        this.naturalPersonARFVBean = new NaturalPersonFVBean();
        this.conceptResponseFVBean = new ConceptResponseFVBean();
        this.documentResponseFVBean = new DocumentResponseFVBean();
        this.errorResponseFVBean = new ErrorResponseFVBean();
        this.resultBeanList = new ArrayList();
        this.connectionService = new ConnectionService();
        this.resultMap = new LinkedHashMap();
    }

    public void initDataSubject(HasValue.ValueChangeEvent valueChangeEvent) {
        LOGGER.debug("Radio button value: " + valueChangeEvent.getValue().toString());
        if (valueChangeEvent.getValue().toString().equals("Natural Person")) {
            this.naturalPersonFVBean = new NaturalPersonFVBean();
            this.view.initNP(this.naturalPersonFVBean);
        } else {
            this.legalPersonFVBean = new LegalPersonFVBean();
            this.view.initLP(this.legalPersonFVBean);
        }
    }

    public void initQueryType(HasValue.ValueChangeEvent valueChangeEvent) {
        LOGGER.debug("Radio button value: " + valueChangeEvent.getValue().toString());
        if (valueChangeEvent.getValue().toString().equals("Concept Query")) {
            this.view.initConceptQuery(this.conceptQueryFVBean);
        } else {
            this.view.initDocumentQuery(this.documentQueryFVBean, valueChangeEvent.getValue().toString());
        }
    }

    public void initAuthorizedRepresentative() {
        this.naturalPersonARFVBean = new NaturalPersonFVBean();
        this.view.initAR(this.naturalPersonARFVBean);
    }

    public void resetAuthorizedRepresentative() {
        this.naturalPersonARFVBean = new NaturalPersonFVBean();
    }

    public void resetNP() {
        this.naturalPersonFVBean = new NaturalPersonFVBean();
    }

    public void resetLP() {
        this.legalPersonFVBean = new LegalPersonFVBean();
    }

    public void notifyConceptSelection(Set<ConceptPojo> set) {
        this.conceptQueryFVBean.setConceptRequestList(set.stream().map(conceptPojo -> conceptPojo.getName()).collect(Collectors.toList()));
        LOGGER.debug("SELECTED CONCEPTS FROM UI: ");
        LOGGER.debug(Arrays.toString(this.conceptQueryFVBean.getConceptRequestList().toArray()));
    }

    public void populateConceptSelectionGrid(ConceptQueryComponent conceptQueryComponent) {
        conceptQueryComponent.renderConceptSelectionGrid(this.allConcepts);
    }

    public void populateDistributionGrid(DocumentQueryComponent documentQueryComponent, String string, String string2) throws IOException {
        documentQueryComponent.renderDatasetList(this.dsdService.getDatasets(string, string2));
        Notification notification = new Notification("toop-edm:v2.0 responses are filtered out", 5000, Notification.Position.TOP_START);
        notification.addThemeVariants(new NotificationVariant[]{NotificationVariant.LUMO_PRIMARY, NotificationVariant.LUMO_PRIMARY});
        notification.open();
    }

    public void populateConceptDatasetGrid(ConceptQueryComponent conceptQueryComponent, String string, String string2) throws IOException {
        if (!string2.isEmpty()) {
            conceptQueryComponent.renderConceptDatasetList(this.dsdService.getDatasets(string, string2));
            Notification notification = new Notification("toop-edm:v2.0 responses are filtered out", 5000, Notification.Position.TOP_START);
            notification.addThemeVariants(new NotificationVariant[]{NotificationVariant.LUMO_PRIMARY, NotificationVariant.LUMO_PRIMARY});
            notification.open();
        }
    }

    public void showResponse(EDMResponse eDMResponse) {
        if (eDMResponse.getAllPayloadProviders().get(0) instanceof EDMResponsePayloadConcepts) {
            LOGGER.debug("INSIDE SHOW RESPONSE - CONCEPT: ");
            this.importConceptResponse(eDMResponse);
        } else if (eDMResponse.getAllPayloadProviders().get(0) instanceof IEDMResponsePayloadDocument || eDMResponse.getAllPayloadProviders().get(0) instanceof IEDMResponsePayloadDocumentReference) {
            LOGGER.debug("INSIDE SHOW RESPONSE - DOCUMENT: ");
            this.importDocumentResponse(eDMResponse);
        }
    }

    public void showResponse(EDMResponseWithAttachment eDMResponseWithAttachment) {
        if (eDMResponseWithAttachment.getEdmResponse().getAllPayloadProviders().get(0) instanceof ResponseDocumentPojo || eDMResponseWithAttachment.getEdmResponse().getAllPayloadProviders().get(0) instanceof ResponseDocumentReferencePojo) {
            LOGGER.debug("INSIDE SHOW RESPONSE - DOCUMENT WITH ATTACHMENT: ");
            this.importDocumentResponse(eDMResponseWithAttachment);
        }
    }

    public void showErrorResponse(EDMErrorResponse eDMErrorResponse) {
        LOGGER.debug("INSIDE SHOW ERROR RESPONSE: ");
        LOGGER.debug(eDMErrorResponse.getErrorProvider().toString());
        this.importErrorResponse(eDMErrorResponse);
    }

    public void createConceptRequestMessage(ConceptQueryComponent conceptQueryComponent, DSDDatasetResponseDto dSDDatasetResponseDto) {
        LOGGER.debug("Create ConceptQuery Request message ....");
        this.makeConceptRequests(conceptQueryComponent, dSDDatasetResponseDto);
    }

    public void makeConceptRequests(ConceptQueryComponent conceptQueryComponent, DSDDatasetResponseDto dSDDatasetResponseDto) {
        EDMRequest.BuilderConcept builderConcept = EDMRequest.builderConcept();
        this.addCommonSlots(builderConcept);
        this.addConcepts(builderConcept);
        EDMRequest eDMRequest = ((EDMRequest.BuilderConcept)builderConcept.randomID()).build();
        this.submitRequest(eDMRequest, dSDDatasetResponseDto);
        conceptQueryComponent.downloadXML(eDMRequest);
    }

    public void addConcepts(EDMRequest.BuilderConcept builderConcept) {
        builderConcept.concept(MessageCreation.createConceptRequestListFromQName((List)this.conceptQueryFVBean.getConceptRequestList()));
    }

    public void addCommonSlots(EDMRequest.BuilderConcept builderConcept) {
        ((EDMRequest.BuilderConcept)((EDMRequest.BuilderConcept)((EDMRequest.BuilderConcept)((EDMRequest.BuilderConcept)((EDMRequest.BuilderConcept)builderConcept.issueDateTimeNow()).procedure(EToopLanguageCode.EN.getID(), this.conceptQueryFVBean.getProcedure())).dataConsumer(MessageCreation.createDataConsumer())).datasetIdentifier(this.conceptQueryFVBean.getDatasetIdentifier())).specificationIdentifier(this.conceptQueryFVBean.getSpecificationIdentifier())).consentToken(this.conceptQueryFVBean.getConsentToken());
        this.addDataSubject(builderConcept);
    }

    public void addDataSubject(EDMRequest.BuilderConcept builderConcept) {
        if (Utilities.authorizedRepresentativeExistsAndNotEmpty((NaturalPersonFVBean)this.naturalPersonARFVBean)) {
            LOGGER.debug("INSIDE AUTHORIZED REPRESENTATIVE");
            builderConcept.authorizedRepresentative(MessageCreation.createNaturalPerson((NaturalPersonFVBean)this.naturalPersonARFVBean, (AddressBean)this.naturalPersonARFVBean.getAddress()));
        }
        if (Utilities.legalPersonExistsAndNotEmpty((LegalPersonFVBean)this.legalPersonFVBean)) {
            LOGGER.debug("INSIDE LEGAL PERSON EXIST: ");
            builderConcept.dataSubject(MessageCreation.createLegalPerson((LegalPersonFVBean)this.legalPersonFVBean, (AddressBean)this.legalPersonFVBean.getAddress()));
        }
        if (Utilities.naturalPersonExistsAndNotEmpty((NaturalPersonFVBean)this.naturalPersonFVBean)) {
            LOGGER.debug("INSIDE NATURAL PERSON BEAN");
            builderConcept.dataSubject(MessageCreation.createNaturalPerson((NaturalPersonFVBean)this.naturalPersonFVBean, (AddressBean)this.naturalPersonFVBean.getAddress()));
        }
    }

    private void submitRequest(EDMRequest eDMRequest, DSDDatasetResponseDto dSDDatasetResponseDto) {
        try {
            ToopKafkaClient.send((IErrorLevel)EErrorLevel.INFO, (String)"Freedonia DC Sending an EDMRequest...");
            this.connectionService.submit(eDMRequest, dSDDatasetResponseDto);
            LOGGER.debug("Inside submit request");
            this.resultMap.put(eDMRequest.getRequestID(), new ResultBean(eDMRequest, dSDDatasetResponseDto));
            LOGGER.debug("Request with id: {} added in map. Request submitted successfully.", (Object)eDMRequest.getRequestID());
            this.resultBeanList = this.resultMap.entrySet().stream().map(entry -> (ResultBean)entry.getValue()).collect(Collectors.toList());
            this.view.initStatusGrid(this.resultBeanList);
        }
        catch (EvaluationException | IOException throwable) {
            Notification notification = new Notification("Unable to send request to the connector", 5000, Notification.Position.TOP_START);
            notification.addThemeVariants(new NotificationVariant[]{NotificationVariant.LUMO_PRIMARY, NotificationVariant.LUMO_ERROR});
            notification.open();
            Notification notification2 = new Notification(throwable.getMessage(), 5000, Notification.Position.TOP_START);
            notification2.addThemeVariants(new NotificationVariant[]{NotificationVariant.LUMO_PRIMARY, NotificationVariant.LUMO_ERROR});
            notification2.open();
            ToopKafkaClient.send((IErrorLevel)EErrorLevel.ERROR, (String)throwable.getMessage());
            LOGGER.error(throwable.getMessage());
        }
    }

    public void addResponse(EDMResponse eDMResponse) {
        LOGGER.info("EDMResponse received {}", (Object)eDMResponse.getRequestID());
        if (this.resultMap.keySet().contains(eDMResponse.getRequestID())) {
            ((ResultBean)this.resultMap.get(eDMResponse.getRequestID())).setStatus(EResponseStatus.SUCCESS);
            ((ResultBean)this.resultMap.get(eDMResponse.getRequestID())).setResponse(eDMResponse);
            this.resultBeanList = this.resultMap.entrySet().stream().map(entry -> (ResultBean)entry.getValue()).collect(Collectors.toList());
            this.view.refreshStatusGrid();
            LOGGER.debug("Result Bean List has been created successfully");
        } else {
            LOGGER.debug("EDMResponse {} is NOT mine", (Object)eDMResponse.getRequestID());
        }
    }

    public void addResponse(EDMResponseWithAttachment eDMResponseWithAttachment) {
        LOGGER.info("EDMResponseWithAttachment received {}", (Object)eDMResponseWithAttachment.getEdmResponse().getRequestID());
        if (this.resultMap.keySet().contains(eDMResponseWithAttachment.getEdmResponse().getRequestID())) {
            ((ResultBean)this.resultMap.get(eDMResponseWithAttachment.getEdmResponse().getRequestID())).setStatus(EResponseStatus.SUCCESS);
            ((ResultBean)this.resultMap.get(eDMResponseWithAttachment.getEdmResponse().getRequestID())).setResponseWithAttachment(eDMResponseWithAttachment);
            this.resultBeanList = this.resultMap.entrySet().stream().map(entry -> (ResultBean)entry.getValue()).collect(Collectors.toList());
            this.view.refreshStatusGrid();
            LOGGER.debug("Result Bean List has been created successfully");
        } else {
            LOGGER.debug("EDMResponseWithAttachment {} is NOT mine", (Object)eDMResponseWithAttachment.getEdmResponse().getRequestID());
        }
    }

    public void addResponse(EDMErrorResponse eDMErrorResponse) {
        LOGGER.debug("EDMErrorResponse received {}", (Object)eDMErrorResponse.getRequestID());
        if (this.resultMap.keySet().contains(eDMErrorResponse.getRequestID())) {
            ((ResultBean)this.resultMap.get(eDMErrorResponse.getRequestID())).setStatus(EResponseStatus.FAILED);
            ((ResultBean)this.resultMap.get(eDMErrorResponse.getRequestID())).setErrorResponse(eDMErrorResponse);
            this.resultBeanList = this.resultMap.entrySet().stream().map(entry -> (ResultBean)entry.getValue()).collect(Collectors.toList());
            this.view.refreshStatusGrid();
            LOGGER.debug("Result Bean List has been created successfully");
        } else {
            LOGGER.debug("EDMErrorResponse {} is NOT mine", (Object)eDMErrorResponse.getRequestID());
        }
    }

    public void createDocumentRefIDRequestMessage(DocumentResponseComponent documentResponseComponent, String string, RequestByIDButtonComponent requestByIDButtonComponent) {
        LOGGER.debug("CREATE DOCUMENT ID REQUEST MESSAGE...");
        EDMRequest eDMRequest = ((ResultBean)this.resultMap.get(documentResponseComponent.getDocumentResponseFVBean().getRequestID())).getRequest();
        this.resetBeans();
        this.resetValuesDocumentQuery(eDMRequest);
        this.resetValuesDataSubject(eDMRequest);
        LOGGER.debug("Resend document query message: ");
        EDMRequest.BuilderDocumentByID builderDocumentByID = EDMRequest.builderDocumentByID();
        this.addCommonSlots(builderDocumentByID);
        if (documentResponseComponent.getDocumentResponseFVBean().getResponse().getAllPayloadProviders().get(0) instanceof IEDMResponsePayloadDocumentReference) {
            this.addDocumentID(builderDocumentByID, string);
        }
        eDMRequest = ((EDMRequest.BuilderDocumentByID)builderDocumentByID.randomID()).build();
        this.submitRequest(eDMRequest, ((ResultBean)this.resultMap.get(documentResponseComponent.getDocumentResponseFVBean().getRequestID())).getDsdDTO());
        LOGGER.debug(eDMRequest.getWriter().getAsString());
        requestByIDButtonComponent.setRequest(eDMRequest);
    }

    public void createDocumentRefRequestMessage(DocumentQueryComponent documentQueryComponent, DSDDatasetResponseDto dSDDatasetResponseDto) {
        LOGGER.debug("CREATE DOCUMENT REFERENCE REQUEST MESSAGE...");
        EDMRequest.BuilderDocumentsByDistribution builderDocumentsByDistribution = EDMRequest.builderDocumentReferencesByDistribution();
        this.addCommonSlots(builderDocumentsByDistribution);
        this.addDistribution(builderDocumentsByDistribution);
        EDMRequest eDMRequest = ((EDMRequest.BuilderDocumentsByDistribution)builderDocumentsByDistribution.randomID()).build();
        this.submitRequest(eDMRequest, dSDDatasetResponseDto);
        documentQueryComponent.downloadXML(eDMRequest);
    }

    public void createDocumentRequestMessage(DocumentQueryComponent documentQueryComponent, DSDDatasetResponseDto dSDDatasetResponseDto) {
        LOGGER.debug("CREATE DOCUMENT REQUEST MESSAGE...");
        EDMRequest.BuilderDocumentsByDistribution builderDocumentsByDistribution = EDMRequest.builderDocumentsByDistribution();
        this.addCommonSlots(builderDocumentsByDistribution);
        this.addDistribution(builderDocumentsByDistribution);
        EDMRequest eDMRequest = ((EDMRequest.BuilderDocumentsByDistribution)builderDocumentsByDistribution.randomID()).build();
        this.submitRequest(eDMRequest, dSDDatasetResponseDto);
        documentQueryComponent.downloadXML(eDMRequest);
    }

    public void addDistribution(EDMRequest.BuilderDocumentsByDistribution builderDocumentsByDistribution) {
        builderDocumentsByDistribution.addDistribution(DistributionPojo.builder().format(EToopDistributionFormat.valueOf((String)"UNSTRUCTURED")).mediaType("application/pdf").build());
    }

    public void addDocumentID(EDMRequest.BuilderDocumentByID builderDocumentByID, String string) {
        builderDocumentByID.documentID(string);
    }

    public void addCommonSlots(EDMRequest.BuilderDocumentsByDistribution builderDocumentsByDistribution) {
        ((EDMRequest.BuilderDocumentsByDistribution)((EDMRequest.BuilderDocumentsByDistribution)((EDMRequest.BuilderDocumentsByDistribution)((EDMRequest.BuilderDocumentsByDistribution)((EDMRequest.BuilderDocumentsByDistribution)builderDocumentsByDistribution.issueDateTimeNow()).procedure(EToopLanguageCode.EN.getID(), this.documentQueryFVBean.getProcedure())).dataConsumer(MessageCreation.createDataConsumer())).datasetIdentifier(this.documentQueryFVBean.getDatasetIdentifier())).specificationIdentifier(this.documentQueryFVBean.getSpecificationIdentifier())).consentToken(this.documentQueryFVBean.getConsentToken());
        this.addDataSubject(builderDocumentsByDistribution);
    }

    public void addCommonSlots(EDMRequest.BuilderDocumentByID builderDocumentByID) {
        ((EDMRequest.BuilderDocumentByID)((EDMRequest.BuilderDocumentByID)((EDMRequest.BuilderDocumentByID)((EDMRequest.BuilderDocumentByID)((EDMRequest.BuilderDocumentByID)builderDocumentByID.issueDateTimeNow()).procedure(EToopLanguageCode.EN.getID(), this.documentQueryFVBean.getProcedure())).dataConsumer(MessageCreation.createDataConsumer())).datasetIdentifier(this.documentQueryFVBean.getDatasetIdentifier())).specificationIdentifier(this.documentQueryFVBean.getSpecificationIdentifier())).consentToken(this.documentQueryFVBean.getConsentToken());
    }

    public void addDataSubject(EDMRequest.BuilderDocumentsByDistribution builderDocumentsByDistribution) {
        if (Utilities.authorizedRepresentativeExistsAndNotEmpty((NaturalPersonFVBean)this.naturalPersonARFVBean)) {
            LOGGER.debug("INSIDE AUTHORIZED REPRESENTATIVE");
            builderDocumentsByDistribution.authorizedRepresentative(MessageCreation.createNaturalPerson((NaturalPersonFVBean)this.naturalPersonARFVBean, (AddressBean)this.naturalPersonARFVBean.getAddress()));
        }
        if (Utilities.legalPersonExistsAndNotEmpty((LegalPersonFVBean)this.legalPersonFVBean)) {
            LOGGER.debug("INSIDE LEGAL PERSON EXIST: ");
            builderDocumentsByDistribution.dataSubject(MessageCreation.createLegalPerson((LegalPersonFVBean)this.legalPersonFVBean, (AddressBean)this.legalPersonFVBean.getAddress()));
        }
        if (Utilities.naturalPersonExistsAndNotEmpty((NaturalPersonFVBean)this.naturalPersonFVBean)) {
            LOGGER.debug("INSIDE NATURAL PERSON BEAN");
            builderDocumentsByDistribution.dataSubject(MessageCreation.createNaturalPerson((NaturalPersonFVBean)this.naturalPersonFVBean, (AddressBean)this.naturalPersonFVBean.getAddress()));
        }
    }

    public void addDataSubject(EDMRequest.BuilderDocumentByID builderDocumentByID) {
        if (Utilities.authorizedRepresentativeExistsAndNotEmpty((NaturalPersonFVBean)this.naturalPersonARFVBean)) {
            LOGGER.debug("INSIDE AUTHORIZED REPRESENTATIVE");
            builderDocumentByID.authorizedRepresentative(MessageCreation.createNaturalPerson((NaturalPersonFVBean)this.naturalPersonARFVBean, (AddressBean)this.naturalPersonARFVBean.getAddress()));
        }
        if (Utilities.legalPersonExistsAndNotEmpty((LegalPersonFVBean)this.legalPersonFVBean)) {
            LOGGER.debug("INSIDE LEGAL PERSON EXIST: ");
            builderDocumentByID.dataSubject(MessageCreation.createLegalPerson((LegalPersonFVBean)this.legalPersonFVBean, (AddressBean)this.legalPersonFVBean.getAddress()));
        }
        if (Utilities.naturalPersonExistsAndNotEmpty((NaturalPersonFVBean)this.naturalPersonFVBean)) {
            LOGGER.debug("INSIDE NATURAL PERSON BEAN");
            builderDocumentByID.dataSubject(MessageCreation.createNaturalPerson((NaturalPersonFVBean)this.naturalPersonFVBean, (AddressBean)this.naturalPersonFVBean.getAddress()));
        }
    }

    public void resendConceptQuery(EDMRequest eDMRequest, DSDDatasetResponseDto dSDDatasetResponseDto) {
        this.resetBeans();
        this.resetValuesConceptQuery(eDMRequest);
        this.resetValuesDataSubject(eDMRequest);
        LOGGER.debug("Resend concept query message: ");
        EDMRequest.BuilderConcept builderConcept = EDMRequest.builderConcept();
        this.addCommonSlots(builderConcept);
        this.addConcepts(builderConcept);
        eDMRequest = ((EDMRequest.BuilderConcept)builderConcept.randomID()).build();
        this.submitRequest(eDMRequest, dSDDatasetResponseDto);
        LOGGER.info(eDMRequest.getWriter().getAsString());
    }

    public void resetValuesDataSubject(EDMRequest eDMRequest) {
        AddressBean addressBean;
        if (Utilities.personPojoExists((PersonPojo)eDMRequest.getAuthorizedRepresentative())) {
            this.naturalPersonARFVBean.setPersonID(eDMRequest.getAuthorizedRepresentative().getID());
            this.naturalPersonARFVBean.setPersonIDScheme(eDMRequest.getAuthorizedRepresentative().getIDSchemeID());
            this.naturalPersonARFVBean.setPersonFamilyName(eDMRequest.getAuthorizedRepresentative().getFamilyName());
            this.naturalPersonARFVBean.setPersonGivenName(eDMRequest.getAuthorizedRepresentative().getGivenName());
            this.naturalPersonARFVBean.setPersonGenderCode(eDMRequest.getAuthorizedRepresentative().getGenderCode());
            this.naturalPersonARFVBean.setPersonBirthName(eDMRequest.getAuthorizedRepresentative().getBirthName());
            this.naturalPersonARFVBean.setPersonBirthDate(eDMRequest.getAuthorizedRepresentative().getBirthDate());
            this.naturalPersonARFVBean.setPersonPlaceOfBirthAddressPostName(eDMRequest.getAuthorizedRepresentative().getBirthTown());
            addressBean = new AddressBean();
            assert (eDMRequest.getAuthorizedRepresentative().getAddress() != null);
            addressBean.setAddressFullAddress(eDMRequest.getAuthorizedRepresentative().getAddress().getFullAddress());
            addressBean.setAddressLocatorDesignator(eDMRequest.getAuthorizedRepresentative().getAddress().getStreetName());
            addressBean.setAddressThoroughfare(eDMRequest.getAuthorizedRepresentative().getAddress().getBuildingNumber());
            addressBean.setAddressPostName(eDMRequest.getAuthorizedRepresentative().getAddress().getTown());
            addressBean.setAddressAdminUnitFirstline(eDMRequest.getAuthorizedRepresentative().getAddress().getCountryCode());
            addressBean.setAddressPostCode(eDMRequest.getAuthorizedRepresentative().getAddress().getPostalCode());
            this.naturalPersonARFVBean.setAddress(addressBean);
        }
        if (Utilities.personPojoExists((PersonPojo)eDMRequest.getDataSubjectNaturalPerson())) {
            this.naturalPersonFVBean.setPersonID(eDMRequest.getDataSubjectNaturalPerson().getID());
            this.naturalPersonFVBean.setPersonIDScheme(eDMRequest.getDataSubjectNaturalPerson().getIDSchemeID());
            this.naturalPersonFVBean.setPersonFamilyName(eDMRequest.getDataSubjectNaturalPerson().getFamilyName());
            this.naturalPersonFVBean.setPersonGivenName(eDMRequest.getDataSubjectNaturalPerson().getGivenName());
            this.naturalPersonFVBean.setPersonGenderCode(eDMRequest.getDataSubjectNaturalPerson().getGenderCode());
            this.naturalPersonFVBean.setPersonBirthName(eDMRequest.getDataSubjectNaturalPerson().getBirthName());
            this.naturalPersonFVBean.setPersonBirthDate(eDMRequest.getDataSubjectNaturalPerson().getBirthDate());
            this.naturalPersonFVBean.setPersonPlaceOfBirthAddressPostName(eDMRequest.getDataSubjectNaturalPerson().getBirthTown());
            addressBean = new AddressBean();
            assert (eDMRequest.getDataSubjectNaturalPerson().getAddress() != null);
            addressBean.setAddressFullAddress(eDMRequest.getDataSubjectNaturalPerson().getAddress().getFullAddress());
            addressBean.setAddressLocatorDesignator(eDMRequest.getDataSubjectNaturalPerson().getAddress().getStreetName());
            addressBean.setAddressThoroughfare(eDMRequest.getDataSubjectNaturalPerson().getAddress().getBuildingNumber());
            addressBean.setAddressPostName(eDMRequest.getDataSubjectNaturalPerson().getAddress().getTown());
            addressBean.setAddressAdminUnitFirstline(eDMRequest.getDataSubjectNaturalPerson().getAddress().getCountryCode());
            addressBean.setAddressPostCode(eDMRequest.getDataSubjectNaturalPerson().getAddress().getPostalCode());
            this.naturalPersonFVBean.setAddress(addressBean);
        }
        if (Utilities.businessPojoExists((BusinessPojo)eDMRequest.getDataSubjectLegalPerson())) {
            this.legalPersonFVBean.setLegalEntityLegalID(eDMRequest.getDataSubjectLegalPerson().getLegalID());
            this.legalPersonFVBean.setLegalEntityLegalIDScheme(eDMRequest.getDataSubjectLegalPerson().getLegalIDSchemeID());
            this.legalPersonFVBean.setLegalEntityID(eDMRequest.getDataSubjectLegalPerson().getID());
            this.legalPersonFVBean.setLegalEntityIDScheme(eDMRequest.getDataSubjectLegalPerson().getIDSchemeID());
            this.legalPersonFVBean.setLegalEntityName(eDMRequest.getDataSubjectLegalPerson().getLegalName());
            addressBean = new AddressBean();
            assert (eDMRequest.getDataSubjectLegalPerson().getAddress() != null);
            addressBean.setAddressFullAddress(eDMRequest.getDataSubjectLegalPerson().getAddress().getFullAddress());
            addressBean.setAddressLocatorDesignator(eDMRequest.getDataSubjectLegalPerson().getAddress().getStreetName());
            addressBean.setAddressThoroughfare(eDMRequest.getDataSubjectLegalPerson().getAddress().getBuildingNumber());
            addressBean.setAddressPostName(eDMRequest.getDataSubjectLegalPerson().getAddress().getTown());
            addressBean.setAddressAdminUnitFirstline(eDMRequest.getDataSubjectLegalPerson().getAddress().getCountryCode());
            addressBean.setAddressPostCode(eDMRequest.getDataSubjectLegalPerson().getAddress().getPostalCode());
            this.legalPersonFVBean.setAddress(addressBean);
        }
    }

    public void resetValuesConceptQuery(EDMRequest eDMRequest) {
        if (eDMRequest.getProcedure() != null) {
            this.conceptQueryFVBean.setProcedure(((LocalizedStringType)eDMRequest.getProcedure().getLocalizedString().get(0)).getValue());
        }
        this.conceptQueryFVBean.setDatasetIdentifier(eDMRequest.getDatasetIdentifier());
        this.conceptQueryFVBean.setSpecificationIdentifier(eDMRequest.getSpecificationIdentifier());
        this.conceptQueryFVBean.setConsentToken(eDMRequest.getConsentToken());
        EDMRequestPayloadConcepts eDMRequestPayloadConcepts = (EDMRequestPayloadConcepts)eDMRequest.getPayloadProvider();
        List list = eDMRequestPayloadConcepts.getAllConcepts().stream().map(conceptPojo -> conceptPojo.getName()).collect(Collectors.toList());
        list.addAll(((ConceptPojo)eDMRequestPayloadConcepts.getAllConcepts().get(0)).getAllChildren().stream().map(conceptPojo -> conceptPojo.getName()).collect(Collectors.toList()));
        this.conceptQueryFVBean.setConceptRequestList(list);
    }

    public void resendDocumentQuery(EDMRequest eDMRequest, DSDDatasetResponseDto dSDDatasetResponseDto) {
        this.resetBeans();
        this.resetValuesDocumentQuery(eDMRequest);
        this.resetValuesDataSubject(eDMRequest);
        LOGGER.debug("Resend document query message: ");
        EDMRequest.BuilderDocumentsByDistribution builderDocumentsByDistribution = EDMRequest.builderDocumentsByDistribution();
        this.addCommonSlots(builderDocumentsByDistribution);
        this.addDataSubject(builderDocumentsByDistribution);
        this.addDistribution(builderDocumentsByDistribution);
        eDMRequest = ((EDMRequest.BuilderDocumentsByDistribution)builderDocumentsByDistribution.randomID()).build();
        this.submitRequest(eDMRequest, dSDDatasetResponseDto);
    }

    public void resendDocumentQueryByID(EDMRequest eDMRequest, DSDDatasetResponseDto dSDDatasetResponseDto) {
        this.resetBeans();
        this.resetValuesDocumentQuery(eDMRequest);
        LOGGER.debug("Resend document query message: ");
        EDMRequest.BuilderDocumentByID builderDocumentByID = EDMRequest.builderDocumentByID();
        this.addCommonSlots(builderDocumentByID);
        this.addDocumentID(builderDocumentByID, ((IEDMRequestPayloadDocumentID)eDMRequest.getPayloadProvider()).getDocumentID());
        eDMRequest = ((EDMRequest.BuilderDocumentByID)builderDocumentByID.randomID()).build();
        this.submitRequest(eDMRequest, dSDDatasetResponseDto);
    }

    public void resetValuesDocumentQuery(EDMRequest eDMRequest) {
        this.documentQueryFVBean.setProcedure(eDMRequest.getProcedure().toString());
        this.documentQueryFVBean.setDatasetIdentifier(eDMRequest.getDatasetIdentifier());
        this.documentQueryFVBean.setSpecificationIdentifier(eDMRequest.getSpecificationIdentifier());
        this.documentQueryFVBean.setConsentToken(eDMRequest.getConsentToken());
        if (eDMRequest.getQueryDefinition().getID().equals(EToopQueryDefinitionType.DOCUMENT_BY_ID.getID())) {
            EDMRequestPayloadDocumentID eDMRequestPayloadDocumentID = (EDMRequestPayloadDocumentID)eDMRequest.getPayloadProvider();
            this.documentQueryFVBean.setDocumentID(eDMRequestPayloadDocumentID.getDocumentID());
        } else if (eDMRequest.getQueryDefinition().getID().equals(EToopQueryDefinitionType.DOCUMENT_BY_DISTRIBUTION.getID())) {
            EDMRequestPayloadDistribution eDMRequestPayloadDistribution = (EDMRequestPayloadDistribution)eDMRequest.getPayloadProvider();
            this.documentQueryFVBean.setDistributionList((List)eDMRequestPayloadDistribution.getAllDistributions());
        }
    }

    public void resetBeans() {
        this.conceptQueryFVBean = new ConceptQueryFVBean();
        this.documentQueryFVBean = new DocumentQueryFVBean();
        this.naturalPersonFVBean = new NaturalPersonFVBean();
        this.legalPersonFVBean = new LegalPersonFVBean();
        this.naturalPersonARFVBean = new NaturalPersonFVBean();
        this.view.resetBeans(this.legalPersonFVBean, this.naturalPersonFVBean, this.naturalPersonARFVBean, this.conceptQueryFVBean, this.documentQueryFVBean);
    }

    public void importResponseFromUpload(MemoryBuffer memoryBuffer) {
        EDMResponse eDMResponse = (EDMResponse)EDMResponse.reader().read(memoryBuffer.getInputStream());
        this.conceptResponseFVBean.setRequestID(eDMResponse.getRequestID());
        this.conceptResponseFVBean.setDataProviderID(eDMResponse.getDataProvider().getID());
        this.conceptResponseFVBean.setDataProviderName(eDMResponse.getDataProvider().getName());
        if (eDMResponse.getAllPayloadProviders().get(0) instanceof EDMResponsePayloadConcepts) {
            EDMResponsePayloadConcepts eDMResponsePayloadConcepts = (EDMResponsePayloadConcepts)eDMResponse.getAllPayloadProviders().get(0);
            this.conceptResponseFVBean.setAllConcepts(eDMResponsePayloadConcepts.getAllConcepts());
            this.conceptResponseFVBean.setRootConcept((ConceptPojo)eDMResponsePayloadConcepts.getAllConcepts().get(0));
            this.conceptResponseFVBean.setConcepts((List)((ConceptPojo)eDMResponsePayloadConcepts.concepts().get(0)).getAllChildren());
        }
        LOGGER.debug("PARENT CONCEPT: " + ((ConceptPojo)this.conceptResponseFVBean.getAllConcepts().get(0)).getID());
        this.view.renderConceptResponse(this.conceptResponseFVBean);
    }

    public void importDocumentResponse(EDMResponse eDMResponse) {
        ArrayList<DatasetPojo> arrayList;
        this.documentResponseFVBean.setResponse(eDMResponse);
        this.documentResponseFVBean.setRequestID(eDMResponse.getRequestID());
        this.documentResponseFVBean.setDataProviderID(eDMResponse.getDataProvider().getID());
        this.documentResponseFVBean.setDataProviderName(eDMResponse.getDataProvider().getName());
        LOGGER.debug("PAYLOAD PROVIDER SIZE: " + eDMResponse.getAllPayloadProviders().size());
        if (eDMResponse.getAllPayloadProviders().get(0) instanceof IEDMResponsePayloadDocumentReference) {
            arrayList = new ArrayList<DatasetPojo>();
            for (IEDMResponsePayloadProvider iEDMResponsePayloadProvider : eDMResponse.getAllPayloadProviders()) {
                arrayList.add(((IEDMResponsePayloadDocumentReference)iEDMResponsePayloadProvider).getDataset());
                this.documentResponseFVBean.setDatasetList(arrayList);
            }
            IEDMResponsePayloadDocumentReference iEDMResponsePayloadDocumentReference = (IEDMResponsePayloadDocumentReference)eDMResponse.getAllPayloadProviders().get(0);
            this.documentResponseFVBean.setDataset(iEDMResponsePayloadDocumentReference.getDataset());
        }
        if (eDMResponse.getAllPayloadProviders().get(0) instanceof IEDMResponsePayloadDocument) {
            arrayList = new ArrayList();
            for (IEDMResponsePayloadProvider iEDMResponsePayloadProvider : eDMResponse.getAllPayloadProviders()) {
                arrayList.add(((IEDMResponsePayloadDocument)iEDMResponsePayloadProvider).getDataset());
                LOGGER.debug("DatasetList is " + arrayList);
                this.documentResponseFVBean.setDatasetList(arrayList);
            }
        }
        LOGGER.debug("Import Document Response NOT YET READY. ");
        this.view.renderDocumentResponse(this.documentResponseFVBean);
    }

    public void importDocumentResponse(EDMResponseWithAttachment eDMResponseWithAttachment) {
        ArrayList<DatasetPojo> arrayList;
        this.documentResponseFVBean.setResponseWithAttachment(eDMResponseWithAttachment);
        this.documentResponseFVBean.setRequestID(eDMResponseWithAttachment.getEdmResponse().getRequestID());
        this.documentResponseFVBean.setDataProviderID(eDMResponseWithAttachment.getEdmResponse().getDataProvider().getID());
        this.documentResponseFVBean.setDataProviderName(eDMResponseWithAttachment.getEdmResponse().getDataProvider().getName());
        LOGGER.debug("PAYLOAD PROVIDER SIZE: " + eDMResponseWithAttachment.getEdmResponse().getAllPayloadProviders().size());
        if (eDMResponseWithAttachment.getEdmResponse().getAllPayloadProviders().get(0) instanceof IEDMResponsePayloadDocumentReference) {
            arrayList = new ArrayList<DatasetPojo>();
            for (IEDMResponsePayloadProvider iEDMResponsePayloadProvider : eDMResponseWithAttachment.getEdmResponse().getAllPayloadProviders()) {
                arrayList.add(((IEDMResponsePayloadDocumentReference)iEDMResponsePayloadProvider).getDataset());
                this.documentResponseFVBean.setDatasetList(arrayList);
            }
            IEDMResponsePayloadDocumentReference iEDMResponsePayloadDocumentReference = (IEDMResponsePayloadDocumentReference)eDMResponseWithAttachment.getEdmResponse().getAllPayloadProviders().get(0);
            this.documentResponseFVBean.setDataset(iEDMResponsePayloadDocumentReference.getDataset());
        }
        if (eDMResponseWithAttachment.getEdmResponse().getAllPayloadProviders().get(0) instanceof IEDMResponsePayloadDocument) {
            arrayList = new ArrayList();
            for (IEDMResponsePayloadProvider iEDMResponsePayloadProvider : eDMResponseWithAttachment.getEdmResponse().getAllPayloadProviders()) {
                arrayList.add(((IEDMResponsePayloadDocument)iEDMResponsePayloadProvider).getDataset());
                LOGGER.debug("DatasetList is " + arrayList);
                this.documentResponseFVBean.setDatasetList(arrayList);
            }
        }
        LOGGER.debug("Import Document ResponseWithAttachment. ");
        this.view.renderDocumentResponse(this.documentResponseFVBean);
    }

    public void importConceptResponse(EDMResponse eDMResponse) {
        LOGGER.debug("INSIDE importConceptResponse: ");
        this.conceptResponseFVBean.setRequestID(eDMResponse.getRequestID());
        this.conceptResponseFVBean.setDataProviderID(eDMResponse.getDataProvider().getID());
        this.conceptResponseFVBean.setDataProviderName(eDMResponse.getDataProvider().getName());
        if (eDMResponse.getAllPayloadProviders().get(0) instanceof EDMResponsePayloadConcepts) {
            IEDMResponsePayloadConcepts iEDMResponsePayloadConcepts = (IEDMResponsePayloadConcepts)eDMResponse.getAllPayloadProviders().get(0);
            this.conceptResponseFVBean.setAllConcepts(iEDMResponsePayloadConcepts.getAllConcepts());
            this.conceptResponseFVBean.setRootConcept((ConceptPojo)iEDMResponsePayloadConcepts.getAllConcepts().get(0));
            this.conceptResponseFVBean.setConcepts((List)((ConceptPojo)iEDMResponsePayloadConcepts.concepts().get(0)).getAllChildren());
        }
        this.view.renderConceptResponse(this.conceptResponseFVBean);
    }

    public void importErrorResponse(EDMErrorResponse eDMErrorResponse) {
        LOGGER.debug("INSIDE importErrorResponse: ");
        this.errorResponseFVBean.setErrorProviderID(eDMErrorResponse.getErrorProvider().getID());
        this.errorResponseFVBean.setErrorProviderName(eDMErrorResponse.getErrorProvider().getName());
        this.errorResponseFVBean.setRequestID(eDMErrorResponse.getRequestID());
        this.errorResponseFVBean.setResponseStatus(eDMErrorResponse.getResponseStatus().toString());
        this.errorResponseFVBean.setExceptionList(eDMErrorResponse.getAllExceptions());
        this.view.renderErrorResponse(this.errorResponseFVBean);
    }

    public void validateDS() {
        this.view.validateDS();
    }

    public void hasValidationErrors(boolean bl) {
        this.hasErrors = bl;
    }

    public boolean validationCheckPass() {
        return this.hasErrors;
    }
}

