/*
 * Decompiled with CFR 0.152.
 */
package eu.toop.playground.dc.ui.service;

import com.vaadin.flow.shared.Registration;
import eu.toop.edm.EDMErrorResponse;
import eu.toop.edm.EDMResponse;
import eu.toop.playground.dc.ui.model.EDMResponseWithAttachment;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum BroadcasterService {
    INSTANCE;

    private final Logger LOGGER = LoggerFactory.getLogger(BroadcasterService.class);
    private Executor executor = Executors.newSingleThreadExecutor();
    private final LinkedList<Consumer<EDMResponse>> responseListeners = new LinkedList();
    private final LinkedList<Consumer<EDMErrorResponse>> errorResponseListeners = new LinkedList();
    private final LinkedList<Consumer<EDMResponseWithAttachment>> responseWithAttachmentListeners = new LinkedList();

    public synchronized Registration registerResponse(Consumer<EDMResponse> consumer) {
        this.LOGGER.debug("Register {}", (Object)consumer.toString());
        this.responseListeners.add(consumer);
        return (Registration & Serializable)() -> {
            Class<BroadcasterService> clazz = BroadcasterService.class;
            synchronized (BroadcasterService.class) {
                this.LOGGER.debug("Removing {}", (Object)consumer.toString());
                this.responseListeners.remove(consumer);
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
        };
    }

    public synchronized Registration registerErrorResponse(Consumer<EDMErrorResponse> consumer) {
        this.LOGGER.debug("Register {}", (Object)consumer.toString());
        this.errorResponseListeners.add(consumer);
        return (Registration & Serializable)() -> {
            Class<BroadcasterService> clazz = BroadcasterService.class;
            synchronized (BroadcasterService.class) {
                this.LOGGER.debug("Removing {}", (Object)consumer.toString());
                this.errorResponseListeners.remove(consumer);
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
        };
    }

    public synchronized Registration registerResponseWithAttachment(Consumer<EDMResponseWithAttachment> consumer) {
        this.LOGGER.debug("Register {}", (Object)consumer.toString());
        this.responseWithAttachmentListeners.add(consumer);
        return (Registration & Serializable)() -> {
            Class<BroadcasterService> clazz = BroadcasterService.class;
            synchronized (BroadcasterService.class) {
                this.LOGGER.debug("Removing {}", (Object)consumer.toString());
                this.responseWithAttachmentListeners.remove(consumer);
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
        };
    }

    public synchronized void broadcast(EDMResponse eDMResponse) {
        this.LOGGER.debug("Broadcasting {}", (Object)eDMResponse.getRequestID());
        for (Consumer consumer : this.responseListeners) {
            this.LOGGER.debug("Broadcasting to {}", (Object)consumer);
            this.executor.execute(() -> consumer.accept(eDMResponse));
        }
    }

    public synchronized void broadcast(EDMErrorResponse eDMErrorResponse) {
        this.LOGGER.debug("Broadcasting {}", (Object)eDMErrorResponse.getRequestID());
        for (Consumer consumer : this.errorResponseListeners) {
            this.LOGGER.debug("Broadcasting to {}", (Object)consumer);
            this.executor.execute(() -> consumer.accept(eDMErrorResponse));
        }
    }

    public synchronized void broadcast(EDMResponseWithAttachment eDMResponseWithAttachment) {
        this.LOGGER.debug("Broadcasting {}", (Object)eDMResponseWithAttachment.getEdmResponse().getRequestID());
        for (Consumer consumer : this.responseWithAttachmentListeners) {
            this.LOGGER.debug("Broadcasting to {}", (Object)consumer);
            this.executor.execute(() -> consumer.accept(eDMResponseWithAttachment));
        }
    }
}

