/*
 * Decompiled with CFR 0.152.
 */
package eu.toop.playground.dc.ui.service;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.helger.commons.error.level.EErrorLevel;
import com.helger.commons.error.level.IErrorLevel;
import com.helger.commons.mime.CMimeType;
import eu.toop.connector.api.me.EMEProtocol;
import eu.toop.connector.api.rest.TCOutgoingMessage;
import eu.toop.connector.api.rest.TCOutgoingMetadata;
import eu.toop.connector.api.rest.TCPayload;
import eu.toop.connector.api.rest.TCRestJAXB;
import eu.toop.edm.EDMRequest;
import eu.toop.kafkaclient.ToopKafkaClient;
import eu.toop.playground.dc.config.enums.DCConfig;
import eu.toop.playground.dc.ui.model.dto.DSDDatasetResponseDto;
import eu.toop.playground.dc.ui.model.dto.DSDIDTypeDto;
import eu.toop.playground.dc.ui.model.exceptions.EvaluationException;
import eu.toop.playground.dc.ui.service.ConnectionService;
import eu.toop.playground.dc.util.MessageDumper;
import eu.toop.playground.dc.util.MessageType;
import java.io.IOException;
import java.io.InputStream;
import org.apache.http.HttpEntity;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionService {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)ConnectionService.class.getName());

    public void submit(EDMRequest eDMRequest, DSDDatasetResponseDto dSDDatasetResponseDto) throws IOException, EvaluationException {
        if (DCConfig.INSTANCE.useDirectSubmit()) {
            this.submitDirect(eDMRequest);
        } else {
            this.submitThroughInfrastructure(eDMRequest, dSDDatasetResponseDto);
        }
    }

    public void submit(EDMRequest eDMRequest) throws IOException, EvaluationException {
        if (DCConfig.INSTANCE.useDirectSubmit()) {
            this.submitDirect(eDMRequest);
        } else {
            this.submitThroughInfrastructure(eDMRequest);
        }
    }

    private void submitDirect(EDMRequest eDMRequest) throws IOException {
        try (CloseableHttpClient closeableHttpClient = HttpClients.createDefault();){
            HttpPost httpPost = new HttpPost(DCConfig.INSTANCE.getSubmitRequestURL());
            httpPost.setHeader("Content-Type", "application/xml");
            httpPost.setEntity((HttpEntity)new InputStreamEntity((InputStream)eDMRequest.getWriter().getAsInputStream()));
            closeableHttpClient.execute((HttpUriRequest)httpPost);
        }
    }

    private void submitThroughInfrastructure(EDMRequest eDMRequest) throws IOException, EvaluationException {
        DSDDatasetResponseDto dSDDatasetResponseDto = new DSDDatasetResponseDto(new DSDIDTypeDto(DCConfig.INSTANCE.getDefaultEloniaDevParticipantIdScheme(), DCConfig.INSTANCE.getDefaultEloniaDevParticipantIdValue()), null, null, null, null, null);
        this.submitThroughInfrastructure(eDMRequest, dSDDatasetResponseDto);
    }

    private void submitThroughInfrastructure(EDMRequest eDMRequest, DSDDatasetResponseDto dSDDatasetResponseDto) throws IOException, EvaluationException {
        LOGGER.info("Sending EDMRequest through infrastructure...");
        TCOutgoingMessage tCOutgoingMessage = new TCOutgoingMessage();
        TCOutgoingMetadata tCOutgoingMetadata = new TCOutgoingMetadata();
        tCOutgoingMetadata.setSenderID(TCRestJAXB.createTCID((String)DCConfig.INSTANCE.getDefaultFreedoniaDCSenderIdScheme(), (String)DCConfig.INSTANCE.getDefaultFreedoniaDCSenderIdValue()));
        tCOutgoingMetadata.setReceiverID(TCRestJAXB.createTCID((String)dSDDatasetResponseDto.getParticipantId().getScheme(), (String)dSDDatasetResponseDto.getParticipantId().getValue()));
        tCOutgoingMetadata.setDocTypeID(TCRestJAXB.createTCID((String)dSDDatasetResponseDto.getDoctypeId().getScheme(), (String)dSDDatasetResponseDto.getDoctypeId().getValue()));
        switch (1.$SwitchMap$eu$toop$edm$model$EToopQueryDefinitionType[eDMRequest.getQueryDefinition().ordinal()]) {
            case 1: {
                tCOutgoingMetadata.setProcessID(TCRestJAXB.createTCID((String)"toop-procid-agreement", (String)"urn:eu.toop.process.dataquery"));
                break;
            }
            case 2: 
            case 3: {
                tCOutgoingMetadata.setProcessID(TCRestJAXB.createTCID((String)"toop-procid-agreement", (String)"urn:eu.toop.process.documentquery"));
            }
        }
        tCOutgoingMetadata.setTransportProtocol(EMEProtocol.AS4.getTransportProfileID());
        tCOutgoingMessage.setMetadata(tCOutgoingMetadata);
        ToopKafkaClient.send((IErrorLevel)EErrorLevel.INFO, (String)"Freedonia DC Sending an EDMRequest through infrastructure...");
        ToopKafkaClient.send((IErrorLevel)EErrorLevel.INFO, (String)("Freedonia DC Sending an EDMRequest with sender " + tCOutgoingMetadata.getSenderID().getValue()));
        ToopKafkaClient.send((IErrorLevel)EErrorLevel.INFO, (String)("Freedonia DC Sending an EDMRequest with receiver " + tCOutgoingMetadata.getReceiverID().getValue()));
        ToopKafkaClient.send((IErrorLevel)EErrorLevel.INFO, (String)("Freedonia DC Sending an EDMRequest with docTypeID " + tCOutgoingMetadata.getDocTypeID().getValue()));
        TCPayload tCPayload = new TCPayload();
        tCPayload.setValue(eDMRequest.getWriter().getAsBytes());
        tCPayload.setMimeType(CMimeType.APPLICATION_XML.getAsString());
        tCPayload.setContentID(String.format("%s@%s", eDMRequest.getRequestID(), "freedonia-dev"));
        tCOutgoingMessage.addPayload(tCPayload);
        MessageDumper.dumpMessage((byte[])TCRestJAXB.outgoingMessage().getAsBytes((Object)tCOutgoingMessage), (MessageType)MessageType.OUTGOING);
        try (CloseableHttpClient closeableHttpClient = HttpClients.createDefault();){
            HttpPost httpPost = new HttpPost(DCConfig.INSTANCE.getSubmitRequestURL());
            httpPost.setEntity((HttpEntity)new ByteArrayEntity(TCRestJAXB.outgoingMessage().getAsBytes((Object)tCOutgoingMessage)));
            CloseableHttpResponse closeableHttpResponse = closeableHttpClient.execute((HttpUriRequest)httpPost);
            int n = closeableHttpResponse.getStatusLine().getStatusCode();
            JsonNode jsonNode = new ObjectMapper().readTree(closeableHttpResponse.getEntity().getContent());
            MessageDumper.dumpMessage((String)jsonNode.toPrettyString(), (MessageType)MessageType.INCOMING);
            if (n != 204 && n != 200) {
                ToopKafkaClient.send((IErrorLevel)EErrorLevel.ERROR, (String)("Freedonia DC failed to send an EDMRequest with status code: " + n));
                throw new ClientProtocolException("Unable to send request to the connector. Unexpected response status: " + n + " from: " + DCConfig.INSTANCE.getSubmitRequestURL());
            }
            LOGGER.info("Freedonia DC sent an EDMRequest successfully.");
            ToopKafkaClient.send((IErrorLevel)EErrorLevel.INFO, (String)"Freedonia DC sent an EDMRequest successfully.");
            this.evaluateTCResponse(jsonNode);
        }
    }

    private void evaluateTCResponse(JsonNode jsonNode) throws IOException, EvaluationException {
        LOGGER.debug("Evaluating TC Response JSON...");
        boolean bl = jsonNode.get("validation-results").get("success").asBoolean();
        LOGGER.debug("The validation results success status is= {}", (Object)bl);
        if (!bl) {
            ToopKafkaClient.send((IErrorLevel)EErrorLevel.ERROR, (String)"The created EDM Request failed to pass the validation...");
            throw new EvaluationException("The created EDM Request failed to pass the validation...");
        }
        boolean bl2 = jsonNode.get("lookup-results").get("success").asBoolean();
        LOGGER.debug("The lookup results success status is= {}", (Object)bl2);
        if (!bl2) {
            ToopKafkaClient.send((IErrorLevel)EErrorLevel.ERROR, (String)"DP Routing Metadata was not found in SMP...");
            throw new EvaluationException("DP Routing Metadata was not found in SMP...");
        }
        boolean bl3 = jsonNode.get("sending-results").get("success").asBoolean();
        LOGGER.debug("The sending result success status is= {}", (Object)bl3);
        if (!bl3) {
            ToopKafkaClient.send((IErrorLevel)EErrorLevel.ERROR, (String)"The created EDM Request failed to send to DP...");
            throw new EvaluationException("The created EDM Request failed to send to DP...");
        }
    }
}

