/*
 * Decompiled with CFR 0.152.
 */
package eu.toop.playground.dc.ui.util;

import eu.toop.edm.model.AddressPojo;
import eu.toop.edm.model.AgentPojo;
import eu.toop.edm.model.BusinessPojo;
import eu.toop.edm.model.ConceptPojo;
import eu.toop.edm.model.PersonPojo;
import eu.toop.edm.pilot.gbm.EToopConcept;
import eu.toop.playground.dc.ui.model.AddressBean;
import eu.toop.playground.dc.ui.model.LegalPersonFVBean;
import eu.toop.playground.dc.ui.model.NaturalPersonFVBean;
import java.util.List;
import javax.xml.namespace.QName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageCreation {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)MessageCreation.class.getName());

    public static AgentPojo createDataConsumer() {
        return AgentPojo.builder().address(AddressPojo.builder().town("FreedoniaTown").streetName("FreedoniaStreet").buildingNumber("55").countryCode("PF").fullAddress("FreedoniaStreet 55, 11155, FreedoniaTown, PF").postalCode("11134").build()).name("Freedonia Data Consumer System").id("PF730757727").idSchemeID("VATRegistration").build();
    }

    public static PersonPojo createNaturalPerson(NaturalPersonFVBean naturalPersonFVBean, AddressBean addressBean) {
        return PersonPojo.builder().address(AddressPojo.builder().town(addressBean.getAddressPostName()).streetName(addressBean.getAddressThoroughfare()).buildingNumber(addressBean.getAddressLocatorDesignator()).countryCode(addressBean.getAddressAdminUnitFirstline()).fullAddress(addressBean.getAddressFullAddress()).postalCode(addressBean.getAddressPostCode()).build()).birthDate(naturalPersonFVBean.getPersonBirthDate()).birthTown(naturalPersonFVBean.getPersonPlaceOfBirthAddressPostName()).birthName(naturalPersonFVBean.getPersonBirthName()).familyName(naturalPersonFVBean.getPersonFamilyName()).genderCode(naturalPersonFVBean.getPersonGenderCode()).givenName(naturalPersonFVBean.getPersonGivenName()).id(naturalPersonFVBean.getPersonID()).idSchemeID(naturalPersonFVBean.getPersonIDScheme()).build();
    }

    public static BusinessPojo createLegalPerson(LegalPersonFVBean legalPersonFVBean, AddressBean addressBean) {
        return BusinessPojo.builder().address(AddressPojo.builder().town(addressBean.getAddressPostName()).streetName(addressBean.getAddressThoroughfare()).buildingNumber(addressBean.getAddressLocatorDesignator()).countryCode(addressBean.getAddressAdminUnitFirstline()).fullAddress(addressBean.getAddressFullAddress()).postalCode(addressBean.getAddressPostCode()).build()).legalID(legalPersonFVBean.getLegalEntityLegalID()).legalIDSchemeID(legalPersonFVBean.getLegalEntityLegalIDScheme()).legalName(legalPersonFVBean.getLegalEntityName()).id(legalPersonFVBean.getLegalEntityID()).idSchemeID(legalPersonFVBean.getLegalEntityIDScheme()).build();
    }

    public static ConceptPojo createConceptRequestList(List<String> list) {
        ConceptPojo.Builder builder = new ConceptPojo.Builder();
        builder.randomID().name("http://toop.eu/registered-organization", EToopConcept.REGISTERED_ORGANIZATION.getID());
        for (String string : list) {
            builder.addChild(ConceptPojo.builder().randomID().name("http://toop.eu/registered-organization", string).build());
        }
        return builder.build();
    }

    public static ConceptPojo createConceptRequestListFromQName(List<QName> list) {
        ConceptPojo.Builder builder = new ConceptPojo.Builder();
        QName qName = null;
        if (qName == null) {
            for (QName qName2 : list) {
                if (!qName2.getLocalPart().equals("RegisteredOrganization")) continue;
                builder.randomID().name(qName2);
                qName = qName2;
            }
        }
        for (QName qName2 : list) {
            if (qName2.equals(qName)) continue;
            builder.addChild(ConceptPojo.builder().randomID().name(qName2).build());
        }
        return builder.build();
    }
}

