
package eu.toop.edm.jaxb.cccev;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.namespace.QName;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import eu.toop.edm.jaxb.cv.cbc.DescriptionType;
import eu.toop.edm.jaxb.cv.cbc.IDType;
import eu.toop.edm.jaxb.cv.cbc.NameType;
import eu.toop.edm.jaxb.cv.cbc.TypeType;
import eu.toop.edm.jaxb.owl.ThingType;


/**
 * <p>Java class for ConceptType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="ConceptType"&gt;
 *   &lt;complexContent&gt;
 *     &lt;extension base="{http://www.w3.org/2002/07/owl#}ThingType"&gt;
 *       &lt;sequence&gt;
 *         &lt;element ref="{https://data.europe.eu/semanticassets/ns/cv/common/cbc_v2.0.0#}id" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element ref="{https://data.europe.eu/semanticassets/ns/cv/common/cbc_v2.0.0#}name" minOccurs="0"/&gt;
 *         &lt;element ref="{https://data.europe.eu/semanticassets/ns/cv/common/cbc_v2.0.0#}description" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element ref="{https://data.europe.eu/semanticassets/ns/cv/common/cbc_v2.0.0#}type" minOccurs="0"/&gt;
 *         &lt;element ref="{https://data.europe.eu/semanticassets/ns/cv/common/cbc_v2.0.0#}qName" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element ref="{https://data.europe.eu/semanticassets/ns/cv/cccev_v2.0.0#}constraint" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element ref="{https://data.europe.eu/semanticassets/ns/cv/cccev_v2.0.0#}value" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element ref="{https://data.europe.eu/semanticassets/ns/cv/cccev_v2.0.0#}concept" maxOccurs="unbounded" minOccurs="0"/&gt;
 *       &lt;/sequence&gt;
 *     &lt;/extension&gt;
 *   &lt;/complexContent&gt;
 * &lt;/complexType&gt;
 * </pre>
 * <p>This class was annotated by ph-jaxb22-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-list-extension</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-value-extender</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "ConceptType", propOrder = {
    "id",
    "name",
    "description",
    "type",
    "qName",
    "constraint",
    "value",
    "concept"
})
@CodingStyleguideUnaware
public class CCCEVConceptType
    extends ThingType
{

    @XmlElement(namespace = "https://data.europe.eu/semanticassets/ns/cv/common/cbc_v2.0.0#")
    private List<IDType> id;
    @XmlElement(namespace = "https://data.europe.eu/semanticassets/ns/cv/common/cbc_v2.0.0#")
    private NameType name;
    @XmlElement(namespace = "https://data.europe.eu/semanticassets/ns/cv/common/cbc_v2.0.0#")
    private List<DescriptionType> description;
    @XmlElement(namespace = "https://data.europe.eu/semanticassets/ns/cv/common/cbc_v2.0.0#")
    private TypeType type;
    @XmlElement(namespace = "https://data.europe.eu/semanticassets/ns/cv/common/cbc_v2.0.0#")
    private List<QName> qName;
    private List<CCCEVConstraintType> constraint;
    private List<CCCEVValueType> value;
    private List<CCCEVConceptType> concept;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     */
    public CCCEVConceptType() {
    }

    /**
     * Constructor for value of type List<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     */
    public CCCEVConceptType(
        @Nullable
        final List<CCCEVValueType> valueParam) {
        setValue(valueParam);
    }

    /**
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;an:DataProperty xmlns:an="https://data.europe.eu/semanticassets/ns/cv/common/semic-annot-2.0.0#" xmlns="https://data.europe.eu/semanticassets/ns/cv/cccev_v2.0.0#" xmlns:cac="https://data.europe.eu/semanticassets/ns/cv/common/cac_v2.0.0#" xmlns:cbc="https://data.europe.eu/semanticassets/ns/cv/common/cbc_v2.0.0#" xmlns:ccts="urn:un:unece:uncefact:data:specification:CoreComponentTypeSchemaModule:2" xmlns:dcat-ap="http://data.europa.eu/r5r/" xmlns:foaf="http://xmlns.com/foaf/0.1/" xmlns:owl="http://www.w3.org/2002/07/owl#" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;Data property&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;cccev:Concept. identifier&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;
     * 										A unique value, in the context of use, assigned to the instance of this property or to one of its subproperties.
     * 									&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..*&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;cccev:Concept&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTerm&gt;Identifier&lt;/ccts:PropertyTerm&gt;&lt;ccts:RepresentationTerm&gt;Identifier&lt;/ccts:RepresentationTerm&gt;&lt;ccts:DataType&gt;ID. Type&lt;/ccts:DataType&gt;&lt;/an:DataProperty&gt;
     * </pre>
     * Gets the value of the id property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the id property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getId().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link IDType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<IDType> getId() {
        if (id == null) {
            id = new ArrayList<IDType>();
        }
        return this.id;
    }

    /**
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;an:DataProperty xmlns:an="https://data.europe.eu/semanticassets/ns/cv/common/semic-annot-2.0.0#" xmlns="https://data.europe.eu/semanticassets/ns/cv/cccev_v2.0.0#" xmlns:cac="https://data.europe.eu/semanticassets/ns/cv/common/cac_v2.0.0#" xmlns:cbc="https://data.europe.eu/semanticassets/ns/cv/common/cbc_v2.0.0#" xmlns:ccts="urn:un:unece:uncefact:data:specification:CoreComponentTypeSchemaModule:2" xmlns:dcat-ap="http://data.europa.eu/r5r/" xmlns:foaf="http://xmlns.com/foaf/0.1/" xmlns:owl="http://www.w3.org/2002/07/owl#" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;Data property&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;cccev:Concept. name&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;
     * 										The preferred label used to identify the instance of this class or of one of its subclasses.
     * 									&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..1&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;cccev:Concept&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTerm&gt;Text&lt;/ccts:PropertyTerm&gt;&lt;ccts:RepresentationTerm&gt;Text&lt;/ccts:RepresentationTerm&gt;&lt;ccts:DataType&gt;Name. Type&lt;/ccts:DataType&gt;&lt;/an:DataProperty&gt;
     * </pre>
     * 
     * 
     * @return
     *     possible object is
     *     {@link NameType }
     *     
     */
    @Nullable
    public NameType getName() {
        return name;
    }

    /**
     * Sets the value of the name property.
     * 
     * @param value
     *     allowed object is
     *     {@link NameType }
     *     
     */
    public void setName(
        @Nullable
        NameType value) {
        this.name = value;
    }

    /**
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;an:DataProperty xmlns:an="https://data.europe.eu/semanticassets/ns/cv/common/semic-annot-2.0.0#" xmlns="https://data.europe.eu/semanticassets/ns/cv/cccev_v2.0.0#" xmlns:cac="https://data.europe.eu/semanticassets/ns/cv/common/cac_v2.0.0#" xmlns:cbc="https://data.europe.eu/semanticassets/ns/cv/common/cbc_v2.0.0#" xmlns:ccts="urn:un:unece:uncefact:data:specification:CoreComponentTypeSchemaModule:2" xmlns:dcat-ap="http://data.europa.eu/r5r/" xmlns:foaf="http://xmlns.com/foaf/0.1/" xmlns:owl="http://www.w3.org/2002/07/owl#" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;Data property&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;cccev:Concept. description&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;
     * 										A short explanation about the nature, attributes, uses or any other additional information that helps clarify the understanding of the concept being instantiated. 
     * 									&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..*&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;cccev:Concept&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTerm&gt;Text&lt;/ccts:PropertyTerm&gt;&lt;ccts:RepresentationTerm&gt;Text&lt;/ccts:RepresentationTerm&gt;&lt;ccts:DataType&gt;Description. Type&lt;/ccts:DataType&gt;&lt;/an:DataProperty&gt;
     * </pre>
     * Gets the value of the description property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the description property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getDescription().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link DescriptionType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<DescriptionType> getDescription() {
        if (description == null) {
            description = new ArrayList<DescriptionType>();
        }
        return this.description;
    }

    /**
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;an:DataProperty xmlns:an="https://data.europe.eu/semanticassets/ns/cv/common/semic-annot-2.0.0#" xmlns="https://data.europe.eu/semanticassets/ns/cv/cccev_v2.0.0#" xmlns:cac="https://data.europe.eu/semanticassets/ns/cv/common/cac_v2.0.0#" xmlns:cbc="https://data.europe.eu/semanticassets/ns/cv/common/cbc_v2.0.0#" xmlns:ccts="urn:un:unece:uncefact:data:specification:CoreComponentTypeSchemaModule:2" xmlns:dcat-ap="http://data.europa.eu/r5r/" xmlns:foaf="http://xmlns.com/foaf/0.1/" xmlns:owl="http://www.w3.org/2002/07/owl#" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;Data property&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;cccev:Concept. type&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;
     * 										The identifier representing the division within a system of classification to which the instance of this class belongs.
     * 										Additional information
     * 										The classification system is normally a controlled vocabulary (e.g. a codelist or a taxonomy) the use of which is commonly agreed by a community of users in the context of a business or problem domain.
     * 										&lt;DefinitionSource&gt;based on sense #2 of the Merriam-Webster English dictionary.&lt;/DefinitionSource&gt;&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..1&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;cccev:Concept&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTerm&gt;Code&lt;/ccts:PropertyTerm&gt;&lt;ccts:RepresentationTerm&gt;Code&lt;/ccts:RepresentationTerm&gt;&lt;ccts:DataType&gt;Type. Type&lt;/ccts:DataType&gt;&lt;/an:DataProperty&gt;
     * </pre>
     * 
     * 
     * @return
     *     possible object is
     *     {@link TypeType }
     *     
     */
    @Nullable
    public TypeType getType() {
        return type;
    }

    /**
     * Sets the value of the type property.
     * 
     * @param value
     *     allowed object is
     *     {@link TypeType }
     *     
     */
    public void setType(
        @Nullable
        TypeType value) {
        this.type = value;
    }

    /**
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;an:DataProperty xmlns:an="https://data.europe.eu/semanticassets/ns/cv/common/semic-annot-2.0.0#" xmlns="https://data.europe.eu/semanticassets/ns/cv/cccev_v2.0.0#" xmlns:cac="https://data.europe.eu/semanticassets/ns/cv/common/cac_v2.0.0#" xmlns:cbc="https://data.europe.eu/semanticassets/ns/cv/common/cbc_v2.0.0#" xmlns:ccts="urn:un:unece:uncefact:data:specification:CoreComponentTypeSchemaModule:2" xmlns:dcat-ap="http://data.europa.eu/r5r/" xmlns:foaf="http://xmlns.com/foaf/0.1/" xmlns:owl="http://www.w3.org/2002/07/owl#" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;Data property&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;cccev:Concept. QName&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;
     * 										Standing for ‘qualified name’. Mechanism used to identify concisely and unambiguously an entity, i.e. a class or a property.
     * 										Additional information:
     * 										Qualified names are pairs of {namespace URI, entity local name} where the namespace URI is usually replaced by a ‘prefix’, as in cccev:Criterion, xsd:int, or dcat:Dataset.
     * 										&lt;DefinitionSource&gt;Based on the W3C definition of QNames for XML: https://www.w3.org/2001/tag/doc/qnameids.html#sec-qnames-other&lt;/DefinitionSource&gt;&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..*&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;cccev:Concept&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTerm&gt;anySimpleType&lt;/ccts:PropertyTerm&gt;&lt;ccts:RepresentationTerm&gt;anySimpleType&lt;/ccts:RepresentationTerm&gt;&lt;ccts:DataType&gt;qName. Type&lt;/ccts:DataType&gt;&lt;/an:DataProperty&gt;
     * </pre>
     * Gets the value of the qName property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the qName property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getQName().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link QName }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<QName> getQName() {
        if (qName == null) {
            qName = new ArrayList<QName>();
        }
        return this.qName;
    }

    /**
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ObjectProperty xmlns="https://data.europe.eu/semanticassets/ns/cv/cccev_v2.0.0#" xmlns:an="https://data.europe.eu/semanticassets/ns/cv/common/semic-annot-2.0.0#" xmlns:cac="https://data.europe.eu/semanticassets/ns/cv/common/cac_v2.0.0#" xmlns:cbc="https://data.europe.eu/semanticassets/ns/cv/common/cbc_v2.0.0#" xmlns:ccts="urn:un:unece:uncefact:data:specification:CoreComponentTypeSchemaModule:2" xmlns:dcat-ap="http://data.europa.eu/r5r/" xmlns:foaf="http://xmlns.com/foaf/0.1/" xmlns:owl="http://www.w3.org/2002/07/owl#" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;Object property&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;cccev:Concept. constraint&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;A reference to a limitation applied to a requirement or to a concept the requirement is about.&lt;/ccts:Definition&gt;&lt;ccts:ObjectClass&gt;cccev:Concept&lt;/ccts:ObjectClass&gt;&lt;Domain&gt;cccev:Concept&lt;/Domain&gt;&lt;Range&gt;cccev:Constraint&lt;/Range&gt;&lt;Predicate&gt;cccev:hasConstraint&lt;/Predicate&gt;&lt;Axiom&gt;owl:inverseOf :isConstraintOn&lt;/Axiom&gt;&lt;/ObjectProperty&gt;
     * </pre>
     * Gets the value of the constraint property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the constraint property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getConstraint().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link CCCEVConstraintType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<CCCEVConstraintType> getConstraint() {
        if (constraint == null) {
            constraint = new ArrayList<CCCEVConstraintType>();
        }
        return this.constraint;
    }

    /**
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ObjectProperty xmlns="https://data.europe.eu/semanticassets/ns/cv/cccev_v2.0.0#" xmlns:an="https://data.europe.eu/semanticassets/ns/cv/common/semic-annot-2.0.0#" xmlns:cac="https://data.europe.eu/semanticassets/ns/cv/common/cac_v2.0.0#" xmlns:cbc="https://data.europe.eu/semanticassets/ns/cv/common/cbc_v2.0.0#" xmlns:ccts="urn:un:unece:uncefact:data:specification:CoreComponentTypeSchemaModule:2" xmlns:dcat-ap="http://data.europa.eu/r5r/" xmlns:foaf="http://xmlns.com/foaf/0.1/" xmlns:owl="http://www.w3.org/2002/07/owl#" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;Object property&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;cccev:Concept. value&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;
     * 										A datum. 
     * 										Additional information:
     * 										In the CCCEV the datum is always associated (or referred) to a concept defined in a specific namespace. The namespace is expected to be de-referenceable
     * 										and to provide the definition and type of the datum.
     * 									&lt;/ccts:Definition&gt;&lt;ccts:ObjectClass&gt;cccev:Concept&lt;/ccts:ObjectClass&gt;&lt;Domain&gt;cccev:Concept&lt;/Domain&gt;&lt;Range&gt;Value&lt;/Range&gt;&lt;Predicate&gt;cccev:hasValue&lt;/Predicate&gt;&lt;Axiom&gt;owl:inverseOf :isValueOf&lt;/Axiom&gt;&lt;/ObjectProperty&gt;
     * </pre>
     * Gets the value of the value property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the value property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getValue().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link CCCEVValueType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<CCCEVValueType> getValue() {
        if (value == null) {
            value = new ArrayList<CCCEVValueType>();
        }
        return this.value;
    }

    /**
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ObjectProperty xmlns="https://data.europe.eu/semanticassets/ns/cv/cccev_v2.0.0#" xmlns:an="https://data.europe.eu/semanticassets/ns/cv/common/semic-annot-2.0.0#" xmlns:cac="https://data.europe.eu/semanticassets/ns/cv/common/cac_v2.0.0#" xmlns:cbc="https://data.europe.eu/semanticassets/ns/cv/common/cbc_v2.0.0#" xmlns:ccts="urn:un:unece:uncefact:data:specification:CoreComponentTypeSchemaModule:2" xmlns:dcat-ap="http://data.europa.eu/r5r/" xmlns:foaf="http://xmlns.com/foaf/0.1/" xmlns:owl="http://www.w3.org/2002/07/owl#" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;Object property&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;cccev:Concept. concept&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;
     * 										A reference to an entity, i.e. a class or a property, which is defined in a known ontology or vocabulary.
     * 										Additional information:
     * 										Used mainly to specify data being required.
     * 									&lt;/ccts:Definition&gt;&lt;ccts:ObjectClass&gt;cccev:Concept&lt;/ccts:ObjectClass&gt;&lt;Domain&gt;cccev:Concept&lt;/Domain&gt;&lt;Range&gt;cccev:Concept&lt;/Range&gt;&lt;Predicate&gt;cccev:hasConcept&lt;/Predicate&gt;&lt;/ObjectProperty&gt;
     * </pre>
     * Gets the value of the concept property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the concept property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getConcept().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link CCCEVConceptType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<CCCEVConceptType> getConcept() {
        if (concept == null) {
            concept = new ArrayList<CCCEVConceptType>();
        }
        return this.concept;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if (!super.equals(o)) {
            return false;
        }
        final CCCEVConceptType rhs = ((CCCEVConceptType) o);
        if (!EqualsHelper.equalsCollection(concept, rhs.concept)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(constraint, rhs.constraint)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(description, rhs.description)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(id, rhs.id)) {
            return false;
        }
        if (!EqualsHelper.equals(name, rhs.name)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(qName, rhs.qName)) {
            return false;
        }
        if (!EqualsHelper.equals(type, rhs.type)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(value, rhs.value)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return HashCodeGenerator.getDerived(super.hashCode()).append(concept).append(constraint).append(description).append(id).append(name).append(qName).append(type).append(value).getHashCode();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("concept", concept).append("constraint", constraint).append("description", description).append("id", id).append("name", name).append("qName", qName).append("type", type).append("value", value).getToString();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setId(
        @Nullable
        final List<IDType> aList) {
        id = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setDescription(
        @Nullable
        final List<DescriptionType> aList) {
        description = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setQName(
        @Nullable
        final List<QName> aList) {
        qName = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setConstraint(
        @Nullable
        final List<CCCEVConstraintType> aList) {
        constraint = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setValue(
        @Nullable
        final List<CCCEVValueType> aList) {
        value = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setConcept(
        @Nullable
        final List<CCCEVConceptType> aList) {
        concept = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasIdEntries() {
        return (!getId().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoIdEntries() {
        return getId().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getIdCount() {
        return getId().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public IDType getIdAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getId().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addId(
        @Nonnull
        final IDType elem) {
        getId().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasDescriptionEntries() {
        return (!getDescription().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoDescriptionEntries() {
        return getDescription().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getDescriptionCount() {
        return getDescription().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public DescriptionType getDescriptionAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getDescription().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addDescription(
        @Nonnull
        final DescriptionType elem) {
        getDescription().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasQNameEntries() {
        return (!getQName().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoQNameEntries() {
        return getQName().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getQNameCount() {
        return getQName().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public QName getQNameAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getQName().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addQName(
        @Nonnull
        final QName elem) {
        getQName().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasConstraintEntries() {
        return (!getConstraint().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoConstraintEntries() {
        return getConstraint().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getConstraintCount() {
        return getConstraint().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public CCCEVConstraintType getConstraintAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getConstraint().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addConstraint(
        @Nonnull
        final CCCEVConstraintType elem) {
        getConstraint().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasValueEntries() {
        return (!getValue().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoValueEntries() {
        return getValue().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getValueCount() {
        return getValue().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public CCCEVValueType getValueAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getValue().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addValue(
        @Nonnull
        final CCCEVValueType elem) {
        getValue().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasConceptEntries() {
        return (!getConcept().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoConceptEntries() {
        return getConcept().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getConceptCount() {
        return getConcept().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public CCCEVConceptType getConceptAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getConcept().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addConcept(
        @Nonnull
        final CCCEVConceptType elem) {
        getConcept().add(elem);
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb22-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        CCCEVConceptType ret) {
        super.cloneTo(ret);
        if (concept == null) {
            ret.concept = null;
        } else {
            List<CCCEVConceptType> retConcept = new ArrayList<CCCEVConceptType>();
            for (CCCEVConceptType aItem: getConcept()) {
                retConcept.add(((aItem == null)?null:aItem.clone()));
            }
            ret.concept = retConcept;
        }
        if (constraint == null) {
            ret.constraint = null;
        } else {
            List<CCCEVConstraintType> retConstraint = new ArrayList<CCCEVConstraintType>();
            for (CCCEVConstraintType aItem: getConstraint()) {
                retConstraint.add(((aItem == null)?null:aItem.clone()));
            }
            ret.constraint = retConstraint;
        }
        if (description == null) {
            ret.description = null;
        } else {
            List<DescriptionType> retDescription = new ArrayList<DescriptionType>();
            for (DescriptionType aItem: getDescription()) {
                retDescription.add(((aItem == null)?null:aItem.clone()));
            }
            ret.description = retDescription;
        }
        if (id == null) {
            ret.id = null;
        } else {
            List<IDType> retId = new ArrayList<IDType>();
            for (IDType aItem: getId()) {
                retId.add(((aItem == null)?null:aItem.clone()));
            }
            ret.id = retId;
        }
        ret.name = ((name == null)?null:name.clone());
        if (qName == null) {
            ret.qName = null;
        } else {
            List<QName> retQName = new ArrayList<QName>();
            for (QName aItem: getQName()) {
                retQName.add(aItem);
            }
            ret.qName = retQName;
        }
        ret.type = ((type == null)?null:type.clone());
        if (value == null) {
            ret.value = null;
        } else {
            List<CCCEVValueType> retValue = new ArrayList<CCCEVValueType>();
            for (CCCEVValueType aItem: getValue()) {
                retValue.add(((aItem == null)?null:aItem.clone()));
            }
            ret.value = retValue;
        }
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public CCCEVConceptType clone() {
        CCCEVConceptType ret = new CCCEVConceptType();
        cloneTo(ret);
        return ret;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type TypeType and never <code>null</code>
     */
    @Nonnull
    public TypeType setType(
        @Nullable
        final String valueParam) {
        TypeType aObj = getType();
        if (aObj == null) {
            aObj = new TypeType(valueParam);
            setType(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type NameType and never <code>null</code>
     */
    @Nonnull
    public NameType setName(
        @Nullable
        final String valueParam) {
        NameType aObj = getName();
        if (aObj == null) {
            aObj = new NameType(valueParam);
            setName(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Get the value of the contained NameType object<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained NameType object or <code>null</code>
     */
    @Nullable
    public String getNameValue() {
        NameType aObj = getName();
        return ((aObj == null)?null:aObj.getValue());
    }

    /**
     * Get the value of the contained TypeType object<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained TypeType object or <code>null</code>
     */
    @Nullable
    public String getTypeValue() {
        TypeType aObj = getType();
        return ((aObj == null)?null:aObj.getValue());
    }

}
