
package eu.toop.edm.jaxb.cccev;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import eu.toop.edm.jaxb.cv.cac.PeriodType;
import eu.toop.edm.jaxb.cv.cbc.BinaryObjectType;
import eu.toop.edm.jaxb.cv.cbc.CodeType;
import eu.toop.edm.jaxb.dcatap.DCatAPDistributionType;


/**
 * 
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;an:Class xmlns:an="https://data.europe.eu/semanticassets/ns/cv/common/semic-annot-2.0.0#" xmlns="https://data.europe.eu/semanticassets/ns/cv/cccev_v2.0.0#" xmlns:cac="https://data.europe.eu/semanticassets/ns/cv/common/cac_v2.0.0#" xmlns:cbc="https://data.europe.eu/semanticassets/ns/cv/common/cbc_v2.0.0#" xmlns:ccts="urn:un:unece:uncefact:data:specification:CoreComponentTypeSchemaModule:2" xmlns:dcat-ap="http://data.europa.eu/r5r/" xmlns:foaf="http://xmlns.com/foaf/0.1/" xmlns:owl="http://www.w3.org/2002/07/owl#" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;Class&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;cccev:DocumentReference. Details&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;A reference to a concrete manifestation of a document, or the content of the document itself.&lt;/ccts:Definition&gt;&lt;ccts:ObjectClass&gt;cccev:DocumentReference&lt;/ccts:ObjectClass&gt;&lt;PrimitiveClass&gt;dcat-ap:DistributionType&lt;/PrimitiveClass&gt;&lt;/an:Class&gt;
 * </pre>
 * 
 * 
 * <p>Java class for DocumentReferenceType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="DocumentReferenceType"&gt;
 *   &lt;complexContent&gt;
 *     &lt;extension base="{http://data.europa.eu/r5r/}DistributionType"&gt;
 *       &lt;sequence&gt;
 *         &lt;element ref="{https://data.europe.eu/semanticassets/ns/cv/common/cbc_v2.0.0#}binaryObject" minOccurs="0"/&gt;
 *         &lt;element ref="{https://data.europe.eu/semanticassets/ns/cv/cccev_v2.0.0#}associatedRoleType" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element ref="{https://data.europe.eu/semanticassets/ns/cv/cccev_v2.0.0#}statusCode" minOccurs="0"/&gt;
 *         &lt;element ref="{https://data.europe.eu/semanticassets/ns/cv/cccev_v2.0.0#}validityPeriod" minOccurs="0"/&gt;
 *       &lt;/sequence&gt;
 *     &lt;/extension&gt;
 *   &lt;/complexContent&gt;
 * &lt;/complexType&gt;
 * </pre>
 * <p>This class was annotated by ph-jaxb22-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-list-extension</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-value-extender</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "DocumentReferenceType", propOrder = {
    "binaryObject",
    "associatedRoleType",
    "statusCode",
    "validityPeriod"
})
@CodingStyleguideUnaware
public class CCCEVDocumentReferenceType
    extends DCatAPDistributionType
{

    @XmlElement(namespace = "https://data.europe.eu/semanticassets/ns/cv/common/cbc_v2.0.0#")
    private BinaryObjectType binaryObject;
    private List<CodeType> associatedRoleType;
    private CodeType statusCode;
    private PeriodType validityPeriod;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     */
    public CCCEVDocumentReferenceType() {
    }

    /**
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;an:DataProperty xmlns:an="https://data.europe.eu/semanticassets/ns/cv/common/semic-annot-2.0.0#" xmlns="https://data.europe.eu/semanticassets/ns/cv/cccev_v2.0.0#" xmlns:cac="https://data.europe.eu/semanticassets/ns/cv/common/cac_v2.0.0#" xmlns:cbc="https://data.europe.eu/semanticassets/ns/cv/common/cbc_v2.0.0#" xmlns:ccts="urn:un:unece:uncefact:data:specification:CoreComponentTypeSchemaModule:2" xmlns:dcat-ap="http://data.europa.eu/r5r/" xmlns:foaf="http://xmlns.com/foaf/0.1/" xmlns:owl="http://www.w3.org/2002/07/owl#" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;Data property&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;cccev:DocumentReference. binary Object&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;
     * 										The document's content embedded as binary object (Base64).
     * 									&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..1&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;cccev:DocumentReference&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTerm&gt;BinaryObject&lt;/ccts:PropertyTerm&gt;&lt;ccts:RepresentationTerm&gt;BinaryObject&lt;/ccts:RepresentationTerm&gt;&lt;ccts:DataType&gt;BinaryObject. Type&lt;/ccts:DataType&gt;&lt;/an:DataProperty&gt;
     * </pre>
     * 
     * 
     * @return
     *     possible object is
     *     {@link BinaryObjectType }
     *     
     */
    @Nullable
    public BinaryObjectType getBinaryObject() {
        return binaryObject;
    }

    /**
     * Sets the value of the binaryObject property.
     * 
     * @param value
     *     allowed object is
     *     {@link BinaryObjectType }
     *     
     */
    public void setBinaryObject(
        @Nullable
        BinaryObjectType value) {
        this.binaryObject = value;
    }

    /**
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;an:DataProperty xmlns:an="https://data.europe.eu/semanticassets/ns/cv/common/semic-annot-2.0.0#" xmlns="https://data.europe.eu/semanticassets/ns/cv/cccev_v2.0.0#" xmlns:cac="https://data.europe.eu/semanticassets/ns/cv/common/cac_v2.0.0#" xmlns:cbc="https://data.europe.eu/semanticassets/ns/cv/common/cbc_v2.0.0#" xmlns:ccts="urn:un:unece:uncefact:data:specification:CoreComponentTypeSchemaModule:2" xmlns:dcat-ap="http://data.europa.eu/r5r/" xmlns:foaf="http://xmlns.com/foaf/0.1/" xmlns:owl="http://www.w3.org/2002/07/owl#" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;Data property&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;cccev:DocumentReference. associated role type&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;
     * 										A code used to identify the role played by this document.
     * 									&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..*&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;cccev:DocumentReference&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTerm&gt;Code&lt;/ccts:PropertyTerm&gt;&lt;ccts:RepresentationTerm&gt;Code&lt;/ccts:RepresentationTerm&gt;&lt;ccts:DataType&gt;Code. Type&lt;/ccts:DataType&gt;&lt;/an:DataProperty&gt;
     * </pre>
     * Gets the value of the associatedRoleType property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the associatedRoleType property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getAssociatedRoleType().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link CodeType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<CodeType> getAssociatedRoleType() {
        if (associatedRoleType == null) {
            associatedRoleType = new ArrayList<CodeType>();
        }
        return this.associatedRoleType;
    }

    /**
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;an:DataProperty xmlns:an="https://data.europe.eu/semanticassets/ns/cv/common/semic-annot-2.0.0#" xmlns="https://data.europe.eu/semanticassets/ns/cv/cccev_v2.0.0#" xmlns:cac="https://data.europe.eu/semanticassets/ns/cv/common/cac_v2.0.0#" xmlns:cbc="https://data.europe.eu/semanticassets/ns/cv/common/cbc_v2.0.0#" xmlns:ccts="urn:un:unece:uncefact:data:specification:CoreComponentTypeSchemaModule:2" xmlns:dcat-ap="http://data.europa.eu/r5r/" xmlns:foaf="http://xmlns.com/foaf/0.1/" xmlns:owl="http://www.w3.org/2002/07/owl#" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;Data property&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;cccev:DocumentReference. status Code&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;
     * 										The status of a document content.
     * 									&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..1&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;cccev:DocumentReference&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTerm&gt;Code&lt;/ccts:PropertyTerm&gt;&lt;ccts:RepresentationTerm&gt;Code&lt;/ccts:RepresentationTerm&gt;&lt;ccts:DataType&gt;Code. Type&lt;/ccts:DataType&gt;&lt;/an:DataProperty&gt;
     * </pre>
     * 
     * 
     * @return
     *     possible object is
     *     {@link CodeType }
     *     
     */
    @Nullable
    public CodeType getStatusCode() {
        return statusCode;
    }

    /**
     * Sets the value of the statusCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link CodeType }
     *     
     */
    public void setStatusCode(
        @Nullable
        CodeType value) {
        this.statusCode = value;
    }

    /**
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ObjectProperty xmlns="https://data.europe.eu/semanticassets/ns/cv/cccev_v2.0.0#" xmlns:an="https://data.europe.eu/semanticassets/ns/cv/common/semic-annot-2.0.0#" xmlns:cac="https://data.europe.eu/semanticassets/ns/cv/common/cac_v2.0.0#" xmlns:cbc="https://data.europe.eu/semanticassets/ns/cv/common/cbc_v2.0.0#" xmlns:ccts="urn:un:unece:uncefact:data:specification:CoreComponentTypeSchemaModule:2" xmlns:dcat-ap="http://data.europa.eu/r5r/" xmlns:foaf="http://xmlns.com/foaf/0.1/" xmlns:owl="http://www.w3.org/2002/07/owl#" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;Object property&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;cccev:DocumentReference. validity Period&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;
     * 										The lapse of time during which something is claimed to be valid.
     * 									&lt;/ccts:Definition&gt;&lt;ccts:ObjectClass&gt;cccev:DocumentReference&lt;/ccts:ObjectClass&gt;&lt;Domain&gt;cccev:DocumentReference&lt;/Domain&gt;&lt;Range&gt;Period&lt;/Range&gt;&lt;Predicate&gt;hasValidityPeriod&lt;/Predicate&gt;&lt;/ObjectProperty&gt;
     * </pre>
     * 
     * 
     * @return
     *     possible object is
     *     {@link PeriodType }
     *     
     */
    @Nullable
    public PeriodType getValidityPeriod() {
        return validityPeriod;
    }

    /**
     * Sets the value of the validityPeriod property.
     * 
     * @param value
     *     allowed object is
     *     {@link PeriodType }
     *     
     */
    public void setValidityPeriod(
        @Nullable
        PeriodType value) {
        this.validityPeriod = value;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if (!super.equals(o)) {
            return false;
        }
        final CCCEVDocumentReferenceType rhs = ((CCCEVDocumentReferenceType) o);
        if (!EqualsHelper.equalsCollection(associatedRoleType, rhs.associatedRoleType)) {
            return false;
        }
        if (!EqualsHelper.equals(binaryObject, rhs.binaryObject)) {
            return false;
        }
        if (!EqualsHelper.equals(statusCode, rhs.statusCode)) {
            return false;
        }
        if (!EqualsHelper.equals(validityPeriod, rhs.validityPeriod)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return HashCodeGenerator.getDerived(super.hashCode()).append(associatedRoleType).append(binaryObject).append(statusCode).append(validityPeriod).getHashCode();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("associatedRoleType", associatedRoleType).append("binaryObject", binaryObject).append("statusCode", statusCode).append("validityPeriod", validityPeriod).getToString();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setAssociatedRoleType(
        @Nullable
        final List<CodeType> aList) {
        associatedRoleType = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasAssociatedRoleTypeEntries() {
        return (!getAssociatedRoleType().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoAssociatedRoleTypeEntries() {
        return getAssociatedRoleType().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getAssociatedRoleTypeCount() {
        return getAssociatedRoleType().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public CodeType getAssociatedRoleTypeAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getAssociatedRoleType().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addAssociatedRoleType(
        @Nonnull
        final CodeType elem) {
        getAssociatedRoleType().add(elem);
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb22-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        CCCEVDocumentReferenceType ret) {
        super.cloneTo(ret);
        if (associatedRoleType == null) {
            ret.associatedRoleType = null;
        } else {
            List<CodeType> retAssociatedRoleType = new ArrayList<CodeType>();
            for (CodeType aItem: getAssociatedRoleType()) {
                retAssociatedRoleType.add(((aItem == null)?null:aItem.clone()));
            }
            ret.associatedRoleType = retAssociatedRoleType;
        }
        ret.binaryObject = ((binaryObject == null)?null:binaryObject.clone());
        ret.statusCode = ((statusCode == null)?null:statusCode.clone());
        ret.validityPeriod = ((validityPeriod == null)?null:validityPeriod.clone());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public CCCEVDocumentReferenceType clone() {
        CCCEVDocumentReferenceType ret = new CCCEVDocumentReferenceType();
        cloneTo(ret);
        return ret;
    }

    /**
     * Special setter with value of type byte[]<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type BinaryObjectType and never <code>null</code>
     */
    @Nonnull
    public BinaryObjectType setBinaryObject(
        @Nullable
        final byte[] valueParam) {
        BinaryObjectType aObj = getBinaryObject();
        if (aObj == null) {
            aObj = new BinaryObjectType(valueParam);
            setBinaryObject(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type CodeType and never <code>null</code>
     */
    @Nonnull
    public CodeType setStatusCode(
        @Nullable
        final String valueParam) {
        CodeType aObj = getStatusCode();
        if (aObj == null) {
            aObj = new CodeType(valueParam);
            setStatusCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Get the value of the contained BinaryObjectType object<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained BinaryObjectType object or <code>null</code>
     */
    @Nullable
    public byte[] getBinaryObjectValue() {
        BinaryObjectType aObj = getBinaryObject();
        return ((aObj == null)?null:aObj.getValue());
    }

    /**
     * Get the value of the contained CodeType object<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained CodeType object or <code>null</code>
     */
    @Nullable
    public String getStatusCodeValue() {
        CodeType aObj = getStatusCode();
        return ((aObj == null)?null:aObj.getValue());
    }

}
