
package eu.toop.edm.jaxb.cccev;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlType;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import eu.toop.edm.jaxb.cv.cbc.CodeType;
import eu.toop.edm.jaxb.dcatap.DCatAPDatasetType;


/**
 * 
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;an:Class xmlns:an="https://data.europe.eu/semanticassets/ns/cv/common/semic-annot-2.0.0#" xmlns="https://data.europe.eu/semanticassets/ns/cv/cccev_v2.0.0#" xmlns:cac="https://data.europe.eu/semanticassets/ns/cv/common/cac_v2.0.0#" xmlns:cbc="https://data.europe.eu/semanticassets/ns/cv/common/cbc_v2.0.0#" xmlns:ccts="urn:un:unece:uncefact:data:specification:CoreComponentTypeSchemaModule:2" xmlns:dcat-ap="http://data.europa.eu/r5r/" xmlns:foaf="http://xmlns.com/foaf/0.1/" xmlns:owl="http://www.w3.org/2002/07/owl#" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;Class&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;cccev:EvidenceType. Details&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;
 * 							Information about the characteristics of an expected evidence, such as the desired content, format, source, etc.
 * 						&lt;/ccts:Definition&gt;&lt;ccts:ObjectClass&gt;cccev:EvidenceType&lt;/ccts:ObjectClass&gt;&lt;PrimitiveClass&gt;dcat-ap:Dataset&lt;/PrimitiveClass&gt;&lt;/an:Class&gt;
 * </pre>
 * 
 * 
 * <p>Java class for EvidenceTypeType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="EvidenceTypeType"&gt;
 *   &lt;complexContent&gt;
 *     &lt;extension base="{http://data.europa.eu/r5r/}DatasetType"&gt;
 *       &lt;sequence&gt;
 *         &lt;element ref="{https://data.europe.eu/semanticassets/ns/cv/cccev_v2.0.0#}evidenceTypeClassification" minOccurs="0"/&gt;
 *         &lt;element ref="{https://data.europe.eu/semanticassets/ns/cv/cccev_v2.0.0#}dataSetType" minOccurs="0"/&gt;
 *         &lt;element ref="{https://data.europe.eu/semanticassets/ns/cv/cccev_v2.0.0#}specifiedIn" maxOccurs="unbounded" minOccurs="0"/&gt;
 *       &lt;/sequence&gt;
 *     &lt;/extension&gt;
 *   &lt;/complexContent&gt;
 * &lt;/complexType&gt;
 * </pre>
 * <p>This class was annotated by ph-jaxb22-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-list-extension</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-value-extender</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "EvidenceTypeType", propOrder = {
    "evidenceTypeClassification",
    "dataSetType",
    "specifiedIn"
})
@CodingStyleguideUnaware
public class CCCEVEvidenceTypeType
    extends DCatAPDatasetType
{

    private CodeType evidenceTypeClassification;
    private CodeType dataSetType;
    private List<CCCEVConceptType> specifiedIn;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     */
    public CCCEVEvidenceTypeType() {
    }

    /**
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;an:DataProperty xmlns:an="https://data.europe.eu/semanticassets/ns/cv/common/semic-annot-2.0.0#" xmlns="https://data.europe.eu/semanticassets/ns/cv/cccev_v2.0.0#" xmlns:cac="https://data.europe.eu/semanticassets/ns/cv/common/cac_v2.0.0#" xmlns:cbc="https://data.europe.eu/semanticassets/ns/cv/common/cbc_v2.0.0#" xmlns:ccts="urn:un:unece:uncefact:data:specification:CoreComponentTypeSchemaModule:2" xmlns:dcat-ap="http://data.europa.eu/r5r/" xmlns:foaf="http://xmlns.com/foaf/0.1/" xmlns:owl="http://www.w3.org/2002/07/owl#" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;Data property&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;cccev:EvidenceType. evidence Typology&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;
     * 										A classification code to specify the layout and content expected for an evidence.
     * 									&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..1&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;cccev:EvidenceType&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTerm&gt;Code&lt;/ccts:PropertyTerm&gt;&lt;ccts:RepresentationTerm&gt;Code&lt;/ccts:RepresentationTerm&gt;&lt;ccts:DataType&gt;Code. Type&lt;/ccts:DataType&gt;&lt;/an:DataProperty&gt;
     * </pre>
     * 
     * 
     * @return
     *     possible object is
     *     {@link CodeType }
     *     
     */
    @Nullable
    public CodeType getEvidenceTypeClassification() {
        return evidenceTypeClassification;
    }

    /**
     * Sets the value of the evidenceTypeClassification property.
     * 
     * @param value
     *     allowed object is
     *     {@link CodeType }
     *     
     */
    public void setEvidenceTypeClassification(
        @Nullable
        CodeType value) {
        this.evidenceTypeClassification = value;
    }

    /**
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;an:DataProperty xmlns:an="https://data.europe.eu/semanticassets/ns/cv/common/semic-annot-2.0.0#" xmlns="https://data.europe.eu/semanticassets/ns/cv/cccev_v2.0.0#" xmlns:cac="https://data.europe.eu/semanticassets/ns/cv/common/cac_v2.0.0#" xmlns:cbc="https://data.europe.eu/semanticassets/ns/cv/common/cbc_v2.0.0#" xmlns:ccts="urn:un:unece:uncefact:data:specification:CoreComponentTypeSchemaModule:2" xmlns:dcat-ap="http://data.europa.eu/r5r/" xmlns:foaf="http://xmlns.com/foaf/0.1/" xmlns:owl="http://www.w3.org/2002/07/owl#" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;Data property&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;cccev:EvidenceType. dataset Type&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;
     * 										A classification code use to specify the machine-readability of a content.
     * 										Additional information
     * 										In the CCCEV this is used to indicate whether the types of evidences required will contain structured data or not.
     * 									&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..1&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;cccev:EvidenceType&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTerm&gt;Code&lt;/ccts:PropertyTerm&gt;&lt;ccts:RepresentationTerm&gt;Code&lt;/ccts:RepresentationTerm&gt;&lt;ccts:DataType&gt;Code. Type&lt;/ccts:DataType&gt;&lt;/an:DataProperty&gt;
     * </pre>
     * 
     * 
     * @return
     *     possible object is
     *     {@link CodeType }
     *     
     */
    @Nullable
    public CodeType getDataSetType() {
        return dataSetType;
    }

    /**
     * Sets the value of the dataSetType property.
     * 
     * @param value
     *     allowed object is
     *     {@link CodeType }
     *     
     */
    public void setDataSetType(
        @Nullable
        CodeType value) {
        this.dataSetType = value;
    }

    /**
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ObjectProperty xmlns="https://data.europe.eu/semanticassets/ns/cv/cccev_v2.0.0#" xmlns:an="https://data.europe.eu/semanticassets/ns/cv/common/semic-annot-2.0.0#" xmlns:cac="https://data.europe.eu/semanticassets/ns/cv/common/cac_v2.0.0#" xmlns:cbc="https://data.europe.eu/semanticassets/ns/cv/common/cbc_v2.0.0#" xmlns:ccts="urn:un:unece:uncefact:data:specification:CoreComponentTypeSchemaModule:2" xmlns:dcat-ap="http://data.europa.eu/r5r/" xmlns:foaf="http://xmlns.com/foaf/0.1/" xmlns:owl="http://www.w3.org/2002/07/owl#" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;Object property&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;cccev:EvidenceType. specified In&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition/&gt;&lt;ccts:ObjectClass&gt;cccev:EvidenceType&lt;/ccts:ObjectClass&gt;&lt;Domain&gt;cccev:EvidenceType&lt;/Domain&gt;&lt;Range&gt;cccev:EvidenceTypeList&lt;/Range&gt;&lt;Predicate&gt;cccev:isSpecifiedIn&lt;/Predicate&gt;&lt;Axiom&gt;owl:inverseOf :specifiesEvidenceType&lt;/Axiom&gt;&lt;/ObjectProperty&gt;
     * </pre>
     * Gets the value of the specifiedIn property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the specifiedIn property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getSpecifiedIn().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link CCCEVConceptType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<CCCEVConceptType> getSpecifiedIn() {
        if (specifiedIn == null) {
            specifiedIn = new ArrayList<CCCEVConceptType>();
        }
        return this.specifiedIn;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if (!super.equals(o)) {
            return false;
        }
        final CCCEVEvidenceTypeType rhs = ((CCCEVEvidenceTypeType) o);
        if (!EqualsHelper.equals(dataSetType, rhs.dataSetType)) {
            return false;
        }
        if (!EqualsHelper.equals(evidenceTypeClassification, rhs.evidenceTypeClassification)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(specifiedIn, rhs.specifiedIn)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return HashCodeGenerator.getDerived(super.hashCode()).append(dataSetType).append(evidenceTypeClassification).append(specifiedIn).getHashCode();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("dataSetType", dataSetType).append("evidenceTypeClassification", evidenceTypeClassification).append("specifiedIn", specifiedIn).getToString();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setSpecifiedIn(
        @Nullable
        final List<CCCEVConceptType> aList) {
        specifiedIn = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasSpecifiedInEntries() {
        return (!getSpecifiedIn().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoSpecifiedInEntries() {
        return getSpecifiedIn().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getSpecifiedInCount() {
        return getSpecifiedIn().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public CCCEVConceptType getSpecifiedInAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getSpecifiedIn().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addSpecifiedIn(
        @Nonnull
        final CCCEVConceptType elem) {
        getSpecifiedIn().add(elem);
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb22-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        CCCEVEvidenceTypeType ret) {
        super.cloneTo(ret);
        ret.dataSetType = ((dataSetType == null)?null:dataSetType.clone());
        ret.evidenceTypeClassification = ((evidenceTypeClassification == null)?null:evidenceTypeClassification.clone());
        if (specifiedIn == null) {
            ret.specifiedIn = null;
        } else {
            List<CCCEVConceptType> retSpecifiedIn = new ArrayList<CCCEVConceptType>();
            for (CCCEVConceptType aItem: getSpecifiedIn()) {
                retSpecifiedIn.add(((aItem == null)?null:aItem.clone()));
            }
            ret.specifiedIn = retSpecifiedIn;
        }
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public CCCEVEvidenceTypeType clone() {
        CCCEVEvidenceTypeType ret = new CCCEVEvidenceTypeType();
        cloneTo(ret);
        return ret;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type CodeType and never <code>null</code>
     */
    @Nonnull
    public CodeType setEvidenceTypeClassification(
        @Nullable
        final String valueParam) {
        CodeType aObj = getEvidenceTypeClassification();
        if (aObj == null) {
            aObj = new CodeType(valueParam);
            setEvidenceTypeClassification(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type CodeType and never <code>null</code>
     */
    @Nonnull
    public CodeType setDataSetType(
        @Nullable
        final String valueParam) {
        CodeType aObj = getDataSetType();
        if (aObj == null) {
            aObj = new CodeType(valueParam);
            setDataSetType(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Get the value of the contained CodeType object<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained CodeType object or <code>null</code>
     */
    @Nullable
    public String getEvidenceTypeClassificationValue() {
        CodeType aObj = getEvidenceTypeClassification();
        return ((aObj == null)?null:aObj.getValue());
    }

    /**
     * Get the value of the contained CodeType object<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained CodeType object or <code>null</code>
     */
    @Nullable
    public String getDataSetTypeValue() {
        CodeType aObj = getDataSetType();
        return ((aObj == null)?null:aObj.getValue());
    }

}
