
package eu.toop.edm.jaxb.cccev;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlType;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import eu.toop.edm.jaxb.cv.cbc.DescriptionType;
import eu.toop.edm.jaxb.cv.cbc.IDReferenceType;
import eu.toop.edm.jaxb.cv.cbc.IDType;
import eu.toop.edm.jaxb.cv.cbc.NameType;
import eu.toop.edm.jaxb.cv.cbc.TypeType;
import eu.toop.edm.jaxb.dcatap.DCatAPRelationshipType;
import eu.toop.edm.jaxb.owl.ThingType;


/**
 * <p>Java class for RequirementType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="RequirementType"&gt;
 *   &lt;complexContent&gt;
 *     &lt;extension base="{http://www.w3.org/2002/07/owl#}ThingType"&gt;
 *       &lt;sequence&gt;
 *         &lt;element ref="{https://data.europe.eu/semanticassets/ns/cv/common/cbc_v2.0.0#}id" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element ref="{https://data.europe.eu/semanticassets/ns/cv/common/cbc_v2.0.0#}name" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element ref="{https://data.europe.eu/semanticassets/ns/cv/common/cbc_v2.0.0#}description" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element ref="{https://data.europe.eu/semanticassets/ns/cv/common/cbc_v2.0.0#}type" minOccurs="0"/&gt;
 *         &lt;element ref="{https://data.europe.eu/semanticassets/ns/cv/cccev_v2.0.0#}requirement" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element ref="{https://data.europe.eu/semanticassets/ns/cv/cccev_v2.0.0#}concept" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element ref="{https://data.europe.eu/semanticassets/ns/cv/cccev_v2.0.0#}evidence" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element ref="{https://data.europe.eu/semanticassets/ns/cv/cccev_v2.0.0#}evidenceTypeCombinationList" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element ref="{https://data.europe.eu/semanticassets/ns/cv/cccev_v2.0.0#}isRequirementOf" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element ref="{https://data.europe.eu/semanticassets/ns/cv/cccev_v2.0.0#}qualifiedRelation" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element ref="{https://data.europe.eu/semanticassets/ns/cv/cccev_v2.0.0#}derivedFrom" maxOccurs="unbounded" minOccurs="0"/&gt;
 *       &lt;/sequence&gt;
 *     &lt;/extension&gt;
 *   &lt;/complexContent&gt;
 * &lt;/complexType&gt;
 * </pre>
 * <p>This class was annotated by ph-jaxb22-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-list-extension</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-value-extender</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "RequirementType", propOrder = {
    "id",
    "name",
    "description",
    "type",
    "requirement",
    "concept",
    "evidence",
    "evidenceTypeCombinationList",
    "isRequirementOf",
    "qualifiedRelation",
    "derivedFrom"
})
@XmlSeeAlso({
    CCCEVConstraintType.class,
    CCCEVCriterionType.class,
    CCCEVInformationRequirementType.class
})
@CodingStyleguideUnaware
public class CCCEVRequirementType
    extends ThingType
{

    @XmlElement(namespace = "https://data.europe.eu/semanticassets/ns/cv/common/cbc_v2.0.0#")
    private List<IDType> id;
    @XmlElement(namespace = "https://data.europe.eu/semanticassets/ns/cv/common/cbc_v2.0.0#")
    private List<NameType> name;
    @XmlElement(namespace = "https://data.europe.eu/semanticassets/ns/cv/common/cbc_v2.0.0#")
    private List<DescriptionType> description;
    @XmlElement(namespace = "https://data.europe.eu/semanticassets/ns/cv/common/cbc_v2.0.0#")
    private TypeType type;
    private List<CCCEVRequirementType> requirement;
    private List<CCCEVConceptType> concept;
    private List<CCCEVEvidenceType> evidence;
    private List<CCCEVEvidenceTypeListType> evidenceTypeCombinationList;
    private List<IDReferenceType> isRequirementOf;
    private List<DCatAPRelationshipType> qualifiedRelation;
    private List<CCCEVReferenceFrameworkType> derivedFrom;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     */
    public CCCEVRequirementType() {
    }

    /**
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;an:DataProperty xmlns:an="https://data.europe.eu/semanticassets/ns/cv/common/semic-annot-2.0.0#" xmlns="https://data.europe.eu/semanticassets/ns/cv/cccev_v2.0.0#" xmlns:cac="https://data.europe.eu/semanticassets/ns/cv/common/cac_v2.0.0#" xmlns:cbc="https://data.europe.eu/semanticassets/ns/cv/common/cbc_v2.0.0#" xmlns:ccts="urn:un:unece:uncefact:data:specification:CoreComponentTypeSchemaModule:2" xmlns:dcat-ap="http://data.europa.eu/r5r/" xmlns:foaf="http://xmlns.com/foaf/0.1/" xmlns:owl="http://www.w3.org/2002/07/owl#" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;Data property&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;Requirement. Identifier&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;
     * 										A unique value, in the context of use, assigned to the instance of this property or to one of its subproperties.
     * 									&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..*&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;cccev:Requirement&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTerm&gt;Identifier&lt;/ccts:PropertyTerm&gt;&lt;ccts:RepresentationTerm&gt;Identifier&lt;/ccts:RepresentationTerm&gt;&lt;ccts:DataType&gt;ID. Type&lt;/ccts:DataType&gt;&lt;/an:DataProperty&gt;
     * </pre>
     * Gets the value of the id property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the id property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getId().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link IDType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<IDType> getId() {
        if (id == null) {
            id = new ArrayList<IDType>();
        }
        return this.id;
    }

    /**
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;an:DataProperty xmlns:an="https://data.europe.eu/semanticassets/ns/cv/common/semic-annot-2.0.0#" xmlns="https://data.europe.eu/semanticassets/ns/cv/cccev_v2.0.0#" xmlns:cac="https://data.europe.eu/semanticassets/ns/cv/common/cac_v2.0.0#" xmlns:cbc="https://data.europe.eu/semanticassets/ns/cv/common/cbc_v2.0.0#" xmlns:ccts="urn:un:unece:uncefact:data:specification:CoreComponentTypeSchemaModule:2" xmlns:dcat-ap="http://data.europa.eu/r5r/" xmlns:foaf="http://xmlns.com/foaf/0.1/" xmlns:owl="http://www.w3.org/2002/07/owl#" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;Data property&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;cccev:Requirement. name&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;
     * 										The preferred label used to identify the instance of this class or of one of its subclasses.
     * 									&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..*&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;cccev:Requirement&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTerm&gt;Text&lt;/ccts:PropertyTerm&gt;&lt;ccts:RepresentationTerm&gt;Text&lt;/ccts:RepresentationTerm&gt;&lt;ccts:DataType&gt;Name. Type&lt;/ccts:DataType&gt;&lt;/an:DataProperty&gt;
     * </pre>
     * Gets the value of the name property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the name property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getName().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link NameType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<NameType> getName() {
        if (name == null) {
            name = new ArrayList<NameType>();
        }
        return this.name;
    }

    /**
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;an:DataProperty xmlns:an="https://data.europe.eu/semanticassets/ns/cv/common/semic-annot-2.0.0#" xmlns="https://data.europe.eu/semanticassets/ns/cv/cccev_v2.0.0#" xmlns:cac="https://data.europe.eu/semanticassets/ns/cv/common/cac_v2.0.0#" xmlns:cbc="https://data.europe.eu/semanticassets/ns/cv/common/cbc_v2.0.0#" xmlns:ccts="urn:un:unece:uncefact:data:specification:CoreComponentTypeSchemaModule:2" xmlns:dcat-ap="http://data.europa.eu/r5r/" xmlns:foaf="http://xmlns.com/foaf/0.1/" xmlns:owl="http://www.w3.org/2002/07/owl#" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;Data property&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;cccev:Requirement. description&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;
     * 										A short explanation about the nature, attributes, uses or any other additional information
     * 										that helps clarify the understanding of the concept being instantiated. 
     * 									&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..*&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;cccev:Requirement&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTerm&gt;Text&lt;/ccts:PropertyTerm&gt;&lt;ccts:RepresentationTerm&gt;Text&lt;/ccts:RepresentationTerm&gt;&lt;ccts:DataType&gt;Description. Type&lt;/ccts:DataType&gt;&lt;/an:DataProperty&gt;
     * </pre>
     * Gets the value of the description property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the description property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getDescription().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link DescriptionType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<DescriptionType> getDescription() {
        if (description == null) {
            description = new ArrayList<DescriptionType>();
        }
        return this.description;
    }

    /**
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;an:DataProperty xmlns:an="https://data.europe.eu/semanticassets/ns/cv/common/semic-annot-2.0.0#" xmlns="https://data.europe.eu/semanticassets/ns/cv/cccev_v2.0.0#" xmlns:cac="https://data.europe.eu/semanticassets/ns/cv/common/cac_v2.0.0#" xmlns:cbc="https://data.europe.eu/semanticassets/ns/cv/common/cbc_v2.0.0#" xmlns:ccts="urn:un:unece:uncefact:data:specification:CoreComponentTypeSchemaModule:2" xmlns:dcat-ap="http://data.europa.eu/r5r/" xmlns:foaf="http://xmlns.com/foaf/0.1/" xmlns:owl="http://www.w3.org/2002/07/owl#" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;Data property&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;cccev:Requirement. type&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;
     * 										The identifier representing the division within a system of classification to which the instance of this class belongs.
     * 										
     * 										Additional information
     * 										The classification system is normally a controlled vocabulary (e.g. a codelist or a taxonomy) the use of which is commonly
     * 										agreed by a community of users in the context of a business or problem domain.
     * 										&lt;DefinitionSource&gt;Based on sense #2 of the Merriam-Webster English dictionary.&lt;/DefinitionSource&gt;&lt;/ccts:Definition&gt;&lt;ccts:Cardinality&gt;0..1&lt;/ccts:Cardinality&gt;&lt;ccts:ObjectClass&gt;cccev:Requirement&lt;/ccts:ObjectClass&gt;&lt;ccts:PropertyTerm&gt;Code&lt;/ccts:PropertyTerm&gt;&lt;ccts:RepresentationTerm&gt;Code&lt;/ccts:RepresentationTerm&gt;&lt;ccts:DataType&gt;Code. Type&lt;/ccts:DataType&gt;&lt;/an:DataProperty&gt;
     * </pre>
     * 
     * 
     * @return
     *     possible object is
     *     {@link TypeType }
     *     
     */
    @Nullable
    public TypeType getType() {
        return type;
    }

    /**
     * Sets the value of the type property.
     * 
     * @param value
     *     allowed object is
     *     {@link TypeType }
     *     
     */
    public void setType(
        @Nullable
        TypeType value) {
        this.type = value;
    }

    /**
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ObjectProperty xmlns="https://data.europe.eu/semanticassets/ns/cv/cccev_v2.0.0#" xmlns:an="https://data.europe.eu/semanticassets/ns/cv/common/semic-annot-2.0.0#" xmlns:cac="https://data.europe.eu/semanticassets/ns/cv/common/cac_v2.0.0#" xmlns:cbc="https://data.europe.eu/semanticassets/ns/cv/common/cbc_v2.0.0#" xmlns:ccts="urn:un:unece:uncefact:data:specification:CoreComponentTypeSchemaModule:2" xmlns:dcat-ap="http://data.europa.eu/r5r/" xmlns:foaf="http://xmlns.com/foaf/0.1/" xmlns:owl="http://www.w3.org/2002/07/owl#" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;Object property&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;cccev:Requirement. requirement&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;
     * 										A sub-requirement with more granular detail(s) or of different nature.
     * 										Additional Information:
     * 										An example of granular sub-requirements can be a criterion defining more specific sub-criteria. Different examples
     * 										can be found in different domains and situations. Thus, in the domain of e-Procurement EU exclusion criteria
     * 										(a.k.a. ‘grounds for exclusion’), national criteria are implemented as sub-criteria ‘hierarchically descending’ from
     * 										an EU parent criterion. Neural networks can also be implemented as criteria and sub-criteria linked via the property
     * 										cccev:hasRequirement pointing to a requirement of type cccev:Criterion.
     * 										
     * 										Examples of sub requirements of different nature can a criterion that defines different types of information requirements
     * 										(e.g. evidences to support the responses to the criterion) and establishing constraints (e.g. input parameters, thresholds,
     * 										or other types of restrictions).
     * 									&lt;/ccts:Definition&gt;&lt;ccts:ObjectClass&gt;cccev:Requirement&lt;/ccts:ObjectClass&gt;&lt;Domain&gt;cccev:Requirement&lt;/Domain&gt;&lt;Range&gt;cccev:Requirement&lt;/Range&gt;&lt;Predicate&gt;hasRequirement&lt;/Predicate&gt;&lt;Axiom&gt;owl:inverseOf :isPartOfRequirement&lt;/Axiom&gt;&lt;/ObjectProperty&gt;
     * </pre>
     * Gets the value of the requirement property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the requirement property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getRequirement().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link CCCEVRequirementType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<CCCEVRequirementType> getRequirement() {
        if (requirement == null) {
            requirement = new ArrayList<CCCEVRequirementType>();
        }
        return this.requirement;
    }

    /**
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ObjectProperty xmlns="https://data.europe.eu/semanticassets/ns/cv/cccev_v2.0.0#" xmlns:an="https://data.europe.eu/semanticassets/ns/cv/common/semic-annot-2.0.0#" xmlns:cac="https://data.europe.eu/semanticassets/ns/cv/common/cac_v2.0.0#" xmlns:cbc="https://data.europe.eu/semanticassets/ns/cv/common/cbc_v2.0.0#" xmlns:ccts="urn:un:unece:uncefact:data:specification:CoreComponentTypeSchemaModule:2" xmlns:dcat-ap="http://data.europa.eu/r5r/" xmlns:foaf="http://xmlns.com/foaf/0.1/" xmlns:owl="http://www.w3.org/2002/07/owl#" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;Object property&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;cccev:Requirement. concept&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;The concept(s) used to specify the data being required.&lt;/ccts:Definition&gt;&lt;ccts:ObjectClass&gt;cccev:Requirement&lt;/ccts:ObjectClass&gt;&lt;Domain&gt;Requirement&lt;/Domain&gt;&lt;Range&gt;cccev:Concept&lt;/Range&gt;&lt;Predicate&gt;cccev:isAbout&lt;/Predicate&gt;&lt;/ObjectProperty&gt;
     * </pre>
     * Gets the value of the concept property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the concept property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getConcept().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link CCCEVConceptType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<CCCEVConceptType> getConcept() {
        if (concept == null) {
            concept = new ArrayList<CCCEVConceptType>();
        }
        return this.concept;
    }

    /**
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ObjectProperty xmlns="https://data.europe.eu/semanticassets/ns/cv/cccev_v2.0.0#" xmlns:an="https://data.europe.eu/semanticassets/ns/cv/common/semic-annot-2.0.0#" xmlns:cac="https://data.europe.eu/semanticassets/ns/cv/common/cac_v2.0.0#" xmlns:cbc="https://data.europe.eu/semanticassets/ns/cv/common/cbc_v2.0.0#" xmlns:ccts="urn:un:unece:uncefact:data:specification:CoreComponentTypeSchemaModule:2" xmlns:dcat-ap="http://data.europa.eu/r5r/" xmlns:foaf="http://xmlns.com/foaf/0.1/" xmlns:owl="http://www.w3.org/2002/07/owl#" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;Object property&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;cccev:Requirement. evidence&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;One or more evidences proving that the requirement is met or has been fulfilled.&lt;/ccts:Definition&gt;&lt;ccts:ObjectClass&gt;cccev:Requirement&lt;/ccts:ObjectClass&gt;&lt;Domain&gt;cccev:Requirement&lt;/Domain&gt;&lt;Range&gt;cccev:Evidence&lt;/Range&gt;&lt;Predicate&gt;cccev:hasSupportingEvidence&lt;/Predicate&gt;&lt;Axiom&gt;owl:inverseOf :supportsRequirement&lt;/Axiom&gt;&lt;/ObjectProperty&gt;
     * </pre>
     * Gets the value of the evidence property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the evidence property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getEvidence().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link CCCEVEvidenceType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<CCCEVEvidenceType> getEvidence() {
        if (evidence == null) {
            evidence = new ArrayList<CCCEVEvidenceType>();
        }
        return this.evidence;
    }

    /**
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ObjectProperty xmlns="https://data.europe.eu/semanticassets/ns/cv/cccev_v2.0.0#" xmlns:an="https://data.europe.eu/semanticassets/ns/cv/common/semic-annot-2.0.0#" xmlns:cac="https://data.europe.eu/semanticassets/ns/cv/common/cac_v2.0.0#" xmlns:cbc="https://data.europe.eu/semanticassets/ns/cv/common/cbc_v2.0.0#" xmlns:ccts="urn:un:unece:uncefact:data:specification:CoreComponentTypeSchemaModule:2" xmlns:dcat-ap="http://data.europa.eu/r5r/" xmlns:foaf="http://xmlns.com/foaf/0.1/" xmlns:owl="http://www.w3.org/2002/07/owl#" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;Object property&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;cccev:Requirement. evidence Type Combination List&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;
     * 										A collection, or a set of alternative collections, of references to types of evidences.
     * 										&lt;DefinitionSource&gt;Based on the e-Certis multi-domain mode.&lt;/DefinitionSource&gt;&lt;/ccts:Definition&gt;&lt;ccts:ObjectClass&gt;cccev:Requirement&lt;/ccts:ObjectClass&gt;&lt;Domain&gt;cccev:Requirement&lt;/Domain&gt;&lt;Range&gt;cccev:EvidenceTypeList&lt;/Range&gt;&lt;Predicate&gt;cccev:hasEvidenceTypeCombinationList&lt;/Predicate&gt;&lt;/ObjectProperty&gt;
     * </pre>
     * Gets the value of the evidenceTypeCombinationList property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the evidenceTypeCombinationList property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getEvidenceTypeCombinationList().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link CCCEVEvidenceTypeListType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<CCCEVEvidenceTypeListType> getEvidenceTypeCombinationList() {
        if (evidenceTypeCombinationList == null) {
            evidenceTypeCombinationList = new ArrayList<CCCEVEvidenceTypeListType>();
        }
        return this.evidenceTypeCombinationList;
    }

    /**
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ObjectProperty xmlns="https://data.europe.eu/semanticassets/ns/cv/cccev_v2.0.0#" xmlns:an="https://data.europe.eu/semanticassets/ns/cv/common/semic-annot-2.0.0#" xmlns:cac="https://data.europe.eu/semanticassets/ns/cv/common/cac_v2.0.0#" xmlns:cbc="https://data.europe.eu/semanticassets/ns/cv/common/cbc_v2.0.0#" xmlns:ccts="urn:un:unece:uncefact:data:specification:CoreComponentTypeSchemaModule:2" xmlns:dcat-ap="http://data.europa.eu/r5r/" xmlns:foaf="http://xmlns.com/foaf/0.1/" xmlns:owl="http://www.w3.org/2002/07/owl#" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;Object property&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;cccev:Requirement. part Of&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;A reference to the parent requirement a sub-requirement is part of.&lt;/ccts:Definition&gt;&lt;ccts:ObjectClass&gt;cccev:Requirement&lt;/ccts:ObjectClass&gt;&lt;Domain&gt;cccev:Requirement&lt;/Domain&gt;&lt;Range&gt;cccev:Requirement&lt;/Range&gt;&lt;Predicate&gt;cccev:isRequirementOf&lt;/Predicate&gt;&lt;Axiom&gt;owl:inverseOf :hasRequirement&lt;/Axiom&gt;&lt;/ObjectProperty&gt;
     * </pre>
     * Gets the value of the isRequirementOf property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the isRequirementOf property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getIsRequirementOf().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link IDReferenceType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<IDReferenceType> getIsRequirementOf() {
        if (isRequirementOf == null) {
            isRequirementOf = new ArrayList<IDReferenceType>();
        }
        return this.isRequirementOf;
    }

    /**
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ObjectProperty xmlns="https://data.europe.eu/semanticassets/ns/cv/cccev_v2.0.0#" xmlns:an="https://data.europe.eu/semanticassets/ns/cv/common/semic-annot-2.0.0#" xmlns:cac="https://data.europe.eu/semanticassets/ns/cv/common/cac_v2.0.0#" xmlns:cbc="https://data.europe.eu/semanticassets/ns/cv/common/cbc_v2.0.0#" xmlns:ccts="urn:un:unece:uncefact:data:specification:CoreComponentTypeSchemaModule:2" xmlns:dcat-ap="http://data.europa.eu/r5r/" xmlns:foaf="http://xmlns.com/foaf/0.1/" xmlns:owl="http://www.w3.org/2002/07/owl#" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;Object property&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;cccev:Requirement. part Of&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;A described and/or categorised relation to the instance of another Requirement class or subclass.&lt;/ccts:Definition&gt;&lt;ccts:ObjectClass&gt;cccev:Requirement&lt;/ccts:ObjectClass&gt;&lt;Domain&gt;cccev:Requirement&lt;/Domain&gt;&lt;Range&gt;dcat-ap:Relationship&lt;/Range&gt;&lt;Predicate&gt;cccev:hasQualifiedRelation&lt;/Predicate&gt;&lt;/ObjectProperty&gt;
     * </pre>
     * Gets the value of the qualifiedRelation property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the qualifiedRelation property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getQualifiedRelation().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link DCatAPRelationshipType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<DCatAPRelationshipType> getQualifiedRelation() {
        if (qualifiedRelation == null) {
            qualifiedRelation = new ArrayList<DCatAPRelationshipType>();
        }
        return this.qualifiedRelation;
    }

    /**
     * 
     * <pre>
     * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;ObjectProperty xmlns="https://data.europe.eu/semanticassets/ns/cv/cccev_v2.0.0#" xmlns:an="https://data.europe.eu/semanticassets/ns/cv/common/semic-annot-2.0.0#" xmlns:cac="https://data.europe.eu/semanticassets/ns/cv/common/cac_v2.0.0#" xmlns:cbc="https://data.europe.eu/semanticassets/ns/cv/common/cbc_v2.0.0#" xmlns:ccts="urn:un:unece:uncefact:data:specification:CoreComponentTypeSchemaModule:2" xmlns:dcat-ap="http://data.europa.eu/r5r/" xmlns:foaf="http://xmlns.com/foaf/0.1/" xmlns:owl="http://www.w3.org/2002/07/owl#" xmlns:xsd="http://www.w3.org/2001/XMLSchema"&gt;&lt;ccts:ComponentType&gt;Object property&lt;/ccts:ComponentType&gt;&lt;ccts:DictionaryEntryName&gt;cccev:Requirement. derivedFrom&lt;/ccts:DictionaryEntryName&gt;&lt;ccts:Definition&gt;A reference to the reference framework(s) a requirement is drawn from.&lt;/ccts:Definition&gt;&lt;ccts:ObjectClass&gt;cccev:Requirement&lt;/ccts:ObjectClass&gt;&lt;Domain&gt;cccev:Requirement&lt;/Domain&gt;&lt;Range&gt;cccev:ReferenceFramework&lt;/Range&gt;&lt;Predicate&gt;cccev:isDerivedFrom&lt;/Predicate&gt;&lt;/ObjectProperty&gt;
     * </pre>
     * Gets the value of the derivedFrom property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the derivedFrom property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getDerivedFrom().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link CCCEVReferenceFrameworkType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<CCCEVReferenceFrameworkType> getDerivedFrom() {
        if (derivedFrom == null) {
            derivedFrom = new ArrayList<CCCEVReferenceFrameworkType>();
        }
        return this.derivedFrom;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if (!super.equals(o)) {
            return false;
        }
        final CCCEVRequirementType rhs = ((CCCEVRequirementType) o);
        if (!EqualsHelper.equalsCollection(concept, rhs.concept)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(derivedFrom, rhs.derivedFrom)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(description, rhs.description)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(evidence, rhs.evidence)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(evidenceTypeCombinationList, rhs.evidenceTypeCombinationList)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(id, rhs.id)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(isRequirementOf, rhs.isRequirementOf)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(name, rhs.name)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(qualifiedRelation, rhs.qualifiedRelation)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(requirement, rhs.requirement)) {
            return false;
        }
        if (!EqualsHelper.equals(type, rhs.type)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return HashCodeGenerator.getDerived(super.hashCode()).append(concept).append(derivedFrom).append(description).append(evidence).append(evidenceTypeCombinationList).append(id).append(isRequirementOf).append(name).append(qualifiedRelation).append(requirement).append(type).getHashCode();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("concept", concept).append("derivedFrom", derivedFrom).append("description", description).append("evidence", evidence).append("evidenceTypeCombinationList", evidenceTypeCombinationList).append("id", id).append("isRequirementOf", isRequirementOf).append("name", name).append("qualifiedRelation", qualifiedRelation).append("requirement", requirement).append("type", type).getToString();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setId(
        @Nullable
        final List<IDType> aList) {
        id = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setName(
        @Nullable
        final List<NameType> aList) {
        name = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setDescription(
        @Nullable
        final List<DescriptionType> aList) {
        description = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setRequirement(
        @Nullable
        final List<CCCEVRequirementType> aList) {
        requirement = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setConcept(
        @Nullable
        final List<CCCEVConceptType> aList) {
        concept = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setEvidence(
        @Nullable
        final List<CCCEVEvidenceType> aList) {
        evidence = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setEvidenceTypeCombinationList(
        @Nullable
        final List<CCCEVEvidenceTypeListType> aList) {
        evidenceTypeCombinationList = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setIsRequirementOf(
        @Nullable
        final List<IDReferenceType> aList) {
        isRequirementOf = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setQualifiedRelation(
        @Nullable
        final List<DCatAPRelationshipType> aList) {
        qualifiedRelation = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setDerivedFrom(
        @Nullable
        final List<CCCEVReferenceFrameworkType> aList) {
        derivedFrom = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasIdEntries() {
        return (!getId().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoIdEntries() {
        return getId().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getIdCount() {
        return getId().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public IDType getIdAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getId().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addId(
        @Nonnull
        final IDType elem) {
        getId().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasNameEntries() {
        return (!getName().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoNameEntries() {
        return getName().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getNameCount() {
        return getName().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public NameType getNameAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getName().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addName(
        @Nonnull
        final NameType elem) {
        getName().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasDescriptionEntries() {
        return (!getDescription().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoDescriptionEntries() {
        return getDescription().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getDescriptionCount() {
        return getDescription().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public DescriptionType getDescriptionAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getDescription().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addDescription(
        @Nonnull
        final DescriptionType elem) {
        getDescription().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasRequirementEntries() {
        return (!getRequirement().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoRequirementEntries() {
        return getRequirement().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getRequirementCount() {
        return getRequirement().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public CCCEVRequirementType getRequirementAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getRequirement().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addRequirement(
        @Nonnull
        final CCCEVRequirementType elem) {
        getRequirement().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasConceptEntries() {
        return (!getConcept().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoConceptEntries() {
        return getConcept().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getConceptCount() {
        return getConcept().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public CCCEVConceptType getConceptAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getConcept().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addConcept(
        @Nonnull
        final CCCEVConceptType elem) {
        getConcept().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasEvidenceEntries() {
        return (!getEvidence().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoEvidenceEntries() {
        return getEvidence().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getEvidenceCount() {
        return getEvidence().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public CCCEVEvidenceType getEvidenceAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getEvidence().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addEvidence(
        @Nonnull
        final CCCEVEvidenceType elem) {
        getEvidence().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasEvidenceTypeCombinationListEntries() {
        return (!getEvidenceTypeCombinationList().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoEvidenceTypeCombinationListEntries() {
        return getEvidenceTypeCombinationList().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getEvidenceTypeCombinationListCount() {
        return getEvidenceTypeCombinationList().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public CCCEVEvidenceTypeListType getEvidenceTypeCombinationListAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getEvidenceTypeCombinationList().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addEvidenceTypeCombinationList(
        @Nonnull
        final CCCEVEvidenceTypeListType elem) {
        getEvidenceTypeCombinationList().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasIsRequirementOfEntries() {
        return (!getIsRequirementOf().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoIsRequirementOfEntries() {
        return getIsRequirementOf().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getIsRequirementOfCount() {
        return getIsRequirementOf().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public IDReferenceType getIsRequirementOfAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getIsRequirementOf().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addIsRequirementOf(
        @Nonnull
        final IDReferenceType elem) {
        getIsRequirementOf().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasQualifiedRelationEntries() {
        return (!getQualifiedRelation().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoQualifiedRelationEntries() {
        return getQualifiedRelation().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getQualifiedRelationCount() {
        return getQualifiedRelation().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public DCatAPRelationshipType getQualifiedRelationAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getQualifiedRelation().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addQualifiedRelation(
        @Nonnull
        final DCatAPRelationshipType elem) {
        getQualifiedRelation().add(elem);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasDerivedFromEntries() {
        return (!getDerivedFrom().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoDerivedFromEntries() {
        return getDerivedFrom().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getDerivedFromCount() {
        return getDerivedFrom().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public CCCEVReferenceFrameworkType getDerivedFromAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getDerivedFrom().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addDerivedFrom(
        @Nonnull
        final CCCEVReferenceFrameworkType elem) {
        getDerivedFrom().add(elem);
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb22-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        CCCEVRequirementType ret) {
        super.cloneTo(ret);
        if (concept == null) {
            ret.concept = null;
        } else {
            List<CCCEVConceptType> retConcept = new ArrayList<CCCEVConceptType>();
            for (CCCEVConceptType aItem: getConcept()) {
                retConcept.add(((aItem == null)?null:aItem.clone()));
            }
            ret.concept = retConcept;
        }
        if (derivedFrom == null) {
            ret.derivedFrom = null;
        } else {
            List<CCCEVReferenceFrameworkType> retDerivedFrom = new ArrayList<CCCEVReferenceFrameworkType>();
            for (CCCEVReferenceFrameworkType aItem: getDerivedFrom()) {
                retDerivedFrom.add(((aItem == null)?null:aItem.clone()));
            }
            ret.derivedFrom = retDerivedFrom;
        }
        if (description == null) {
            ret.description = null;
        } else {
            List<DescriptionType> retDescription = new ArrayList<DescriptionType>();
            for (DescriptionType aItem: getDescription()) {
                retDescription.add(((aItem == null)?null:aItem.clone()));
            }
            ret.description = retDescription;
        }
        if (evidence == null) {
            ret.evidence = null;
        } else {
            List<CCCEVEvidenceType> retEvidence = new ArrayList<CCCEVEvidenceType>();
            for (CCCEVEvidenceType aItem: getEvidence()) {
                retEvidence.add(((aItem == null)?null:aItem.clone()));
            }
            ret.evidence = retEvidence;
        }
        if (evidenceTypeCombinationList == null) {
            ret.evidenceTypeCombinationList = null;
        } else {
            List<CCCEVEvidenceTypeListType> retEvidenceTypeCombinationList = new ArrayList<CCCEVEvidenceTypeListType>();
            for (CCCEVEvidenceTypeListType aItem: getEvidenceTypeCombinationList()) {
                retEvidenceTypeCombinationList.add(((aItem == null)?null:aItem.clone()));
            }
            ret.evidenceTypeCombinationList = retEvidenceTypeCombinationList;
        }
        if (id == null) {
            ret.id = null;
        } else {
            List<IDType> retId = new ArrayList<IDType>();
            for (IDType aItem: getId()) {
                retId.add(((aItem == null)?null:aItem.clone()));
            }
            ret.id = retId;
        }
        if (isRequirementOf == null) {
            ret.isRequirementOf = null;
        } else {
            List<IDReferenceType> retIsRequirementOf = new ArrayList<IDReferenceType>();
            for (IDReferenceType aItem: getIsRequirementOf()) {
                retIsRequirementOf.add(((aItem == null)?null:aItem.clone()));
            }
            ret.isRequirementOf = retIsRequirementOf;
        }
        if (name == null) {
            ret.name = null;
        } else {
            List<NameType> retName = new ArrayList<NameType>();
            for (NameType aItem: getName()) {
                retName.add(((aItem == null)?null:aItem.clone()));
            }
            ret.name = retName;
        }
        if (qualifiedRelation == null) {
            ret.qualifiedRelation = null;
        } else {
            List<DCatAPRelationshipType> retQualifiedRelation = new ArrayList<DCatAPRelationshipType>();
            for (DCatAPRelationshipType aItem: getQualifiedRelation()) {
                retQualifiedRelation.add(((aItem == null)?null:aItem.clone()));
            }
            ret.qualifiedRelation = retQualifiedRelation;
        }
        if (requirement == null) {
            ret.requirement = null;
        } else {
            List<CCCEVRequirementType> retRequirement = new ArrayList<CCCEVRequirementType>();
            for (CCCEVRequirementType aItem: getRequirement()) {
                retRequirement.add(((aItem == null)?null:aItem.clone()));
            }
            ret.requirement = retRequirement;
        }
        ret.type = ((type == null)?null:type.clone());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public CCCEVRequirementType clone() {
        CCCEVRequirementType ret = new CCCEVRequirementType();
        cloneTo(ret);
        return ret;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type TypeType and never <code>null</code>
     */
    @Nonnull
    public TypeType setType(
        @Nullable
        final String valueParam) {
        TypeType aObj = getType();
        if (aObj == null) {
            aObj = new TypeType(valueParam);
            setType(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Get the value of the contained TypeType object<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained TypeType object or <code>null</code>
     */
    @Nullable
    public String getTypeValue() {
        TypeType aObj = getType();
        return ((aObj == null)?null:aObj.getValue());
    }

}
