
package eu.toop.edm.jaxb.cv.cac;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.NormalizedStringAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import eu.toop.edm.jaxb.cv.cbc.DescriptionType;
import eu.toop.edm.jaxb.cv.cbc.DurationMeasureType;
import eu.toop.edm.jaxb.cv.cbc.EndDateType;
import eu.toop.edm.jaxb.cv.cbc.EndTimeType;
import eu.toop.edm.jaxb.cv.cbc.StartDateType;
import eu.toop.edm.jaxb.cv.cbc.StartTimeType;
import eu.toop.edm.jaxb.owl.ThingType;


/**
 * <p>Java class for PeriodType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="PeriodType"&gt;
 *   &lt;complexContent&gt;
 *     &lt;extension base="{http://www.w3.org/2002/07/owl#}ThingType"&gt;
 *       &lt;sequence&gt;
 *         &lt;element ref="{https://data.europe.eu/semanticassets/ns/cv/common/cbc_v2.0.0#}description" maxOccurs="unbounded" minOccurs="0"/&gt;
 *         &lt;element ref="{https://data.europe.eu/semanticassets/ns/cv/common/cbc_v2.0.0#}startDate" minOccurs="0"/&gt;
 *         &lt;element ref="{https://data.europe.eu/semanticassets/ns/cv/common/cbc_v2.0.0#}startTime" minOccurs="0"/&gt;
 *         &lt;element ref="{https://data.europe.eu/semanticassets/ns/cv/common/cbc_v2.0.0#}endDate" minOccurs="0"/&gt;
 *         &lt;element ref="{https://data.europe.eu/semanticassets/ns/cv/common/cbc_v2.0.0#}endTime" minOccurs="0"/&gt;
 *         &lt;element ref="{https://data.europe.eu/semanticassets/ns/cv/common/cbc_v2.0.0#}durationMeasure" minOccurs="0"/&gt;
 *       &lt;/sequence&gt;
 *       &lt;attGroup ref="{https://data.europe.eu/semanticassets/ns/cv/common/cac_v2.0.0#}ThingAttributes"/&gt;
 *     &lt;/extension&gt;
 *   &lt;/complexContent&gt;
 * &lt;/complexType&gt;
 * </pre>
 * <p>This class was annotated by ph-jaxb22-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-list-extension</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-value-extender</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "PeriodType", propOrder = {
    "description",
    "startDate",
    "startTime",
    "endDate",
    "endTime",
    "durationMeasure"
})
@CodingStyleguideUnaware
public class PeriodType
    extends ThingType
{

    @XmlElement(namespace = "https://data.europe.eu/semanticassets/ns/cv/common/cbc_v2.0.0#")
    private List<DescriptionType> description;
    @XmlElement(namespace = "https://data.europe.eu/semanticassets/ns/cv/common/cbc_v2.0.0#")
    private StartDateType startDate;
    @XmlElement(namespace = "https://data.europe.eu/semanticassets/ns/cv/common/cbc_v2.0.0#")
    private StartTimeType startTime;
    @XmlElement(namespace = "https://data.europe.eu/semanticassets/ns/cv/common/cbc_v2.0.0#")
    private EndDateType endDate;
    @XmlElement(namespace = "https://data.europe.eu/semanticassets/ns/cv/common/cbc_v2.0.0#")
    private EndTimeType endTime;
    @XmlElement(namespace = "https://data.europe.eu/semanticassets/ns/cv/common/cbc_v2.0.0#")
    private DurationMeasureType durationMeasure;
    @XmlAttribute(name = "versionId")
    @XmlJavaTypeAdapter(NormalizedStringAdapter.class)
    @XmlSchemaType(name = "normalizedString")
    private String versionIdAttr;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     */
    public PeriodType() {
    }

    /**
     * Gets the value of the description property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the description property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getDescription().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link DescriptionType }
     * 
     * 
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<DescriptionType> getDescription() {
        if (description == null) {
            description = new ArrayList<DescriptionType>();
        }
        return this.description;
    }

    /**
     * Gets the value of the startDate property.
     * 
     * @return
     *     possible object is
     *     {@link StartDateType }
     *     
     */
    @Nullable
    public StartDateType getStartDate() {
        return startDate;
    }

    /**
     * Sets the value of the startDate property.
     * 
     * @param value
     *     allowed object is
     *     {@link StartDateType }
     *     
     */
    public void setStartDate(
        @Nullable
        StartDateType value) {
        this.startDate = value;
    }

    /**
     * Gets the value of the startTime property.
     * 
     * @return
     *     possible object is
     *     {@link StartTimeType }
     *     
     */
    @Nullable
    public StartTimeType getStartTime() {
        return startTime;
    }

    /**
     * Sets the value of the startTime property.
     * 
     * @param value
     *     allowed object is
     *     {@link StartTimeType }
     *     
     */
    public void setStartTime(
        @Nullable
        StartTimeType value) {
        this.startTime = value;
    }

    /**
     * Gets the value of the endDate property.
     * 
     * @return
     *     possible object is
     *     {@link EndDateType }
     *     
     */
    @Nullable
    public EndDateType getEndDate() {
        return endDate;
    }

    /**
     * Sets the value of the endDate property.
     * 
     * @param value
     *     allowed object is
     *     {@link EndDateType }
     *     
     */
    public void setEndDate(
        @Nullable
        EndDateType value) {
        this.endDate = value;
    }

    /**
     * Gets the value of the endTime property.
     * 
     * @return
     *     possible object is
     *     {@link EndTimeType }
     *     
     */
    @Nullable
    public EndTimeType getEndTime() {
        return endTime;
    }

    /**
     * Sets the value of the endTime property.
     * 
     * @param value
     *     allowed object is
     *     {@link EndTimeType }
     *     
     */
    public void setEndTime(
        @Nullable
        EndTimeType value) {
        this.endTime = value;
    }

    /**
     * Gets the value of the durationMeasure property.
     * 
     * @return
     *     possible object is
     *     {@link DurationMeasureType }
     *     
     */
    @Nullable
    public DurationMeasureType getDurationMeasure() {
        return durationMeasure;
    }

    /**
     * Sets the value of the durationMeasure property.
     * 
     * @param value
     *     allowed object is
     *     {@link DurationMeasureType }
     *     
     */
    public void setDurationMeasure(
        @Nullable
        DurationMeasureType value) {
        this.durationMeasure = value;
    }

    /**
     * Gets the value of the versionIdAttr property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Nullable
    public String getVersionIdAttr() {
        return versionIdAttr;
    }

    /**
     * Sets the value of the versionIdAttr property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setVersionIdAttr(
        @Nullable
        String value) {
        this.versionIdAttr = value;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if (!super.equals(o)) {
            return false;
        }
        final PeriodType rhs = ((PeriodType) o);
        if (!EqualsHelper.equalsCollection(description, rhs.description)) {
            return false;
        }
        if (!EqualsHelper.equals(durationMeasure, rhs.durationMeasure)) {
            return false;
        }
        if (!EqualsHelper.equals(endDate, rhs.endDate)) {
            return false;
        }
        if (!EqualsHelper.equals(endTime, rhs.endTime)) {
            return false;
        }
        if (!EqualsHelper.equals(startDate, rhs.startDate)) {
            return false;
        }
        if (!EqualsHelper.equals(startTime, rhs.startTime)) {
            return false;
        }
        if (!EqualsHelper.equals(versionIdAttr, rhs.versionIdAttr)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return HashCodeGenerator.getDerived(super.hashCode()).append(description).append(durationMeasure).append(endDate).append(endTime).append(startDate).append(startTime).append(versionIdAttr).getHashCode();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("description", description).append("durationMeasure", durationMeasure).append("endDate", endDate).append("endTime", endTime).append("startDate", startDate).append("startTime", startTime).append("versionIdAttr", versionIdAttr).getToString();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setDescription(
        @Nullable
        final List<DescriptionType> aList) {
        description = aList;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasDescriptionEntries() {
        return (!getDescription().isEmpty());
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoDescriptionEntries() {
        return getDescription().isEmpty();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getDescriptionCount() {
        return getDescription().size();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public DescriptionType getDescriptionAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getDescription().get(index);
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addDescription(
        @Nonnull
        final DescriptionType elem) {
        getDescription().add(elem);
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb22-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        PeriodType ret) {
        super.cloneTo(ret);
        if (description == null) {
            ret.description = null;
        } else {
            List<DescriptionType> retDescription = new ArrayList<DescriptionType>();
            for (DescriptionType aItem: getDescription()) {
                retDescription.add(((aItem == null)?null:aItem.clone()));
            }
            ret.description = retDescription;
        }
        ret.durationMeasure = ((durationMeasure == null)?null:durationMeasure.clone());
        ret.endDate = ((endDate == null)?null:endDate.clone());
        ret.endTime = ((endTime == null)?null:endTime.clone());
        ret.startDate = ((startDate == null)?null:startDate.clone());
        ret.startTime = ((startTime == null)?null:startTime.clone());
        ret.versionIdAttr = versionIdAttr;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public PeriodType clone() {
        PeriodType ret = new PeriodType();
        cloneTo(ret);
        return ret;
    }

    /**
     * Special setter with value of type LocalDate<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type StartDateType and never <code>null</code>
     */
    @Nonnull
    public StartDateType setStartDate(
        @Nullable
        final LocalDate valueParam) {
        StartDateType aObj = getStartDate();
        if (aObj == null) {
            aObj = new StartDateType(valueParam);
            setStartDate(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type LocalDate<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type EndDateType and never <code>null</code>
     */
    @Nonnull
    public EndDateType setEndDate(
        @Nullable
        final LocalDate valueParam) {
        EndDateType aObj = getEndDate();
        if (aObj == null) {
            aObj = new EndDateType(valueParam);
            setEndDate(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type DurationMeasureType and never <code>null</code>
     */
    @Nonnull
    public DurationMeasureType setDurationMeasure(
        @Nullable
        final BigDecimal valueParam) {
        DurationMeasureType aObj = getDurationMeasure();
        if (aObj == null) {
            aObj = new DurationMeasureType(valueParam);
            setDurationMeasure(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type LocalTime<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type StartTimeType and never <code>null</code>
     */
    @Nonnull
    public StartTimeType setStartTime(
        @Nullable
        final LocalTime valueParam) {
        StartTimeType aObj = getStartTime();
        if (aObj == null) {
            aObj = new StartTimeType(valueParam);
            setStartTime(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type LocalTime<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type EndTimeType and never <code>null</code>
     */
    @Nonnull
    public EndTimeType setEndTime(
        @Nullable
        final LocalTime valueParam) {
        EndTimeType aObj = getEndTime();
        if (aObj == null) {
            aObj = new EndTimeType(valueParam);
            setEndTime(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Get the value of the contained StartDateType object<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained StartDateType object or <code>null</code>
     */
    @Nullable
    public LocalDate getStartDateValue() {
        StartDateType aObj = getStartDate();
        return ((aObj == null)?null:aObj.getValue());
    }

    /**
     * Get the value of the contained StartTimeType object<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained StartTimeType object or <code>null</code>
     */
    @Nullable
    public LocalTime getStartTimeValue() {
        StartTimeType aObj = getStartTime();
        return ((aObj == null)?null:aObj.getValue());
    }

    /**
     * Get the value of the contained EndDateType object<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained EndDateType object or <code>null</code>
     */
    @Nullable
    public LocalDate getEndDateValue() {
        EndDateType aObj = getEndDate();
        return ((aObj == null)?null:aObj.getValue());
    }

    /**
     * Get the value of the contained EndTimeType object<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained EndTimeType object or <code>null</code>
     */
    @Nullable
    public LocalTime getEndTimeValue() {
        EndTimeType aObj = getEndTime();
        return ((aObj == null)?null:aObj.getValue());
    }

    /**
     * Get the value of the contained DurationMeasureType object<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained DurationMeasureType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getDurationMeasureValue() {
        DurationMeasureType aObj = getDurationMeasure();
        return ((aObj == null)?null:aObj.getValue());
    }

}
