
package eu.toop.edm.jaxb.cv.dt;

import java.io.Serializable;
import java.math.BigDecimal;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.XmlValue;
import javax.xml.bind.annotation.adapters.NormalizedStringAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;


/**
 * <p>Java class for DecimalType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="DecimalType"&gt;
 *   &lt;simpleContent&gt;
 *     &lt;extension base="&lt;http://www.w3.org/2001/XMLSchema&gt;decimal"&gt;
 *       &lt;attGroup ref="{https://data.europe.eu/semanticassets/ns/cv/common/dataTypes-2.0.0#}AssuranceLevelAttributes"/&gt;
 *     &lt;/extension&gt;
 *   &lt;/simpleContent&gt;
 * &lt;/complexType&gt;
 * </pre>
 * <p>This class was annotated by ph-jaxb22-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb22-plugin -Xph-value-extender</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "DecimalType", propOrder = {
    "value"
})
@XmlSeeAlso({
    eu.toop.edm.jaxb.cv.cbc.DecimalType.class
})
@CodingStyleguideUnaware
public class DecimalType implements Serializable, IExplicitlyCloneable
{

    @XmlValue
    private BigDecimal value;
    @XmlAttribute(name = "AssuranceLevelCodeListID")
    @XmlJavaTypeAdapter(NormalizedStringAdapter.class)
    @XmlSchemaType(name = "normalizedString")
    private String assuranceLevelCodeListID;
    @XmlAttribute(name = "AssuranceLevelCodeListVerionID")
    @XmlJavaTypeAdapter(NormalizedStringAdapter.class)
    @XmlSchemaType(name = "normalizedString")
    private String assuranceLevelCodeListVerionID;
    @XmlAttribute(name = "AssuranceLevelValue")
    @XmlJavaTypeAdapter(NormalizedStringAdapter.class)
    @XmlSchemaType(name = "normalizedString")
    private String assuranceLevelValue;
    @XmlAttribute(name = "AssuranceLevelAgencyID")
    @XmlJavaTypeAdapter(NormalizedStringAdapter.class)
    @XmlSchemaType(name = "normalizedString")
    private String assuranceLevelAgencyID;
    @XmlAttribute(name = "AssuranceLevelAgencyName")
    private String assuranceLevelAgencyName;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     */
    public DecimalType() {
    }

    /**
     * Constructor for value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb22-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     */
    public DecimalType(
        @Nullable
        final BigDecimal valueParam) {
        setValue(valueParam);
    }

    /**
     * Gets the value of the value property.
     * 
     * @return
     *     possible object is
     *     {@link BigDecimal }
     *     
     */
    @Nullable
    public BigDecimal getValue() {
        return value;
    }

    /**
     * Sets the value of the value property.
     * 
     * @param value
     *     allowed object is
     *     {@link BigDecimal }
     *     
     */
    public void setValue(
        @Nullable
        BigDecimal value) {
        this.value = value;
    }

    /**
     * Gets the value of the assuranceLevelCodeListID property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Nullable
    public String getAssuranceLevelCodeListID() {
        return assuranceLevelCodeListID;
    }

    /**
     * Sets the value of the assuranceLevelCodeListID property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setAssuranceLevelCodeListID(
        @Nullable
        String value) {
        this.assuranceLevelCodeListID = value;
    }

    /**
     * Gets the value of the assuranceLevelCodeListVerionID property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Nullable
    public String getAssuranceLevelCodeListVerionID() {
        return assuranceLevelCodeListVerionID;
    }

    /**
     * Sets the value of the assuranceLevelCodeListVerionID property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setAssuranceLevelCodeListVerionID(
        @Nullable
        String value) {
        this.assuranceLevelCodeListVerionID = value;
    }

    /**
     * Gets the value of the assuranceLevelValue property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Nullable
    public String getAssuranceLevelValue() {
        return assuranceLevelValue;
    }

    /**
     * Sets the value of the assuranceLevelValue property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setAssuranceLevelValue(
        @Nullable
        String value) {
        this.assuranceLevelValue = value;
    }

    /**
     * Gets the value of the assuranceLevelAgencyID property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Nullable
    public String getAssuranceLevelAgencyID() {
        return assuranceLevelAgencyID;
    }

    /**
     * Sets the value of the assuranceLevelAgencyID property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setAssuranceLevelAgencyID(
        @Nullable
        String value) {
        this.assuranceLevelAgencyID = value;
    }

    /**
     * Gets the value of the assuranceLevelAgencyName property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Nullable
    public String getAssuranceLevelAgencyName() {
        return assuranceLevelAgencyName;
    }

    /**
     * Sets the value of the assuranceLevelAgencyName property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setAssuranceLevelAgencyName(
        @Nullable
        String value) {
        this.assuranceLevelAgencyName = value;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if ((o == null)||(!getClass().equals(o.getClass()))) {
            return false;
        }
        final DecimalType rhs = ((DecimalType) o);
        if (!EqualsHelper.equals(assuranceLevelAgencyID, rhs.assuranceLevelAgencyID)) {
            return false;
        }
        if (!EqualsHelper.equals(assuranceLevelAgencyName, rhs.assuranceLevelAgencyName)) {
            return false;
        }
        if (!EqualsHelper.equals(assuranceLevelCodeListID, rhs.assuranceLevelCodeListID)) {
            return false;
        }
        if (!EqualsHelper.equals(assuranceLevelCodeListVerionID, rhs.assuranceLevelCodeListVerionID)) {
            return false;
        }
        if (!EqualsHelper.equals(assuranceLevelValue, rhs.assuranceLevelValue)) {
            return false;
        }
        if (!EqualsHelper.equals(value, rhs.value)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(assuranceLevelAgencyID).append(assuranceLevelAgencyName).append(assuranceLevelCodeListID).append(assuranceLevelCodeListVerionID).append(assuranceLevelValue).append(value).getHashCode();
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return new ToStringGenerator(this).append("assuranceLevelAgencyID", assuranceLevelAgencyID).append("assuranceLevelAgencyName", assuranceLevelAgencyName).append("assuranceLevelCodeListID", assuranceLevelCodeListID).append("assuranceLevelCodeListVerionID", assuranceLevelCodeListVerionID).append("assuranceLevelValue", assuranceLevelValue).append("value", value).getToString();
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb22-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        DecimalType ret) {
        ret.assuranceLevelAgencyID = assuranceLevelAgencyID;
        ret.assuranceLevelAgencyName = assuranceLevelAgencyName;
        ret.assuranceLevelCodeListID = assuranceLevelCodeListID;
        ret.assuranceLevelCodeListVerionID = assuranceLevelCodeListVerionID;
        ret.assuranceLevelValue = assuranceLevelValue;
        ret.value = value;
    }

    /**
     * Created by ph-jaxb22-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public DecimalType clone() {
        DecimalType ret = new DecimalType();
        cloneTo(ret);
        return ret;
    }

}
